/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.impl.IdEObjectCollectionImpl;
import org.eclipse.emf.emfstore.internal.common.model.util.SettingWithReferencedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemovedElementsCache {
    private final IdEObjectCollectionImpl collection;
    private final List<EObject> removedRootElements;
    private final Map<EObject, ModelElementId> removedElementsIds;
    private final Map<EObject, List<SettingWithReferencedElement>> removedElementsToReferenceSettings;

    public RemovedElementsCache(IdEObjectCollectionImpl collection) {
        this.collection = collection;
        this.removedRootElements = new ArrayList<EObject>();
        this.removedElementsIds = new HashMap<EObject, ModelElementId>();
        this.removedElementsToReferenceSettings = new LinkedHashMap<EObject, List<SettingWithReferencedElement>>();
    }

    public void addRemovedElement(EObject rootElement, Set<EObject> allModelElements, List<SettingWithReferencedElement> crossReferences) {
        this.removedRootElements.add(rootElement);
        this.removedElementsIds.put(rootElement, this.collection.getDeletedModelElementId(rootElement));
        for (EObject eObject : allModelElements) {
            this.removedElementsIds.put(eObject, this.collection.getDeletedModelElementId(eObject));
        }
        if (crossReferences.size() != 0) {
            for (EObject eObject : allModelElements) {
                this.removedElementsToReferenceSettings.put(eObject, crossReferences);
            }
        }
    }

    public List<EObject> getRemovedRootElements() {
        return this.removedRootElements;
    }

    public ModelElementId getRemovedElementId(EObject modelElement) {
        return this.removedElementsIds.get(modelElement);
    }

    public List<SettingWithReferencedElement> getRemovedRootElementToReferenceSetting(EObject modelElement) {
        return this.removedElementsToReferenceSettings.get(modelElement);
    }

    public void clear() {
        this.removedRootElements.clear();
        this.removedElementsIds.clear();
        this.removedElementsToReferenceSettings.clear();
    }
}

