/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.bowling.util;

import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeValidator;
import org.eclipse.emf.emfstore.bowling.Area;
import org.eclipse.emf.emfstore.bowling.BowlingPackage;
import org.eclipse.emf.emfstore.bowling.Fan;
import org.eclipse.emf.emfstore.bowling.Game;
import org.eclipse.emf.emfstore.bowling.Gender;
import org.eclipse.emf.emfstore.bowling.League;
import org.eclipse.emf.emfstore.bowling.Matchup;
import org.eclipse.emf.emfstore.bowling.Merchandise;
import org.eclipse.emf.emfstore.bowling.Player;
import org.eclipse.emf.emfstore.bowling.Referee;
import org.eclipse.emf.emfstore.bowling.Tournament;
import org.eclipse.emf.emfstore.bowling.TournamentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BowlingValidator
extends EObjectValidator {
    public static final BowlingValidator INSTANCE = new BowlingValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.emf.emfstore.bowling";
    public static final int PLAYER__VALIDATE = 1;
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 1;
    protected static final int DIAGNOSTIC_CODE_COUNT = 1;
    protected XMLTypeValidator xmlTypeValidator = XMLTypeValidator.INSTANCE;

    protected EPackage getEPackage() {
        return BowlingPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validatePlayer((Player)value, diagnostics, context);
            }
            case 1: {
                return this.validateLeague((League)value, diagnostics, context);
            }
            case 2: {
                return this.validateTournament((Tournament)value, diagnostics, context);
            }
            case 3: {
                return this.validateMatchup((Matchup)value, diagnostics, context);
            }
            case 4: {
                return this.validateGame((Game)value, diagnostics, context);
            }
            case 5: {
                return this.validatePlayerToPointsMap((Map.Entry)value, diagnostics, context);
            }
            case 6: {
                return this.validateReferee((Referee)value, diagnostics, context);
            }
            case 7: {
                return this.validateRefereeToGamesMap((Map.Entry)value, diagnostics, context);
            }
            case 8: {
                return this.validateArea((Area)value, diagnostics, context);
            }
            case 9: {
                return this.validateFan((Fan)value, diagnostics, context);
            }
            case 10: {
                return this.validateMerchandise((Merchandise)value, diagnostics, context);
            }
            case 11: {
                return this.validateTournamentType((TournamentType)((Object)value), diagnostics, context);
            }
            case 12: {
                return this.validateGender((Gender)((Object)value), diagnostics, context);
            }
            case 13: {
                return this.validateXMLDate((XMLGregorianCalendar)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validatePlayer(Player player, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(player, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(player, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(player, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(player, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(player, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(player, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(player, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(player, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validatePlayer_validate(player, diagnostics, context);
        }
        return result;
    }

    public boolean validatePlayer_validate(Player player, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return player.validate(diagnostics, context);
    }

    public boolean validateLeague(League league, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(league, diagnostics, context);
    }

    public boolean validateTournament(Tournament tournament, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(tournament, diagnostics, context);
    }

    public boolean validateMatchup(Matchup matchup, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(matchup, diagnostics, context);
    }

    public boolean validateGame(Game game, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(game, diagnostics, context);
    }

    public boolean validatePlayerToPointsMap(Map.Entry<?, ?> playerToPointsMap, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)playerToPointsMap, diagnostics, context);
    }

    public boolean validateReferee(Referee referee, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(referee, diagnostics, context);
    }

    public boolean validateRefereeToGamesMap(Map.Entry<?, ?> refereeToGamesMap, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)refereeToGamesMap, diagnostics, context);
    }

    public boolean validateArea(Area area, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(area, diagnostics, context);
    }

    public boolean validateFan(Fan fan, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(fan, diagnostics, context);
    }

    public boolean validateMerchandise(Merchandise merchandise, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(merchandise, diagnostics, context);
    }

    public boolean validateTournamentType(TournamentType tournamentType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateGender(Gender gender, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateXMLDate(XMLGregorianCalendar xmlDate, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

