/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.modelmutator;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.AddObjectMutation;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.AttributeChangeMutation;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.DeleteObjectMutation;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.FeatureMapKeyMutation;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.FeatureMapValueMutation;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.MoveObjectMutation;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.Mutation;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.ReferenceChangeMutation;
import org.eclipse.emf.emfstore.modelmutator.ESModelMutatorConfiguration;
import org.eclipse.emf.emfstore.modelmutator.ESModelMutatorUtil;
import org.eclipse.emf.emfstore.modelmutator.ESMutationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ESAbstractModelMutator {
    private ESModelMutatorConfiguration modelMutatorConfig;
    private final Map<EReference, List<EClass>> referencesToClasses = new LinkedHashMap<EReference, List<EClass>>();
    private final Map<EClass, List<EObject>> freeObjects = new LinkedHashMap<EClass, List<EObject>>();
    private final Map<EClass, List<EObject>> allObjects = new LinkedHashMap<EClass, List<EObject>>();
    private ESModelMutatorUtil util;
    private int currentObjectCount;
    private int targetObjectCount;
    private int currentWidth = 1;
    private int currentDepth = 1;
    private List<Mutation> defaultMutationPrototypes;

    public ESAbstractModelMutator() {
        this.modelMutatorConfig = null;
        this.util = null;
        this.targetObjectCount = -1;
    }

    public ESAbstractModelMutator(ESModelMutatorConfiguration config) {
        this.modelMutatorConfig = config;
        this.util = new ESModelMutatorUtil(config);
        this.targetObjectCount = config.getMinObjectsCount();
    }

    public abstract void preMutate();

    public abstract void postMutate();

    public void generate() {
        this.preMutate();
        while (this.currentObjectCount < this.targetObjectCount) {
            this.createChildrenForRoot();
            ++this.currentWidth;
            if (!this.randomBoolean() || !this.randomBoolean() || !this.randomBoolean()) continue;
            ++this.currentDepth;
        }
        this.postMutate();
    }

    public void mutate(Set<EStructuralFeature> ignoredFeatures) {
        if (this.modelMutatorConfig.getMutationCount() == -1) {
            this.performFullMutation(ignoredFeatures);
        } else {
            this.performConfiguredNumberOfMutations();
        }
    }

    public void mutateUntil(Predicate<EObject> predicate) {
        this.mutate(Collections.<EStructuralFeature>emptySet());
        while (!predicate.apply((Object)this.getRootEObject())) {
            this.mutate(Collections.<EStructuralFeature>emptySet());
        }
    }

    private void performFullMutation(Set<EStructuralFeature> ignoredFeatures) {
        EObject rootEObject = this.getRootEObject();
        this.deleteEObjects(rootEObject);
        this.currentObjectCount = ESModelMutatorUtil.getAllObjectsCount(rootEObject);
        this.generate();
        this.changeCrossReferences();
        this.mutateAttributes(ignoredFeatures);
    }

    protected EObject getRootEObject() {
        return this.modelMutatorConfig.getRootEObject();
    }

    private void performConfiguredNumberOfMutations() {
        List<Mutation> mutations = this.getDefaultMutationPrototypes();
        int i = 0;
        while (i < this.modelMutatorConfig.getMutationCount()) {
            int rndIdx = this.modelMutatorConfig.getRandom().nextInt(mutations.size());
            Mutation nextMutation = mutations.get(rndIdx);
            Mutation mutationToRun = nextMutation.clone();
            try {
                mutationToRun.apply();
                ++i;
            }
            catch (ESMutationException eSMutationException) {}
        }
    }

    private List<Mutation> getDefaultMutationPrototypes() {
        if (this.defaultMutationPrototypes == null) {
            this.defaultMutationPrototypes = this.createDefaultMutationPrototypes();
        }
        return this.defaultMutationPrototypes;
    }

    private List<Mutation> createDefaultMutationPrototypes() {
        ArrayList<Mutation> defaultMutationPrototypes = new ArrayList<Mutation>();
        defaultMutationPrototypes.add(new AddObjectMutation(this.util));
        defaultMutationPrototypes.add(new DeleteObjectMutation(this.util));
        defaultMutationPrototypes.add(new MoveObjectMutation(this.util));
        defaultMutationPrototypes.add(new AttributeChangeMutation(this.util));
        defaultMutationPrototypes.add(new ReferenceChangeMutation(this.util));
        defaultMutationPrototypes.add(new FeatureMapKeyMutation(this.util));
        defaultMutationPrototypes.add(new FeatureMapValueMutation(this.util));
        return defaultMutationPrototypes;
    }

    public void createChildrenForRoot() {
        EObject rootEObject = this.getRootEObject();
        if (this.modelMutatorConfig.isDoNotGenerateRoot()) {
            boolean didCreateChild = false;
            ArrayList eContents = new ArrayList(rootEObject.eContents());
            try {
                for (EObject obj : eContents) {
                    didCreateChild |= this.createChildren(obj, 1);
                }
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
            if (!didCreateChild) {
                this.createChildren(rootEObject, 0);
            }
        } else {
            this.createChildren(rootEObject, 0);
        }
    }

    public boolean createChildren(EObject root, int depth) {
        if (this.currentObjectCount >= this.targetObjectCount) {
            return false;
        }
        if (depth >= this.currentDepth) {
            return false;
        }
        List<EObject> children = this.createChildren(root);
        for (EObject obj : children) {
            this.createChildren(obj, depth + 1);
        }
        return !children.isEmpty();
    }

    public List<EObject> createChildren(EObject root) {
        ArrayList<EObject> children = new ArrayList<EObject>();
        Collection<EStructuralFeature> ignore = this.modelMutatorConfig.geteStructuralFeaturesToIgnore();
        for (EReference reference : root.eClass().getEAllContainments()) {
            int init;
            if (ignore.contains(reference) || !this.util.isValid((EStructuralFeature)reference, root)) continue;
            int i = init = this.currentWidth / 2 - root.eContents().size();
            while (i > 0) {
                EClass eClass = this.getValidEClass(reference);
                if (eClass != null) {
                    EObject obj = this.getEObject(eClass, new LinkedHashSet<EStructuralFeature>(ignore));
                    if (this.randomBoolean()) {
                        this.changeCrossReferences(obj);
                    }
                    if (reference.isMany() || i == 1) {
                        this.addToParent(root, obj, reference);
                        children.add(obj);
                        ++this.currentObjectCount;
                        this.currentObjectCount += obj.eContents().size();
                    } else {
                        this.addToEClassToObjectsMap(obj, this.freeObjects);
                    }
                    this.addToEClassToObjectsMap(obj, this.allObjects);
                    if (this.currentObjectCount >= this.targetObjectCount) {
                        return children;
                    }
                }
                --i;
            }
        }
        return children;
    }

    private boolean randomBoolean() {
        return this.modelMutatorConfig.getRandom().nextBoolean();
    }

    public void deleteEObjects(EObject root) {
        ArrayList<EObject> toDelete = new ArrayList<EObject>();
        Random random = this.modelMutatorConfig.getRandom();
        int maxDeleteCount = this.modelMutatorConfig.getMaxDeleteCount();
        int deleted = 0;
        TreeIterator it = root.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (deleted < maxDeleteCount && this.randomBoolean()) {
                toDelete.add(obj);
                ++deleted;
                this.addToEClassToObjectsMap(obj, this.freeObjects);
            }
            this.addToEClassToObjectsMap(obj, this.allObjects);
        }
        ArrayList<Integer> deleteModes = new ArrayList<Integer>();
        deleteModes.add(0);
        deleteModes.add(1);
        if (this.modelMutatorConfig.isUseEcoreUtilDelete()) {
            deleteModes.add(2);
        }
        int size = deleteModes.size();
        for (EObject obj : new ArrayList(toDelete)) {
            this.util.removeFullPerCommand(obj, (Integer)deleteModes.get(random.nextInt(size)));
        }
    }

    private void addToEClassToObjectsMap(EObject obj, Map<EClass, List<EObject>> map) {
        List<EObject> objects = map.get(obj.eClass());
        if (objects == null) {
            objects = new ArrayList<EObject>();
            map.put(obj.eClass(), objects);
        }
        objects.add(obj);
    }

    protected EClass getValidEClass(EReference reference) {
        List<EClass> classes = this.referencesToClasses.get(reference);
        if (classes == null) {
            classes = this.util.getAllEContainments(reference);
            for (EClass eClass : this.modelMutatorConfig.geteClassesToIgnore()) {
                classes.remove(eClass);
                classes.removeAll(this.util.getAllSubEClasses(eClass));
            }
            for (EClass eClass : new ArrayList<EClass>(classes)) {
                if (ESModelMutatorUtil.canHaveInstance(eClass)) continue;
                classes.remove(eClass);
            }
            if (classes.isEmpty()) {
                return null;
            }
            this.referencesToClasses.put(reference, classes);
        }
        int index = this.modelMutatorConfig.getRandom().nextInt(classes.size());
        return classes.get(index);
    }

    protected EObject getEObject(EClass eClass, Set<EStructuralFeature> ignoredFeatures) {
        Random random = this.modelMutatorConfig.getRandom();
        EObject newObject = null;
        List<EObject> objects = this.freeObjects.get(eClass);
        newObject = objects != null && objects.size() != 0 && this.randomBoolean() ? objects.remove(random.nextInt(objects.size())) : EcoreUtil.create((EClass)eClass);
        this.util.setEObjectAttributes(newObject, ignoredFeatures);
        return newObject;
    }

    protected void addToParent(EObject parent, EObject newObject, EReference reference) {
        if (reference.isMany()) {
            this.util.addPerCommand(parent, (EStructuralFeature)reference, newObject, this.randomBoolean() ? Integer.valueOf(0) : null);
        } else {
            this.util.setPerCommand(parent, (EStructuralFeature)reference, newObject);
        }
    }

    public void mutateAttributes(Set<EStructuralFeature> ignoredFeatures) {
        EObject rootEObject = this.getRootEObject();
        TreeIterator it = rootEObject.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            this.util.setEObjectAttributes(obj, ignoredFeatures);
        }
    }

    public void changeCrossReferences() {
        for (Map.Entry<EClass, List<EObject>> entry : this.allObjects.entrySet()) {
            for (EObject obj : entry.getValue()) {
                this.changeCrossReferences(obj);
            }
        }
    }

    public void changeCrossReferences(EObject obj) {
        for (EReference reference : this.util.getValidCrossReferences(obj)) {
            for (EClass referenceClass : this.util.getReferenceClasses(reference, this.allObjects.keySet())) {
                this.util.setReference(obj, referenceClass, reference, this.allObjects);
            }
        }
    }

    public ESModelMutatorConfiguration getConfig() {
        return this.modelMutatorConfig;
    }

    public void setConfig(ESModelMutatorConfiguration config) {
        this.modelMutatorConfig = config;
        this.util = new ESModelMutatorUtil(config);
        this.targetObjectCount = config.getMinObjectsCount();
    }
}

