/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.impl;

import org.eclipse.emf.emfstore.internal.client.model.CompositeOperationHandle;
import org.eclipse.emf.emfstore.internal.client.model.exceptions.InvalidHandleException;
import org.eclipse.emf.emfstore.internal.client.model.impl.ProjectSpaceBase;
import org.eclipse.emf.emfstore.internal.client.model.util.EMFStoreCommand;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.internal.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CompositeOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplyOperationsAndRecordRunnable
implements Runnable {
    private final ProjectSpaceBase projectSpace;
    private final Iterable<AbstractOperation> operations;

    public ApplyOperationsAndRecordRunnable(ProjectSpaceBase projectSpaceBase, Iterable<AbstractOperation> operations) {
        this.projectSpace = projectSpaceBase;
        this.operations = operations;
    }

    @Override
    public void run() {
        new EMFStoreCommand(){

            protected void doRun() {
                for (AbstractOperation operation : ApplyOperationsAndRecordRunnable.this.operations) {
                    try {
                        ApplyOperationsAndRecordRunnable.this.applyOperation(operation);
                    }
                    catch (RuntimeException e) {
                        WorkspaceUtil.handleException(e);
                    }
                }
            }
        }.run(false);
    }

    private void applyOperation(AbstractOperation operation) {
        this.projectSpace.getOperationManager().commandStarted(null);
        if (CompositeOperation.class.isInstance(operation)) {
            CompositeOperation compositeOperation = (CompositeOperation)CompositeOperation.class.cast(operation);
            String compositeName = compositeOperation.getCompositeName();
            CompositeOperationHandle handle = this.projectSpace.getOperationManager().beginCompositeOperation();
            operation.apply((IdEObjectCollection)this.projectSpace.getProject());
            try {
                handle.end(compositeName, "", compositeOperation.getModelElementId());
                this.projectSpace.getOperationManager().commandCompleted(null, true);
            }
            catch (InvalidHandleException ex) {
                WorkspaceUtil.logException(ex.getMessage(), ex);
            }
        } else {
            operation.apply((IdEObjectCollection)this.projectSpace.getProject());
            this.projectSpace.getOperationManager().commandCompleted(null, true);
        }
    }
}

