/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.base.recordbuffer;

import org.apache.jena.dboe.base.block.Block;
import org.apache.jena.dboe.base.record.RecordFactory;
import org.apache.jena.dboe.base.recordbuffer.RecordBufferPageBase;

public final class RecordBufferPage
extends RecordBufferPageBase {
    public static final int LINK = 4;
    private static final int FIELD_LENGTH = 4;
    private int link = -1;

    public final int getLink() {
        return this.link;
    }

    public void setLink(int link) {
        this.link = link;
        this.getBackingBlock().getByteBuffer().putInt(4, link);
    }

    @Override
    protected void _reset(Block block) {
        super.rebuild(block, this.getCount());
    }

    public static int calcRecordSize(RecordFactory factory, int blkSize) {
        return RecordBufferPageBase.calcRecordSize(factory, blkSize, 4);
    }

    public static int calcBlockSize(RecordFactory factory, int maxRec) {
        return RecordBufferPageBase.calcBlockSize(factory, maxRec, 4);
    }

    public static RecordBufferPage createBlank(Block block, RecordFactory factory) {
        int count = 0;
        int linkId = -1;
        return new RecordBufferPage(block, factory, count, linkId);
    }

    public static RecordBufferPage format(Block block, RecordFactory factory) {
        int count = block.getByteBuffer().getInt(0);
        int linkId = block.getByteBuffer().getInt(4);
        return new RecordBufferPage(block, factory, count, linkId);
    }

    private RecordBufferPage(Block block, RecordFactory factory, int count, int linkId) {
        super(block, 4, factory, count);
        this.link = linkId;
    }

    @Override
    public String toString() {
        return String.format("RecordBufferPage[id=%d,link=%d]: %s", this.getBackingBlock().getId(), this.getLink(), this.recBuff);
    }

    @Override
    public String getRefStr() {
        return String.format("RecordBufferPage[id=%d]", this.getBackingBlock().getId());
    }
}

