/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ext.xerces.impl.dv.xs;

import org.apache.jena.ext.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.jena.ext.xerces.impl.dv.ValidationContext;
import org.apache.jena.ext.xerces.impl.dv.xs.TypeValidator;

class PrecisionDecimalDV
extends TypeValidator {
    PrecisionDecimalDV() {
    }

    @Override
    public short getAllowedFacets() {
        return 4088;
    }

    @Override
    public Object getActualValue(String content, ValidationContext context2) throws InvalidDatatypeValueException {
        try {
            return new XPrecisionDecimal(content);
        }
        catch (NumberFormatException nfe) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "precisionDecimal"});
        }
    }

    @Override
    public int compare(Object value1, Object value2) {
        return ((XPrecisionDecimal)value1).compareTo((XPrecisionDecimal)value2);
    }

    @Override
    public int getFractionDigits(Object value) {
        return ((XPrecisionDecimal)value).fracDigits;
    }

    @Override
    public int getTotalDigits(Object value) {
        return ((XPrecisionDecimal)value).totalDigits;
    }

    @Override
    public boolean isIdentical(Object value1, Object value2) {
        if (!(value2 instanceof XPrecisionDecimal) || !(value1 instanceof XPrecisionDecimal)) {
            return false;
        }
        return ((XPrecisionDecimal)value1).isIdentical((XPrecisionDecimal)value2);
    }

    static class XPrecisionDecimal {
        int sign = 1;
        int totalDigits = 0;
        int intDigits = 0;
        int fracDigits = 0;
        String ivalue = "";
        String fvalue = "";
        int pvalue = 0;
        private String canonical;

        XPrecisionDecimal(String content) throws NumberFormatException {
            if (content.equals("NaN")) {
                this.ivalue = content;
                this.sign = 0;
            }
            if (content.equals("+INF") || content.equals("INF") || content.equals("-INF")) {
                this.ivalue = content.charAt(0) == '+' ? content.substring(1) : content;
                return;
            }
            this.initD(content);
        }

        void initD(String content) throws NumberFormatException {
            int actualIntStart;
            int len = content.length();
            if (len == 0) {
                throw new NumberFormatException();
            }
            int intStart = 0;
            int intEnd = 0;
            int fracStart = 0;
            int fracEnd = 0;
            if (content.charAt(0) == '+') {
                intStart = 1;
            } else if (content.charAt(0) == '-') {
                intStart = 1;
                this.sign = -1;
            }
            for (actualIntStart = intStart; actualIntStart < len && content.charAt(actualIntStart) == '0'; ++actualIntStart) {
            }
            for (intEnd = actualIntStart; intEnd < len && TypeValidator.isDigit(content.charAt(intEnd)); ++intEnd) {
            }
            if (intEnd < len) {
                if (content.charAt(intEnd) != '.' && content.charAt(intEnd) != 'E' && content.charAt(intEnd) != 'e') {
                    throw new NumberFormatException();
                }
                if (content.charAt(intEnd) == '.') {
                    for (fracEnd = fracStart = intEnd + 1; fracEnd < len && TypeValidator.isDigit(content.charAt(fracEnd)); ++fracEnd) {
                    }
                } else {
                    this.pvalue = Integer.parseInt(content.substring(intEnd + 1, len));
                }
            }
            if (intStart == intEnd && fracStart == fracEnd) {
                throw new NumberFormatException();
            }
            for (int fracPos = fracStart; fracPos < fracEnd; ++fracPos) {
                if (TypeValidator.isDigit(content.charAt(fracPos))) continue;
                throw new NumberFormatException();
            }
            this.intDigits = intEnd - actualIntStart;
            this.fracDigits = fracEnd - fracStart;
            if (this.intDigits > 0) {
                this.ivalue = content.substring(actualIntStart, intEnd);
            }
            if (this.fracDigits > 0) {
                this.fvalue = content.substring(fracStart, fracEnd);
                if (fracEnd < len) {
                    this.pvalue = Integer.parseInt(content.substring(fracEnd + 1, len));
                }
            }
            this.totalDigits = this.intDigits + this.fracDigits;
        }

        public boolean equals(Object val) {
            if (val == this) {
                return true;
            }
            if (!(val instanceof XPrecisionDecimal)) {
                return false;
            }
            XPrecisionDecimal oval = (XPrecisionDecimal)val;
            return this.compareTo(oval) == 0;
        }

        private int compareFractionalPart(XPrecisionDecimal oval) {
            if (this.fvalue.equals(oval.fvalue)) {
                return 0;
            }
            StringBuffer temp1 = new StringBuffer(this.fvalue);
            StringBuffer temp2 = new StringBuffer(oval.fvalue);
            this.truncateTrailingZeros(temp1, temp2);
            return temp1.toString().compareTo(temp2.toString());
        }

        private void truncateTrailingZeros(StringBuffer fValue, StringBuffer otherFValue) {
            int i;
            for (i = fValue.length() - 1; i >= 0 && fValue.charAt(i) == '0'; --i) {
                fValue.deleteCharAt(i);
            }
            for (i = otherFValue.length() - 1; i >= 0 && otherFValue.charAt(i) == '0'; --i) {
                otherFValue.deleteCharAt(i);
            }
        }

        public int compareTo(XPrecisionDecimal val) {
            if (this.sign == 0) {
                return 2;
            }
            if (this.ivalue.equals("INF") || val.ivalue.equals("INF")) {
                if (this.ivalue.equals(val.ivalue)) {
                    return 0;
                }
                if (this.ivalue.equals("INF")) {
                    return 1;
                }
                return -1;
            }
            if (this.ivalue.equals("-INF") || val.ivalue.equals("-INF")) {
                if (this.ivalue.equals(val.ivalue)) {
                    return 0;
                }
                if (this.ivalue.equals("-INF")) {
                    return -1;
                }
                return 1;
            }
            if (this.sign != val.sign) {
                return this.sign > val.sign ? 1 : -1;
            }
            return this.sign * this.compare(val);
        }

        private int compare(XPrecisionDecimal val) {
            if (this.pvalue != 0 || val.pvalue != 0) {
                if (this.pvalue == val.pvalue) {
                    return this.intComp(val);
                }
                if (this.intDigits + this.pvalue != val.intDigits + val.pvalue) {
                    return this.intDigits + this.pvalue > val.intDigits + val.pvalue ? 1 : -1;
                }
                if (this.pvalue > val.pvalue) {
                    int expDiff = this.pvalue - val.pvalue;
                    StringBuffer buffer = new StringBuffer(this.ivalue);
                    StringBuffer fbuffer = new StringBuffer(this.fvalue);
                    for (int i = 0; i < expDiff; ++i) {
                        if (i < this.fracDigits) {
                            buffer.append(this.fvalue.charAt(i));
                            fbuffer.deleteCharAt(i);
                            continue;
                        }
                        buffer.append('0');
                    }
                    return this.compareDecimal(buffer.toString(), val.ivalue, fbuffer.toString(), val.fvalue);
                }
                int expDiff = val.pvalue - this.pvalue;
                StringBuffer buffer = new StringBuffer(val.ivalue);
                StringBuffer fbuffer = new StringBuffer(val.fvalue);
                for (int i = 0; i < expDiff; ++i) {
                    if (i < val.fracDigits) {
                        buffer.append(val.fvalue.charAt(i));
                        fbuffer.deleteCharAt(i);
                        continue;
                    }
                    buffer.append('0');
                }
                return this.compareDecimal(this.ivalue, buffer.toString(), this.fvalue, fbuffer.toString());
            }
            return this.intComp(val);
        }

        private int intComp(XPrecisionDecimal val) {
            if (this.intDigits != val.intDigits) {
                return this.intDigits > val.intDigits ? 1 : -1;
            }
            return this.compareDecimal(this.ivalue, val.ivalue, this.fvalue, val.fvalue);
        }

        private int compareDecimal(String iValue, String fValue, String otherIValue, String otherFValue) {
            int ret = iValue.compareTo(otherIValue);
            if (ret != 0) {
                return ret > 0 ? 1 : -1;
            }
            if (fValue.equals(otherFValue)) {
                return 0;
            }
            StringBuffer temp1 = new StringBuffer(fValue);
            StringBuffer temp2 = new StringBuffer(otherFValue);
            this.truncateTrailingZeros(temp1, temp2);
            ret = temp1.toString().compareTo(temp2.toString());
            return ret == 0 ? 0 : (ret > 0 ? 1 : -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            if (this.canonical == null) {
                XPrecisionDecimal xPrecisionDecimal = this;
                synchronized (xPrecisionDecimal) {
                    if (this.canonical == null) {
                        this.makeCanonical();
                    }
                }
            }
            return this.canonical;
        }

        private void makeCanonical() {
            this.canonical = "TBD by Working Group";
        }

        public boolean isIdentical(XPrecisionDecimal decimal) {
            if (this.ivalue.equals(decimal.ivalue) && (this.ivalue.equals("INF") || this.ivalue.equals("-INF") || this.ivalue.equals("NaN"))) {
                return true;
            }
            return this.sign == decimal.sign && this.intDigits == decimal.intDigits && this.fracDigits == decimal.fracDigits && this.pvalue == decimal.pvalue && this.ivalue.equals(decimal.ivalue) && this.fvalue.equals(decimal.fvalue);
        }
    }
}

