/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.resultset;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.core.ResultBinding;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.resultset.ResultSetPeekable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetPeeking
implements ResultSetPeekable,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultSetPeekable.class);
    public static boolean warnOnSyncErrors = true;
    private ResultSet results;
    private Model model;
    private Binding peeked = null;
    private int rowNumber = 0;

    public ResultSetPeeking(ResultSet results) {
        if (results == null) {
            throw new IllegalArgumentException("Inner result set cannot be null");
        }
        this.results = results;
        this.model = results.getResourceModel();
    }

    @Override
    public boolean hasNext() {
        if (this.hasPeeked()) {
            return true;
        }
        return this.canPeek();
    }

    @Override
    public QuerySolution next() {
        return new ResultBinding(this.model, this.nextBinding());
    }

    @Override
    public void forEachRemaining(Consumer<? super QuerySolution> action) {
        while (this.hasNext()) {
            action.accept(this.next());
        }
    }

    @Override
    public QuerySolution nextSolution() {
        return this.next();
    }

    @Override
    public Binding nextBinding() {
        if (this.hasPeeked()) {
            Binding b = this.peeked;
            this.peeked = null;
            ++this.rowNumber;
            return b;
        }
        if (this.canPeek()) {
            Binding b = this.peekBinding();
            this.peeked = null;
            ++this.rowNumber;
            return b;
        }
        throw new NoSuchElementException();
    }

    @Override
    public int getRowNumber() {
        return this.hasPeeked() ? this.results.getRowNumber() - 1 : this.results.getRowNumber();
    }

    @Override
    public List<String> getResultVars() {
        return this.results.getResultVars();
    }

    @Override
    public Model getResourceModel() {
        return this.model;
    }

    private boolean hasPeeked() {
        int diff = this.results.getRowNumber() - this.rowNumber;
        if (diff == 0) {
            return false;
        }
        if (diff == 1 && this.peeked != null) {
            return true;
        }
        if (diff >= 1) {
            if (warnOnSyncErrors) {
                LOGGER.warn("Underlying result set was moved forward " + (diff - 1) + " result(s), this result set was synced back up but some results have been missed");
            }
            this.rowNumber = this.results.getRowNumber();
            this.peeked = null;
            return false;
        }
        throw new IllegalStateException("Underlying result set position has moved backwards, this result set is no longer usable");
    }

    private boolean canPeek() {
        return this.results.hasNext();
    }

    @Override
    public QuerySolution peek() {
        return new ResultBinding(this.model, this.peekBinding());
    }

    @Override
    public Binding peekBinding() {
        if (this.hasPeeked()) {
            return this.peeked;
        }
        if (this.canPeek()) {
            this.peeked = this.results.nextBinding();
            return this.peeked;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void close() {
        if (this.results instanceof Closeable) {
            ((Closeable)((Object)this.results)).close();
        }
    }
}

