/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store;

import org.apache.jena.atlas.lib.BitsLong;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.graph.Node;
import org.apache.jena.tdb2.store.NodeIdFactory;
import org.apache.jena.tdb2.store.NodeIdInline;
import org.apache.jena.tdb2.store.NodeIdType;
import org.apache.jena.tdb2.sys.SystemTDB;

public final class NodeId
implements Comparable<NodeId> {
    public static final int SIZE = 8;
    public static final NodeId NodeIdInvalid = NodeId.makeSpecial(161L);
    public static final NodeId NodeDoesNotExist = NodeId.makeSpecial(163L);
    public static final NodeId NodeIdAny = NodeId.makeSpecial(164L);
    public static final NodeId NodeIdDefined = NodeId.makeSpecial(165L);
    public static final NodeId NodeIdUndefined = NodeId.makeSpecial(166L);
    static final boolean enableInlineLiterals = SystemTDB.enableInlineLiterals;
    private static final boolean CHECKING = true;
    final NodeIdType type;
    final int value1;
    final long value2;

    private static NodeId makeSpecial(long v) {
        return NodeIdFactory.createValue(NodeIdType.SPECIAL, v);
    }

    private NodeId(NodeIdType type, int v1, long v2) {
        this.check(type, v1, v2);
        this.type = type;
        this.value1 = v1;
        this.value2 = v2;
    }

    private final void check(NodeIdType type, int v1, long v2) {
        int x;
        if (type == NodeIdType.PTR) {
            return;
        }
        if (type == NodeIdType.SPECIAL) {
            return;
        }
        int n = x = type == NodeIdType.XSD_DOUBLE ? (int)BitsLong.unpack(v2, 62, 64) : (int)BitsLong.unpack(v2, 56, 64);
        if (x != 0) {
            FmtLog.warn(this.getClass(), "Type set in long: type=%s value=%016X", new Object[]{type, v2});
        }
    }

    public boolean isPtr() {
        return this.type == NodeIdType.PTR;
    }

    public long getPtrLocation() {
        return this.value2;
    }

    public int getTypeValue() {
        return this.type.type();
    }

    public boolean isInline() {
        return NodeId.isInline(this);
    }

    public static boolean isInline(NodeId nodeId) {
        return NodeIdType.isInline(nodeId.type);
    }

    public boolean isValue() {
        return this.type != NodeIdType.PTR && NodeIdType.isStorable(this.type);
    }

    public static NodeId inline(Node node) {
        return NodeIdInline.inline(node);
    }

    public static boolean hasInlineDatatype(Node node) {
        return NodeIdInline.hasInlineDatatype(node);
    }

    public static Node extract(NodeId nodeId) {
        return NodeIdInline.extract(nodeId);
    }

    public static final boolean isAny(NodeId nodeId) {
        return nodeId == NodeIdAny || nodeId == null;
    }

    public static final boolean isDoesNotExist(NodeId nodeId) {
        return nodeId == NodeDoesNotExist;
    }

    static NodeId createRaw(NodeIdType type, long value) {
        return new NodeId(type, 0, value);
    }

    static NodeId createRaw(NodeIdType type, int value1, long value2) {
        return new NodeId(type, value1, value2);
    }

    public NodeIdType type() {
        return this.type;
    }

    int getValue1() {
        return this.value1;
    }

    long getValue2() {
        return this.value2;
    }

    public int hashCode() {
        return this.value1 ^ (int)this.value2 ^ (int)(this.value2 >> 32);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof NodeId)) {
            return false;
        }
        NodeId nOther = (NodeId)other;
        return NodeId.equals(nOther, this.value1, this.value2);
    }

    public boolean equals(NodeId nodeIdOther) {
        if (nodeIdOther == null) {
            return false;
        }
        if (this == nodeIdOther) {
            return true;
        }
        return NodeId.equals(nodeIdOther, this.value1, this.value2);
    }

    static boolean equals(NodeId nodeId, int v1, long v2) {
        return v2 == nodeId.value2 && v1 == nodeId.value1;
    }

    public String toString() {
        if (this == NodeDoesNotExist) {
            return "[DoesNotExist]";
        }
        if (this == NodeIdAny) {
            return "[Any]";
        }
        if (this == NodeIdInvalid) {
            return "[Invalid]";
        }
        if (this == NodeIdDefined) {
            return "[Defined]";
        }
        if (this == NodeIdUndefined) {
            return "[Undefined]";
        }
        if (this.isInline()) {
            String displayName = this.type().toString();
            return String.format("[%s 0x%014X]", displayName, this.value2);
        }
        return String.format("[0x%16X]", this.value2);
    }

    @Override
    public int compareTo(NodeId other) {
        return NodeId.compare(this, other);
    }

    public static int compare(NodeId n1, NodeId n2) {
        int x = Integer.compare(n1.value1, n2.value1);
        if (x == 0) {
            return 0;
        }
        return Long.compare(n1.value2, n2.value2);
    }

    public final boolean isConcrete() {
        return NodeId.isConcrete(this);
    }

    public static final boolean isConcrete(NodeId nodeId) {
        return !NodeIdType.isSpecial(nodeId.type);
    }
}

