/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common.migrate;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;

public class FilteringCopier
extends EcoreUtil.Copier {
    private final HashMap<EStructuralFeature, List<EObject>> myIgnoredFeatures;
    private final HashMap<EStructuralFeature, EStructuralFeature> mySubstitutedFeatures;
    private final HashMap<EStructuralFeature, EClass> myIgnoreData;
    private final EPackage ePack;
    private final EFactory eFact;

    public FilteringCopier(EPackage metaPackage) {
        this(false, true, metaPackage);
    }

    public FilteringCopier(boolean resolveProxies, boolean useOriginalReferences, EPackage metaPackage) {
        super(resolveProxies, useOriginalReferences);
        this.ePack = metaPackage;
        this.eFact = this.ePack.getEFactoryInstance();
        this.myIgnoredFeatures = new HashMap();
        this.mySubstitutedFeatures = new HashMap();
        this.myIgnoreData = new HashMap();
    }

    public void ignore(EStructuralFeature eFeature) {
        assert (eFeature != null);
        assert (!this.myIgnoredFeatures.containsKey(eFeature));
        this.myIgnoredFeatures.put(eFeature, new LinkedList());
    }

    public void ignoreIn(EStructuralFeature eFeature, EClass original) {
        this.ignore(eFeature);
        this.myIgnoreData.put(eFeature, original);
    }

    public void substitute(EStructuralFeature oldFeature, EStructuralFeature newFeature) {
        assert (oldFeature != null && newFeature != null);
        assert (!this.mySubstitutedFeatures.containsKey(oldFeature));
        this.mySubstitutedFeatures.put(oldFeature, newFeature);
    }

    public EObject go(EObject original) {
        EObject result = this.copy(original);
        this.copyReferences();
        return result;
    }

    public List<EObject> getIgnoredOwners(EStructuralFeature eFeature) {
        return Collections.unmodifiableList(this.myIgnoredFeatures.get(eFeature));
    }

    public EObject copy(EObject eObject) {
        EObject copyEObject = this.createCopy(eObject);
        this.put(eObject, copyEObject);
        EClass eClass = eObject.eClass();
        int i = 0;
        int size = eClass.getFeatureCount();
        while (i < size) {
            EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(i);
            if (this.isIgnored(eStructuralFeature, eObject)) {
                this.handleIgnored(eStructuralFeature, eObject);
            } else if (eStructuralFeature.isChangeable() && !eStructuralFeature.isDerived()) {
                if (eStructuralFeature instanceof EAttribute) {
                    this.copyAttribute((EAttribute)eStructuralFeature, eObject, copyEObject);
                } else {
                    EReference eReference = (EReference)eStructuralFeature;
                    if (eReference.isContainment()) {
                        this.copyContainment(eReference, eObject, copyEObject);
                    }
                }
            }
            ++i;
        }
        this.copyProxyURI(eObject, copyEObject);
        return copyEObject;
    }

    protected void copyAttribute(EAttribute eAttribute, EObject eObject, EObject copyEObject) {
        if (eObject.eIsSet((EStructuralFeature)eAttribute)) {
            if (FeatureMapUtil.isFeatureMap((EStructuralFeature)eAttribute)) {
                FeatureMap featureMap = (FeatureMap)eObject.eGet((EStructuralFeature)eAttribute);
                int i = 0;
                int size = featureMap.size();
                while (i < size) {
                    Object value;
                    EStructuralFeature feature = featureMap.getEStructuralFeature(i);
                    if (feature instanceof EReference && ((EReference)feature).isContainment() && (value = featureMap.getValue(i)) != null) {
                        this.copy((EObject)value);
                    }
                    ++i;
                }
            } else if (eAttribute.isMany()) {
                List source = (List)eObject.eGet((EStructuralFeature)eAttribute);
                List target = (List)copyEObject.eGet(this.getTarget((EStructuralFeature)eAttribute));
                if (source.isEmpty()) {
                    target.clear();
                } else if (this.needsTransform(eAttribute, eObject)) {
                    for (Object o : source) {
                        target.add(this.transformValue(eAttribute, o));
                    }
                } else {
                    target.addAll(source);
                }
            } else if (this.needsTransform(eAttribute, eObject)) {
                copyEObject.eSet(this.getTarget((EStructuralFeature)eAttribute), this.transformValue(eAttribute, eObject.eGet((EStructuralFeature)eAttribute)));
            } else {
                copyEObject.eSet(this.getTarget((EStructuralFeature)eAttribute), eObject.eGet((EStructuralFeature)eAttribute));
            }
        }
    }

    protected EClass getTarget(EClass eClass) {
        EClassifier c = this.ePack.getEClassifier(eClass.getName());
        if (c instanceof EClass) {
            return (EClass)c;
        }
        return super.getTarget(eClass);
    }

    protected EStructuralFeature getTarget(EStructuralFeature sf) {
        if (this.mySubstitutedFeatures.containsKey(sf)) {
            return this.mySubstitutedFeatures.get(sf);
        }
        EStructuralFeature rv = this.getTarget(sf.getEContainingClass()).getEStructuralFeature(sf.getName());
        if (rv != null) {
            return rv;
        }
        return super.getTarget(sf);
    }

    protected void copyReference(EReference reference, EObject object, EObject copyEObject) {
        if (!this.isIgnored((EStructuralFeature)reference, object)) {
            super.copyReference(reference, object, copyEObject);
        }
    }

    protected boolean isIgnored(EStructuralFeature eFeature, EObject original) {
        if (this.myIgnoredFeatures.containsKey(eFeature)) {
            if (this.myIgnoreData.containsKey(eFeature)) {
                EClass filter = this.myIgnoreData.get(eFeature);
                return filter.isSuperTypeOf(original.eClass());
            }
            return true;
        }
        return false;
    }

    protected void handleIgnored(EStructuralFeature eFeature, EObject original) {
        this.myIgnoredFeatures.get(eFeature).add(original);
    }

    protected boolean needsTransform(EAttribute eAttr, EObject original) {
        return eAttr.getEType() instanceof EEnum;
    }

    public Object transformValue(EAttribute eAttr, Object value) {
        if (eAttr.getEType() instanceof EEnum) {
            EFactory f = eAttr.getEContainingClass().getEPackage().getEFactoryInstance();
            String s = f.convertToString(eAttr.getEAttributeType(), value);
            EClassifier newModelEnum = this.ePack.getEClassifier(eAttr.getEType().getName());
            Object r = this.eFact.createFromString((EDataType)newModelEnum, s);
            return r;
        }
        return value;
    }
}

