/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.simplemap.diagram.providers;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.providers.IViewProvider;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateDiagramViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateEdgeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateNodeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewForKindOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewOperation;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.MeasurementUnit;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.simplemap.diagram.part.SimplemapVisualIDRegistry;
import org.eclipse.gmf.tooling.simplemap.diagram.providers.SimplemapElementTypes;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class SimplemapViewProvider
extends AbstractProvider
implements IViewProvider {
    public final boolean provides(IOperation operation) {
        if (operation instanceof CreateViewForKindOperation) {
            return this.provides((CreateViewForKindOperation)operation);
        }
        assert (operation instanceof CreateViewOperation);
        if (operation instanceof CreateDiagramViewOperation) {
            return this.provides((CreateDiagramViewOperation)operation);
        }
        if (operation instanceof CreateEdgeViewOperation) {
            return this.provides((CreateEdgeViewOperation)operation);
        }
        if (operation instanceof CreateNodeViewOperation) {
            return this.provides((CreateNodeViewOperation)operation);
        }
        return false;
    }

    protected boolean provides(CreateViewForKindOperation op) {
        return true;
    }

    protected boolean provides(CreateDiagramViewOperation op) {
        return "Simplemap".equals(op.getSemanticHint()) && SimplemapVisualIDRegistry.getDiagramVisualID(this.getSemanticElement(op.getSemanticAdapter())) != -1;
    }

    protected boolean provides(CreateNodeViewOperation op) {
        int visualID;
        if (op.getContainerView() == null) {
            return false;
        }
        IElementType elementType = this.getSemanticElementType(op.getSemanticAdapter());
        EObject domainElement = this.getSemanticElement(op.getSemanticAdapter());
        if (op.getSemanticHint() == null) {
            if (elementType != null || domainElement == null) {
                return false;
            }
            visualID = SimplemapVisualIDRegistry.getNodeVisualID(op.getContainerView(), domainElement);
        } else {
            visualID = SimplemapVisualIDRegistry.getVisualID(op.getSemanticHint());
            if (elementType != null) {
                if (!SimplemapElementTypes.isKnownElementType(elementType) || !(elementType instanceof IHintedType)) {
                    return false;
                }
                String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
                if (!op.getSemanticHint().equals(elementTypeHint)) {
                    return false;
                }
                if (domainElement != null && visualID != SimplemapVisualIDRegistry.getNodeVisualID(op.getContainerView(), domainElement)) {
                    return false;
                }
            } else {
                if (!"Simplemap".equals(SimplemapVisualIDRegistry.getModelID(op.getContainerView()))) {
                    return false;
                }
                switch (visualID) {
                    case 1001: 
                    case 1002: 
                    case 2001: 
                    case 2002: 
                    case 2003: 
                    case 2004: {
                        if (domainElement != null && visualID == SimplemapVisualIDRegistry.getNodeVisualID(op.getContainerView(), domainElement)) break;
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
            }
        }
        return 1001 == visualID || 1002 == visualID || 2001 == visualID || 2002 == visualID || 2003 == visualID || 2004 == visualID;
    }

    protected boolean provides(CreateEdgeViewOperation op) {
        IElementType elementType = this.getSemanticElementType(op.getSemanticAdapter());
        if (!SimplemapElementTypes.isKnownElementType(elementType) || !(elementType instanceof IHintedType)) {
            return false;
        }
        String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
        if (elementTypeHint == null || op.getSemanticHint() != null && !elementTypeHint.equals(op.getSemanticHint())) {
            return false;
        }
        int visualID = SimplemapVisualIDRegistry.getVisualID(elementTypeHint);
        EObject domainElement = this.getSemanticElement(op.getSemanticAdapter());
        return domainElement == null || visualID == SimplemapVisualIDRegistry.getLinkWithClassVisualID(domainElement);
    }

    public Diagram createDiagram(IAdaptable semanticAdapter, String diagramKind, PreferencesHint preferencesHint) {
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        diagram.getStyles().add((Object)NotationFactory.eINSTANCE.createDiagramStyle());
        diagram.setType("Simplemap");
        diagram.setElement(this.getSemanticElement(semanticAdapter));
        diagram.setMeasurementUnit(MeasurementUnit.PIXEL_LITERAL);
        return diagram;
    }

    public Node createNode(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        EObject domainElement = this.getSemanticElement(semanticAdapter);
        int visualID = semanticHint == null ? SimplemapVisualIDRegistry.getNodeVisualID(containerView, domainElement) : SimplemapVisualIDRegistry.getVisualID(semanticHint);
        switch (visualID) {
            case 1001: {
                return this.createSimpleTopNode_1001(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 1002: {
                return this.createSimpleLinkMapping_1002(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2001: {
                return this.createSimpleLabelNode_2001(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2002: {
                return this.createSimpleCompartment_2002(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2003: {
                return this.createSimpleSubNode_2003(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2004: {
                return this.createSimpleChildReference_2004(domainElement, containerView, index, persisted, preferencesHint);
            }
        }
        return null;
    }

    public Edge createEdge(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        IElementType elementType = this.getSemanticElementType(semanticAdapter);
        String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
        SimplemapVisualIDRegistry.getVisualID(elementTypeHint);
        return null;
    }

    public Node createSimpleTopNode_1001(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createDescriptionStyle());
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(SimplemapVisualIDRegistry.getType(1001));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        FontStyle nodeFontStyle = (FontStyle)node.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (nodeFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)prefStore, (String)"Appearance.defaultFont");
            nodeFontStyle.setFontName(fontData.getName());
            nodeFontStyle.setFontHeight(fontData.getHeight());
            nodeFontStyle.setBold((fontData.getStyle() & 1) != 0);
            nodeFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fontColor");
            nodeFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
        this.createLabel((View)node, SimplemapVisualIDRegistry.getType(4003));
        return node;
    }

    public Node createSimpleLinkMapping_1002(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createDescriptionStyle());
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(SimplemapVisualIDRegistry.getType(1002));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        FontStyle nodeFontStyle = (FontStyle)node.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (nodeFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)prefStore, (String)"Appearance.defaultFont");
            nodeFontStyle.setFontName(fontData.getName());
            nodeFontStyle.setFontHeight(fontData.getHeight());
            nodeFontStyle.setBold((fontData.getStyle() & 1) != 0);
            nodeFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fontColor");
            nodeFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
        this.createLabel((View)node, SimplemapVisualIDRegistry.getType(4004));
        return node;
    }

    public Node createSimpleLabelNode_2001(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        node.setType(SimplemapVisualIDRegistry.getType(2001));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        return node;
    }

    public Node createSimpleCompartment_2002(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createDescriptionStyle());
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createLineStyle());
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(SimplemapVisualIDRegistry.getType(2002));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.lineColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineRGB));
        FontStyle nodeFontStyle = (FontStyle)node.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (nodeFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)prefStore, (String)"Appearance.defaultFont");
            nodeFontStyle.setFontName(fontData.getName());
            nodeFontStyle.setFontHeight(fontData.getHeight());
            nodeFontStyle.setBold((fontData.getStyle() & 1) != 0);
            nodeFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fontColor");
            nodeFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
        this.createLabel((View)node, SimplemapVisualIDRegistry.getType(4002));
        return node;
    }

    public Node createSimpleSubNode_2003(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createDescriptionStyle());
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(SimplemapVisualIDRegistry.getType(2003));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        FontStyle nodeFontStyle = (FontStyle)node.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (nodeFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)prefStore, (String)"Appearance.defaultFont");
            nodeFontStyle.setFontName(fontData.getName());
            nodeFontStyle.setFontHeight(fontData.getHeight());
            nodeFontStyle.setBold((fontData.getStyle() & 1) != 0);
            nodeFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fontColor");
            nodeFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
        this.createLabel((View)node, SimplemapVisualIDRegistry.getType(4001));
        return node;
    }

    public Node createSimpleChildReference_2004(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        node.setType(SimplemapVisualIDRegistry.getType(2004));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        return node;
    }

    private void stampShortcut(View containerView, Node target) {
        if (!"Simplemap".equals(SimplemapVisualIDRegistry.getModelID(containerView))) {
            EAnnotation shortcutAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            shortcutAnnotation.setSource("Shortcut");
            shortcutAnnotation.getDetails().put((Object)"modelID", (Object)"Simplemap");
            target.getEAnnotations().add((Object)shortcutAnnotation);
        }
    }

    private Node createLabel(View owner, String hint) {
        DecorationNode rv = NotationFactory.eINSTANCE.createDecorationNode();
        rv.setType(hint);
        ViewUtil.insertChildView((View)owner, (View)rv, (int)-1, (boolean)true);
        return rv;
    }

    private EObject getSemanticElement(IAdaptable semanticAdapter) {
        if (semanticAdapter == null) {
            return null;
        }
        EObject eObject = (EObject)semanticAdapter.getAdapter(EObject.class);
        if (eObject != null) {
            return EMFCoreUtil.resolve((TransactionalEditingDomain)TransactionUtil.getEditingDomain((EObject)eObject), (EObject)eObject);
        }
        return null;
    }

    private IElementType getSemanticElementType(IAdaptable semanticAdapter) {
        if (semanticAdapter == null) {
            return null;
        }
        return (IElementType)semanticAdapter.getAdapter(IElementType.class);
    }
}

