/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.simplemap.migrate.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.gmfgraph.Canvas;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.mappings.ChildReference;
import org.eclipse.gmf.mappings.CompartmentMapping;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.Mapping;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.mappings.NodeReference;
import org.eclipse.gmf.mappings.TopNodeReference;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.tooldef.Palette;
import org.eclipse.gmf.tooling.simplemap.diagram.part.Messages;
import org.eclipse.gmf.tooling.simplemap.diagram.part.SimpleMapEditorDiagramEditorUtil;
import org.eclipse.gmf.tooling.simplemap.diagram.part.SimplemapDiagramEditorPlugin;
import org.eclipse.gmf.tooling.simplemap.diagram.part.SimplemapDiagramEditorUtil;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleChildNode;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleChildReference;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleCompartment;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleLabelNode;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleLinkMapping;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleMapping;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleNode;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleParentNode;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleSubNode;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleTopNode;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimplemappingsFactory;

public class SimplemapMigrationEditorUtil
extends SimplemapDiagramEditorUtil {
    private SimpleMapping simpleMapping;

    public Resource createDiagram(URI diagramURI, IProgressMonitor progressMonitor, final Mapping myMapping, final Canvas myCanvas, final Palette myPalette) {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        progressMonitor.beginTask(Messages.SimplemapDiagramEditorUtil_CreateDiagramProgressTask, 3);
        final Resource diagramResource = editingDomain.getResourceSet().createResource(diagramURI);
        final String diagramName = diagramURI.lastSegment();
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, Messages.SimplemapDiagramEditorUtil_CreateDiagramCommandLabel, Collections.EMPTY_LIST){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                SimpleMapping model = SimplemapMigrationEditorUtil.this.createInitialModel(myMapping, myCanvas, myPalette);
                SimplemapMigrationEditorUtil.this.attachModelToResource(model, diagramResource);
                Diagram diagram = ViewService.createDiagram((EObject)model, (String)"Simplemap", (PreferencesHint)SimplemapDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                if (diagram != null) {
                    diagramResource.getContents().add((Object)diagram);
                    diagram.setName(diagramName);
                    diagram.setElement((EObject)model);
                }
                try {
                    diagramResource.save(SimpleMapEditorDiagramEditorUtil.getSaveOptions());
                }
                catch (IOException e) {
                    SimplemapDiagramEditorPlugin.getInstance().logError("Unable to store model and diagram resources", (Throwable)e);
                }
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1), null);
        }
        catch (ExecutionException e) {
            SimplemapDiagramEditorPlugin.getInstance().logError("Unable to create model and diagram", (Throwable)e);
        }
        SimplemapMigrationEditorUtil.setCharset((IFile)WorkspaceSynchronizer.getFile((Resource)diagramResource));
        return diagramResource;
    }

    public SimpleMapping createInitialModel(Mapping myMapping, Canvas myCanvas, Palette myPalette) {
        this.simpleMapping = SimplemappingsFactory.eINSTANCE.createSimpleMapping();
        this.simpleMapping.setMapping(myMapping);
        this.simpleMapping.setCanvas(myCanvas);
        this.simpleMapping.setPalette(myPalette);
        this.simpleMapping.getChildren().addAll(this.createNodes(myMapping));
        return this.simpleMapping;
    }

    private List<SimpleChildNode> createNodes(Mapping myMapping) {
        ArrayList<SimpleChildNode> children = new ArrayList<SimpleChildNode>();
        for (TopNodeReference topNodeRef : myMapping.getNodes()) {
            children.add((SimpleChildNode)this.createTopNode(topNodeRef));
        }
        for (LinkMapping linkMapping : myMapping.getLinks()) {
            children.add((SimpleChildNode)this.createLinkMappingNode(linkMapping));
        }
        return children;
    }

    private SimpleTopNode createTopNode(TopNodeReference topNodeReference) {
        SimpleTopNode topNode = SimplemappingsFactory.eINSTANCE.createSimpleTopNode();
        topNode.setContainmentFeature(topNodeReference.getContainmentFeature());
        NodeMapping nodeMapping = topNodeReference.getChild();
        if (nodeMapping != null) {
            topNode.setDomainMetaElement(nodeMapping.getDomainMetaElement());
            for (ChildReference childReference : nodeMapping.getChildren()) {
                this.createChild((SimpleParentNode)topNode, childReference);
            }
        }
        topNode.setNodeReference((NodeReference)topNodeReference);
        return topNode;
    }

    private SimpleLinkMapping createLinkMappingNode(LinkMapping linkMapping) {
        SimpleLinkMapping simpleLinkMapping = SimplemappingsFactory.eINSTANCE.createSimpleLinkMapping();
        simpleLinkMapping.setLinkMapping(linkMapping);
        Connection diagramLink = linkMapping.getDiagramLink();
        if (diagramLink != null) {
            simpleLinkMapping.setName(diagramLink.getName());
        }
        return simpleLinkMapping;
    }

    private void createChild(SimpleParentNode parentNode, ChildReference childReference) {
        SimpleParentNode parent = parentNode;
        CompartmentMapping compartmentMapping = childReference.getCompartment();
        if (compartmentMapping != null) {
            SimpleCompartment simpleCompartment = this.findSimpleCompartment(parentNode, compartmentMapping);
            if (simpleCompartment == null) {
                simpleCompartment = SimplemappingsFactory.eINSTANCE.createSimpleCompartment();
                simpleCompartment.setCompartmentMapping(compartmentMapping);
                simpleCompartment.setName(compartmentMapping.getCompartment().getName());
                parentNode.getChildren().add((Object)simpleCompartment);
            }
            parent = simpleCompartment;
        }
        NodeMapping referencedChild = childReference.getReferencedChild();
        NodeMapping nodeMapping = childReference.getChild();
        SimpleChildReference newChild = null;
        if (referencedChild != null) {
            newChild = SimplemappingsFactory.eINSTANCE.createSimpleChildReference();
            parent.getChildren().add((Object)newChild);
        } else if (nodeMapping != null && nodeMapping.getDiagramNode() instanceof DiagramLabel) {
            newChild = SimplemappingsFactory.eINSTANCE.createSimpleLabelNode();
            parent.getChildren().add((Object)((SimpleLabelNode)newChild));
        } else if (nodeMapping != null && nodeMapping.getDiagramNode() instanceof Node) {
            newChild = SimplemappingsFactory.eINSTANCE.createSimpleSubNode();
            parent.getChildren().add((Object)((SimpleSubNode)newChild));
            for (ChildReference childReference2 : nodeMapping.getChildren()) {
                this.createChild((SimpleParentNode)((SimpleSubNode)newChild), childReference2);
            }
        }
        if (newChild != null) {
            newChild.setContainmentFeature(childReference.getContainmentFeature());
            newChild.setNodeReference((NodeReference)childReference);
        }
        if (newChild instanceof SimpleNode && nodeMapping != null) {
            ((SimpleNode)newChild).setDomainMetaElement(nodeMapping.getDomainMetaElement());
        }
    }

    private SimpleCompartment findSimpleCompartment(SimpleParentNode parentNode, CompartmentMapping compartmentMapping) {
        for (SimpleChildNode child : parentNode.getChildren()) {
            if (!(child instanceof SimpleCompartment) || ((SimpleCompartment)child).getCompartmentMapping() != compartmentMapping) continue;
            return (SimpleCompartment)child;
        }
        return null;
    }

    public void attachModelToResource(SimpleMapping model, Resource resource) {
        resource.getContents().add((Object)model);
    }
}

