/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.simplemap.model.triggers.parent;

import org.eclipse.gmf.gmfgraph.Alignment;
import org.eclipse.gmf.gmfgraph.AlignmentFacet;
import org.eclipse.gmf.gmfgraph.BasicFont;
import org.eclipse.gmf.gmfgraph.Canvas;
import org.eclipse.gmf.gmfgraph.ChildAccess;
import org.eclipse.gmf.gmfgraph.Color;
import org.eclipse.gmf.gmfgraph.Compartment;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.DecorationFigure;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.Dimension;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FigureDescriptor;
import org.eclipse.gmf.gmfgraph.FigureGallery;
import org.eclipse.gmf.gmfgraph.FlowLayout;
import org.eclipse.gmf.gmfgraph.Font;
import org.eclipse.gmf.gmfgraph.FontStyle;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.Insets;
import org.eclipse.gmf.gmfgraph.Label;
import org.eclipse.gmf.gmfgraph.Layout;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.gmfgraph.Point;
import org.eclipse.gmf.gmfgraph.PolygonDecoration;
import org.eclipse.gmf.gmfgraph.PolylineConnection;
import org.eclipse.gmf.gmfgraph.RGBColor;
import org.eclipse.gmf.gmfgraph.RealFigure;
import org.eclipse.gmf.gmfgraph.Rectangle;
import org.eclipse.gmf.gmfgraph.RoundedRectangle;

public class CanvasFactory {
    private Canvas canvas;
    private static String DEFAULT_LABEL_FACE = "Verdana";
    private static String DEFAULT_LABEL_TEXT = "<..>";
    private static int DEFAULT_LABEL_HEIGHT = 9;
    private static int[] DEFAULT_RECTANGLE_BACKGROUND = new int[]{242, 245, 252};
    private static int[] DEFAULT_RECTANGLE_FOREGROUND = new int[]{111, 142, 194};
    private static int[] DEFAULT_COMPARTMENT_RECTANGLE_BACKGROUND = new int[]{251, 252, 255};
    private static int[] DEFAULT_COMPARTMENT_RECTANGLE_FOREGROUND = new int[]{133, 156, 194};
    private static int[] DEFAULT_POLYGON_DECORATION_FOREGROUND = new int[]{32, 104, 160};
    private static int[] DEFAULT_POLYLINE_CONNECTION_FOREGROUND = new int[]{32, 104, 160};
    private static int[] DEFAULT_TOP_NODE_INSETS = new int[]{5, 3, 3, 3};
    private static int[] DEFAULT_SUB_NODE_INSETS = new int[]{5, 5, 5, 5};
    private static int[] DEFAULT_COMPARTMENT_INSETS = new int[]{5, 5, 5, 5};

    public CanvasFactory(Canvas canvas) {
        this.canvas = canvas;
    }

    public FigureDescriptor createDefaultLabelFigure(DiagramLabel newLabel, BasicFont parentFont) {
        FigureDescriptor newFigureDescriptor = GMFGraphFactory.eINSTANCE.createFigureDescriptor();
        int height = parentFont != null ? parentFont.getHeight() - 1 : DEFAULT_LABEL_HEIGHT;
        Label label = this.createLabelFigure(DEFAULT_LABEL_TEXT, DEFAULT_LABEL_FACE, height, null);
        newFigureDescriptor.setActualFigure((Figure)label);
        newLabel.setFigure(newFigureDescriptor);
        ((FigureGallery)this.canvas.getFigures().get(0)).getDescriptors().add((Object)newFigureDescriptor);
        this.canvas.getLabels().add((Object)newLabel);
        return newFigureDescriptor;
    }

    private Label createLabelFigure(String defaultText, String faceName, int height, FontStyle fontStyle) {
        Label label = GMFGraphFactory.eINSTANCE.createLabel();
        label.setText(defaultText);
        BasicFont defaultFont = GMFGraphFactory.eINSTANCE.createBasicFont();
        defaultFont.setFaceName(faceName);
        if (height <= 6) {
            height = 7;
        }
        defaultFont.setHeight(height);
        if (fontStyle != null) {
            defaultFont.setStyle(fontStyle);
        }
        label.setFont((Font)defaultFont);
        return label;
    }

    public void createDefaultRoundedRectangleWithLabel(Node newNode, DiagramLabel newLabel, boolean topNode, BasicFont parentFont) {
        FigureDescriptor newFigureDescriptor = GMFGraphFactory.eINSTANCE.createFigureDescriptor();
        int fontSize = parentFont != null ? parentFont.getHeight() - 1 : DEFAULT_LABEL_HEIGHT;
        Label label = this.createLabelFigure(DEFAULT_LABEL_TEXT, DEFAULT_LABEL_FACE, fontSize, FontStyle.BOLD_LITERAL);
        RoundedRectangle defaultRectangle = this.createDefaultRoundedRectangle(label, topNode);
        newFigureDescriptor.setActualFigure((Figure)defaultRectangle);
        ChildAccess labelAccessor = GMFGraphFactory.eINSTANCE.createChildAccess();
        labelAccessor.setFigure((Figure)label);
        newFigureDescriptor.getAccessors().add((Object)labelAccessor);
        newNode.setFigure(newFigureDescriptor);
        newLabel.setFigure(newFigureDescriptor);
        newLabel.setAccessor(labelAccessor);
        AlignmentFacet alignmentFacet = GMFGraphFactory.eINSTANCE.createAlignmentFacet();
        alignmentFacet.setAlignment(Alignment.CENTER_LITERAL);
        newLabel.getFacets().add((Object)alignmentFacet);
        if (this.canvas.getFigures().isEmpty()) {
            FigureGallery defaultFigureGallery = GMFGraphFactory.eINSTANCE.createFigureGallery();
            defaultFigureGallery.setName("Default");
            this.canvas.getFigures().add((Object)defaultFigureGallery);
        }
        ((FigureGallery)this.canvas.getFigures().get(0)).getDescriptors().add((Object)newFigureDescriptor);
        this.canvas.getNodes().add((Object)newNode);
        this.canvas.getLabels().add((Object)newLabel);
    }

    public void createDefaultCompartmentWithoutLabel(FigureDescriptor parentFigureDescriptor, Compartment newCompartment) {
        this.createDefaultCompartment(parentFigureDescriptor, newCompartment, null);
    }

    public void createDefaultCompartmentWithLabel(FigureDescriptor parentFigureDescriptor, Compartment newCompartment) {
        Label compartmentLabel = this.createLabelFigure("Compartment", DEFAULT_LABEL_FACE, 7, FontStyle.BOLD_LITERAL);
        this.createDefaultCompartment(parentFigureDescriptor, newCompartment, compartmentLabel);
    }

    private void createDefaultCompartment(FigureDescriptor parentFigureDescriptor, Compartment newCompartment, Label compartmentLabel) {
        Rectangle newCompartmentRectangle = this.createDefaultCompartmentRectangle();
        if (compartmentLabel != null) {
            newCompartmentRectangle.getChildren().add((Object)compartmentLabel);
        }
        RealFigure actualFigure = (RealFigure)parentFigureDescriptor.getActualFigure();
        actualFigure.getChildren().add((Object)newCompartmentRectangle);
        ChildAccess compartmentAccessor = GMFGraphFactory.eINSTANCE.createChildAccess();
        compartmentAccessor.setFigure((Figure)newCompartmentRectangle);
        parentFigureDescriptor.getAccessors().add((Object)compartmentAccessor);
        newCompartment.setAccessor(compartmentAccessor);
        newCompartment.setCollapsible(true);
        newCompartment.setFigure(parentFigureDescriptor);
        this.canvas.getCompartments().add((Object)newCompartment);
    }

    private RoundedRectangle createDefaultRoundedRectangle(Label rectangleLabel, boolean topNode) {
        RoundedRectangle defaultRectangle = GMFGraphFactory.eINSTANCE.createRoundedRectangle();
        FlowLayout flowLayout = GMFGraphFactory.eINSTANCE.createFlowLayout();
        flowLayout.setVertical(true);
        flowLayout.setMatchMinorSize(true);
        flowLayout.setForceSingleLine(true);
        Dimension minimumSize = GMFGraphFactory.eINSTANCE.createDimension();
        minimumSize.setDx(160);
        minimumSize.setDy(150);
        int[] insetsData = topNode ? DEFAULT_TOP_NODE_INSETS : DEFAULT_SUB_NODE_INSETS;
        Insets insets = this.createInsets(insetsData);
        if (topNode) {
            defaultRectangle.setLineWidth(3);
            defaultRectangle.setCornerWidth(6);
            defaultRectangle.setCornerHeight(6);
        } else {
            defaultRectangle.setLineWidth(1);
            defaultRectangle.setCornerWidth(8);
            defaultRectangle.setCornerHeight(8);
        }
        defaultRectangle.setLayout((Layout)flowLayout);
        RGBColor foregroundColor = this.createRGBColor(DEFAULT_RECTANGLE_FOREGROUND);
        RGBColor backgroundColor = this.createRGBColor(DEFAULT_RECTANGLE_BACKGROUND);
        defaultRectangle.setForegroundColor((Color)foregroundColor);
        defaultRectangle.setBackgroundColor((Color)backgroundColor);
        if (topNode) {
            defaultRectangle.setMinimumSize(minimumSize);
        }
        defaultRectangle.setXorFill(!topNode);
        defaultRectangle.setInsets(insets);
        if (rectangleLabel != null) {
            defaultRectangle.getChildren().add((Object)rectangleLabel);
        }
        return defaultRectangle;
    }

    private PolylineConnection createDefaultPolyLineConnection() {
        PolylineConnection newPolylineConnection = GMFGraphFactory.eINSTANCE.createPolylineConnection();
        RGBColor foregroundColor = this.createRGBColor(DEFAULT_POLYLINE_CONNECTION_FOREGROUND);
        newPolylineConnection.setForegroundColor((Color)foregroundColor);
        return newPolylineConnection;
    }

    private PolygonDecoration createDefaultPolygonDecoration() {
        PolygonDecoration newPolygonDecoration = GMFGraphFactory.eINSTANCE.createPolygonDecoration();
        RGBColor foregroundColor = this.createRGBColor(DEFAULT_POLYGON_DECORATION_FOREGROUND);
        newPolygonDecoration.setForegroundColor((Color)foregroundColor);
        Point point1 = GMFGraphFactory.eINSTANCE.createPoint();
        point1.setX(-1);
        point1.setY(1);
        Point point2 = GMFGraphFactory.eINSTANCE.createPoint();
        point2.setX(-1);
        point2.setY(-1);
        Point point3 = GMFGraphFactory.eINSTANCE.createPoint();
        point3.setX(0);
        point3.setY(0);
        newPolygonDecoration.getTemplate().add((Object)point1);
        newPolygonDecoration.getTemplate().add((Object)point2);
        newPolygonDecoration.getTemplate().add((Object)point3);
        return newPolygonDecoration;
    }

    private Rectangle createDefaultRectangle() {
        Rectangle newRectangle = GMFGraphFactory.eINSTANCE.createRectangle();
        RGBColor foregroundColor = this.createRGBColor(DEFAULT_RECTANGLE_FOREGROUND);
        RGBColor backgroundColor = this.createRGBColor(DEFAULT_RECTANGLE_BACKGROUND);
        newRectangle.setForegroundColor((Color)foregroundColor);
        newRectangle.setBackgroundColor((Color)backgroundColor);
        return newRectangle;
    }

    private Rectangle createDefaultCompartmentRectangle() {
        Rectangle newRectangle = GMFGraphFactory.eINSTANCE.createRectangle();
        RGBColor foregroundColor = this.createRGBColor(DEFAULT_COMPARTMENT_RECTANGLE_FOREGROUND);
        RGBColor backgroundColor = this.createRGBColor(DEFAULT_COMPARTMENT_RECTANGLE_BACKGROUND);
        newRectangle.setForegroundColor((Color)foregroundColor);
        newRectangle.setBackgroundColor((Color)backgroundColor);
        newRectangle.setInsets(this.createInsets(DEFAULT_COMPARTMENT_INSETS));
        Dimension minimumSize = GMFGraphFactory.eINSTANCE.createDimension();
        minimumSize.setDx(160);
        minimumSize.setDy(150);
        newRectangle.setMinimumSize(minimumSize);
        return newRectangle;
    }

    public void createNewDefaultPolygon(Connection newConnection, DiagramLabel newLabel) {
        FigureDescriptor newPolylineFigureDescriptor = GMFGraphFactory.eINSTANCE.createFigureDescriptor();
        PolylineConnection defaultPolylineConnection = this.createDefaultPolyLineConnection();
        PolygonDecoration defaultPolygonDecoration = this.createDefaultPolygonDecoration();
        defaultPolylineConnection.setTargetDecoration((DecorationFigure)defaultPolygonDecoration);
        newPolylineFigureDescriptor.setActualFigure((Figure)defaultPolylineConnection);
        FigureDescriptor newLabelFigureDescriptor = GMFGraphFactory.eINSTANCE.createFigureDescriptor();
        Label label = this.createLabelFigure(DEFAULT_LABEL_TEXT, DEFAULT_LABEL_FACE, DEFAULT_LABEL_HEIGHT, FontStyle.BOLD_LITERAL);
        newLabelFigureDescriptor.setActualFigure((Figure)label);
        newConnection.setFigure(newPolylineFigureDescriptor);
        newLabel.setFigure(newLabelFigureDescriptor);
        ((FigureGallery)this.canvas.getFigures().get(0)).getDescriptors().add((Object)newPolylineFigureDescriptor);
        ((FigureGallery)this.canvas.getFigures().get(0)).getDescriptors().add((Object)newLabelFigureDescriptor);
        ((FigureGallery)this.canvas.getFigures().get(0)).getFigures().add((Object)defaultPolygonDecoration);
        this.canvas.getConnections().add((Object)newConnection);
        this.canvas.getLabels().add((Object)newLabel);
    }

    private RGBColor createRGBColor(int[] color) {
        RGBColor backgroundColor = GMFGraphFactory.eINSTANCE.createRGBColor();
        backgroundColor.setRed(color[0]);
        backgroundColor.setGreen(color[1]);
        backgroundColor.setBlue(color[2]);
        return backgroundColor;
    }

    private Insets createInsets(int[] insetsData) {
        Insets insets = GMFGraphFactory.eINSTANCE.createInsets();
        insets.setTop(insetsData[0]);
        insets.setLeft(insetsData[1]);
        insets.setRight(insetsData[2]);
        insets.setBottom(insetsData[3]);
        return insets;
    }
}

