/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.simplemap.model.triggers.parent;

import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.gmfgraph.Canvas;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.Label;
import org.eclipse.gmf.tooldef.CreationTool;
import org.eclipse.gmf.tooldef.DefaultImage;
import org.eclipse.gmf.tooldef.GMFToolFactory;
import org.eclipse.gmf.tooldef.Image;
import org.eclipse.gmf.tooldef.Palette;
import org.eclipse.gmf.tooling.simplemap.model.triggers.AbstractTrigger;
import org.eclipse.gmf.tooling.simplemap.model.triggers.parent.CanvasFactory;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleChildNode;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleCompartment;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleLabelNode;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleLinkMapping;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleNode;

public abstract class NewElementTrigger
extends AbstractTrigger {
    private Canvas canvas;
    private Palette palette;
    protected CanvasFactory canvasFactory;

    public NewElementTrigger(TransactionalEditingDomain domain, SimpleChildNode newNode) {
        super(domain);
        this.canvas = newNode.getParentMapping().getCanvas();
        this.palette = newNode.getParentMapping().getPalette();
        this.canvasFactory = new CanvasFactory(this.canvas);
    }

    protected CreationTool createNewTool() {
        CreationTool newCreationTool = GMFToolFactory.eINSTANCE.createCreationTool();
        DefaultImage smallIcon = GMFToolFactory.eINSTANCE.createDefaultImage();
        DefaultImage largeIcon = GMFToolFactory.eINSTANCE.createDefaultImage();
        newCreationTool.setSmallIcon((Image)smallIcon);
        newCreationTool.setLargeIcon((Image)largeIcon);
        this.palette.getTools().add((Object)newCreationTool);
        return newCreationTool;
    }

    protected Label getLabelFigure(Object selected) {
        DiagramLabel diagramLabel;
        Figure figure = null;
        if (selected instanceof SimpleNode && (diagramLabel = ((SimpleNode)selected).getDiagramLabel()) != null && diagramLabel.getAccessor() != null) {
            figure = diagramLabel.getAccessor().getFigure();
        }
        if (selected instanceof SimpleLabelNode) {
            figure = ((SimpleNode)selected).getDiagramLabel().getFigure().getActualFigure();
        }
        if (selected instanceof SimpleCompartment) {
            figure = this.getLabelFigure(((SimpleCompartment)selected).getParent());
        }
        if (selected instanceof SimpleLinkMapping) {
            figure = ((SimpleLinkMapping)selected).getDiagramLabel().getFigure().getActualFigure();
        }
        return (Label)figure;
    }
}

