/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.simplemap.model.triggers.parent;

import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.gmfgraph.BasicFont;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.Label;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.mappings.FeatureLabelMapping;
import org.eclipse.gmf.mappings.GMFMapFactory;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.mappings.NodeReference;
import org.eclipse.gmf.mappings.TopNodeReference;
import org.eclipse.gmf.tooldef.AbstractTool;
import org.eclipse.gmf.tooldef.CreationTool;
import org.eclipse.gmf.tooling.simplemap.model.triggers.parent.NewElementTrigger;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleChildNode;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleMapping;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleNode;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleParentNode;

class NewTopNodeTrigger
extends NewElementTrigger {
    protected SimpleNode newSimpleNode;
    protected SimpleParentNode parent;

    public NewTopNodeTrigger(TransactionalEditingDomain domain, SimpleParentNode parent, SimpleNode newSimpleNode) {
        super(domain, (SimpleChildNode)newSimpleNode);
        this.newSimpleNode = newSimpleNode;
        this.parent = parent;
    }

    @Override
    public void executeTrigger() {
        Node newNode = GMFGraphFactory.eINSTANCE.createNode();
        DiagramLabel newLabel = GMFGraphFactory.eINSTANCE.createDiagramLabel();
        Label parentLabel = this.getLabelFigure(this.parent);
        BasicFont parentFont = parentLabel != null ? (BasicFont)parentLabel.getFont() : null;
        this.updateCanvas(newNode, newLabel, parentFont);
        CreationTool newCreationTool = this.createNewTool();
        this.updateMapping((SimpleMapping)this.parent, newNode, newLabel, newCreationTool);
    }

    protected void updateCanvas(Node newNode, DiagramLabel newLabel, BasicFont parentFont) {
        this.canvasFactory.createDefaultRoundedRectangleWithLabel(newNode, newLabel, true, parentFont);
    }

    protected void updateMapping(SimpleMapping mapping, Node newNode, DiagramLabel newLabel, CreationTool newCreationTool) {
        NodeMapping newNodeMapping = this.createNewNodeMapping(newNode, newLabel, newCreationTool);
        TopNodeReference newTopNodeReference = GMFMapFactory.eINSTANCE.createTopNodeReference();
        newTopNodeReference.setOwnedChild(newNodeMapping);
        mapping.getMapping().getNodes().add((Object)newTopNodeReference);
        this.newSimpleNode.setNodeReference((NodeReference)newTopNodeReference);
    }

    protected NodeMapping createNewNodeMapping(Node newNode, DiagramLabel newLabel, CreationTool newCreationTool) {
        NodeMapping newNodeMapping = GMFMapFactory.eINSTANCE.createNodeMapping();
        newNodeMapping.setDiagramNode(newNode);
        newNodeMapping.setTool((AbstractTool)newCreationTool);
        FeatureLabelMapping labelMapping = GMFMapFactory.eINSTANCE.createFeatureLabelMapping();
        labelMapping.setDiagramLabel(newLabel);
        newNodeMapping.getLabelMappings().add((Object)labelMapping);
        return newNodeMapping;
    }
}

