/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.options;

import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.escet.common.app.framework.options.EnumOption;
import org.eclipse.escet.common.app.framework.options.Option;
import org.eclipse.escet.common.app.framework.options.OptionGroup;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public abstract class EnumSetOption<T extends Enum<T>>
extends Option<EnumSet<T>> {
    protected final EnumSet<T> defaultValue;
    protected final Class<T> enumClass;
    protected final String optDialogDescr;

    public EnumSetOption(String name, String description, Character cmdShort, String cmdLong, String cmdValue, EnumSet<T> defaultValue, boolean showInDialog, String optDialogDescr, Class<T> enumClass) {
        super(name, description, cmdShort, cmdLong, cmdValue, showInDialog);
        Assert.check((!cmdLong.equals("*") ? 1 : 0) != 0);
        Assert.check((cmdValue != null ? 1 : 0) != 0);
        Assert.ifAndOnlyIf((boolean)showInDialog, (optDialogDescr != null ? 1 : 0) != 0);
        this.defaultValue = defaultValue;
        this.enumClass = enumClass;
        this.optDialogDescr = optDialogDescr;
    }

    @Override
    public EnumSet<T> getDefault() {
        return this.defaultValue;
    }

    protected void clear() {
        Options.set(this, EnumSet.noneOf(this.enumClass));
    }

    @Override
    public EnumSet<T> parseValue(String optName, String valuesTxt) {
        String[] valuesArray = StringUtils.split((String)valuesTxt, (char)',');
        List values = Lists.listc((int)valuesArray.length);
        String[] stringArray = valuesArray;
        int n = valuesArray.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (!(value = value.trim()).isEmpty()) {
                values.add(value);
            }
            ++n2;
        }
        List names = Lists.listc((int)values.size());
        List literals = Lists.listc((int)values.size());
        boolean[] additions = new boolean[values.size()];
        boolean[] removals = new boolean[values.size()];
        int i = 0;
        while (i < values.size()) {
            String name = (String)values.get(i);
            if (name.startsWith("+")) {
                additions[i] = true;
                name = name.substring(1);
            } else if (name.startsWith("-")) {
                removals[i] = true;
                name = name.substring(1);
            }
            names.add(name);
            String literal = name.toUpperCase(Locale.US).replace('-', '_');
            try {
                literals.add(Enum.valueOf(this.enumClass, literal));
            }
            catch (IllegalArgumentException e) {
                String msg = Strings.fmt((String)"Unknown option value part: \"%s\".", (Object[])new Object[]{name});
                throw new InvalidOptionException(msg);
            }
            ++i;
        }
        boolean hasReplace = false;
        boolean hasAddRemove = false;
        int i2 = 0;
        while (i2 < literals.size()) {
            if (additions[i2] || removals[i2]) {
                hasAddRemove = true;
            } else {
                hasReplace = true;
            }
            ++i2;
        }
        if (hasReplace && hasAddRemove) {
            String msg = "Using both replacement values (no prefix) and addition/removal values (+/- prefix) is not allowed.";
            throw new InvalidOptionException(msg);
        }
        if (hasAddRemove) {
            Object rslt = ((EnumSet)this.getDefault()).clone();
            int i3 = 0;
            while (i3 < literals.size()) {
                Enum literal = (Enum)literals.get(i3);
                if (additions[i3]) {
                    boolean added = ((AbstractCollection)rslt).add(literal);
                    if (!added) {
                        msg = Strings.fmt((String)"Adding value \"%s\" for option \"--%s\" has no effect, as the value is already included in the default, or was added more than once.", (Object[])new Object[]{names.get(i3), this.cmdLong});
                        OutputProvider.warn(msg);
                    }
                } else {
                    Assert.check((boolean)removals[i3]);
                    boolean removed = ((AbstractCollection)rslt).remove(literal);
                    if (!removed) {
                        msg = Strings.fmt((String)"Removing value \"%s\" for option \"--%s\" has no effect, as the value is not included in the default, or was removed more than once.", (Object[])new Object[]{names.get(i3), this.cmdLong});
                        OutputProvider.warn(msg);
                    }
                }
                ++i3;
            }
            return rslt;
        }
        EnumSet<T> rslt = EnumSet.noneOf(this.enumClass);
        int i4 = 0;
        while (i4 < literals.size()) {
            Enum literal = (Enum)literals.get(i4);
            boolean added = rslt.add(literal);
            if (!added) {
                String msg = Strings.fmt((String)"Specifying value \"%s\" a second time for option \"--%s\" has no effect.", (Object[])new Object[]{names.get(i4), this.cmdLong});
                OutputProvider.warn(msg);
            }
            ++i4;
        }
        return rslt;
    }

    @Override
    public String[] getCmdLine(Object value) {
        EnumSet literalSet = (EnumSet)value;
        String litsText = literalSet.stream().map(e -> EnumOption.getOptionValue(e)).collect(Collectors.joining(", "));
        return new String[]{"--" + this.cmdLong + "=" + litsText};
    }

    protected T[] getDialogOrder() {
        return (Enum[])this.enumClass.getEnumConstants();
    }

    protected void checkEnumValues(T[] literals) {
        Enum[] enumArray = (Enum[])this.enumClass.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum literal = enumArray[n2];
            Assert.check((boolean)ArrayUtils.contains((Object[])literals, (Object)literal));
            ++n2;
        }
        Set litSet = Sets.setc((int)literals.length);
        for (Enum lit : litSet) {
            boolean added = litSet.add(lit);
            Assert.check((boolean)added);
        }
    }

    protected abstract String getDialogText(T var1);

    @Override
    public OptionGroup<EnumSet<T>> createOptionGroup(Composite page) {
        Assert.check((boolean)this.showInDialog);
        return new OptionGroup<EnumSet<T>>(page, this){
            Button[] buttons;
            T[] literals;

            @Override
            protected void addComponents(Group group) {
                this.literals = EnumSetOption.this.getDialogOrder();
                EnumSetOption.this.checkEnumValues((Enum[])this.literals);
                this.buttons = new Button[this.literals.length];
                int i = 0;
                while (i < this.literals.length) {
                    this.buttons[i] = new Button((Composite)group, 32);
                    this.buttons[i].setText(EnumSetOption.this.getDialogText(this.literals[i]));
                    ++i;
                }
                this.layoutGeneric(this.buttons);
            }

            @Override
            public String getDescription() {
                return EnumSetOption.this.optDialogDescr;
            }

            @Override
            public void setToValue(EnumSet<T> value) {
                for (Enum v : value) {
                    int idx = ArrayUtils.indexOf((Object[])this.literals, (Object)v);
                    this.buttons[idx].setSelection(true);
                }
            }

            @Override
            public String[] getCmdLine() {
                EnumSet values = EnumSet.noneOf(EnumSetOption.this.enumClass);
                int i = 0;
                while (i < this.buttons.length) {
                    if (this.buttons[i].getSelection()) {
                        values.add(this.literals[i]);
                    }
                    ++i;
                }
                return EnumSetOption.this.getCmdLine(values);
            }
        };
    }
}

