/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen;

import java.util.List;
import org.eclipse.escet.chi.codegen.CodeGeneratorContext;
import org.eclipse.escet.chi.codegen.java.JavaEnum;
import org.eclipse.escet.chi.codegen.java.JavaMethod;
import org.eclipse.escet.chi.codegen.types.TypeID;
import org.eclipse.escet.chi.metamodel.chi.EnumDeclaration;
import org.eclipse.escet.chi.metamodel.chi.EnumValue;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.VBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class EnumCodeGenerator {
    private EnumCodeGenerator() {
    }

    private static EnumReadStage constructReadStage(EnumDeclaration ed) {
        EnumReadStage root = new EnumReadStage(null);
        for (EnumValue ev : ed.getValues()) {
            String valText = ev.getName();
            EnumReadStage current = root;
            int i = 0;
            while (i < valText.length()) {
                EnumReadStage next = null;
                String s = valText.substring(i, i + 1);
                for (EnumReadContinuation erc : current.continuations) {
                    if (!erc.next.equals(s)) continue;
                    next = erc.stage;
                    break;
                }
                if (next == null) {
                    EnumReadContinuation erc;
                    next = new EnumReadStage(null);
                    erc = new EnumReadContinuation(s, next);
                    current.continuations.add(erc);
                }
                current = next;
                ++i;
            }
            Assert.check((current.value == null ? 1 : 0) != 0);
            current.value = valText;
        }
        return root;
    }

    public static void transEnumDeclaration(TypeID tid, EnumDeclaration ed, CodeGeneratorContext ctxt) {
        String enumName = "ChiEnum_" + ed.getName();
        JavaEnum jc = new JavaEnum(enumName);
        ctxt.addTypeName(tid, enumName);
        for (EnumValue ev : ed.getValues()) {
            jc.addValue("EV_" + ev.getName());
        }
        JavaMethod func = new JavaMethod("public void write(ChiFileHandle stream)");
        jc.addImport("org.eclipse.escet.chi.runtime.data.io.ChiFileHandle", false);
        func.lines.add("switch (this) {");
        func.lines.indent();
        for (EnumValue ev : ed.getValues()) {
            String valName = "EV_" + ev.getName();
            func.lines.add("case %s: stream.write(\"%s\"); break;", new Object[]{valName, ev.getName()});
        }
        func.lines.dedent();
        func.lines.add("}");
        jc.addMethod(func);
        func = new JavaMethod("public String toString()");
        func.lines.add("ChiWriteMemoryFile mem = new ChiWriteMemoryFile();");
        func.lines.add("write(mem);");
        func.lines.add("return mem.getData();");
        jc.addMethod(func);
        jc.addImport("org.eclipse.escet.chi.runtime.data.io.ChiWriteMemoryFile", false);
        func = new JavaMethod("public static " + enumName + " read(ChiCoordinator chiCoordinator, ChiFileHandle stream)");
        jc.addImport("org.eclipse.escet.chi.runtime.ChiCoordinator", false);
        EnumReadStage root = EnumCodeGenerator.constructReadStage(ed);
        root.setupMarkCount();
        func.lines.dedent();
        func.lines.add(root.boxify("stream", 1));
        func.lines.add("    throw new ChiSimulatorException(\"Could not find a literal enum value at the input.\");");
        jc.addMethod(func);
        jc.addImport("org.eclipse.escet.chi.runtime.ChiSimulatorException", false);
        ctxt.addClass(jc);
    }

    public static class EnumReadContinuation {
        public final String next;
        public final EnumReadStage stage;

        public EnumReadContinuation(String next, EnumReadStage stage) {
            this.next = next;
            this.stage = stage;
        }
    }

    public static class EnumReadStage {
        public String value;
        int markCount;
        public List<EnumReadContinuation> continuations;

        public EnumReadStage(String value) {
            this.value = value;
            this.continuations = Lists.list();
        }

        public int setupMarkCount() {
            int num = 0;
            for (EnumReadContinuation erc : this.continuations) {
                int val = erc.stage.setupMarkCount();
                if (val <= num) continue;
                num = val;
            }
            this.markCount = num + 1;
            if (this.value != null) {
                return 0;
            }
            return num + 1;
        }

        public Box boxify(String streamName, int level) {
            VBox vb = new VBox(4);
            if (this.continuations.isEmpty()) {
                Assert.notNull((Object)this.value);
                vb.add("return EV_" + this.value + ";");
                return vb;
            }
            if (this.value != null) {
                vb.add(Strings.fmt((String)"%s.markStream(%d);", (Object[])new Object[]{streamName, this.markCount}));
            }
            String karName = Strings.fmt((String)"kar_%d", (Object[])new Object[]{level});
            if (level == 1) {
                vb.add("int " + karName + ";");
                vb.add("do {");
                vb.add(Strings.fmt((String)"    %s = %s.read();", (Object[])new Object[]{karName, streamName}));
                vb.add(Strings.fmt((String)"} while (%s == ' ' || %s == '\\t' || %s == '\\n' || %s == '\\r');", (Object[])new Object[]{karName, karName, karName, karName}));
            } else {
                vb.add("int " + karName + " = " + streamName + ".read();");
            }
            ++level;
            for (EnumReadContinuation erc : this.continuations) {
                vb.add("if (" + karName + " == '" + erc.next + "') {");
                vb.add(erc.stage.boxify(streamName, level));
                vb.add("}");
            }
            if (this.value != null) {
                vb.add(Strings.fmt((String)"%s.resetStream();", (Object[])new Object[]{streamName}));
                vb.add("return EV_" + this.value + ";");
            }
            return vb;
        }
    }
}

