/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.runtime.data.random;

import org.eclipse.escet.chi.runtime.ChiCoordinator;
import org.eclipse.escet.chi.runtime.ChiSimulatorException;
import org.eclipse.escet.chi.runtime.data.random.IntegerDistribution;
import org.eclipse.escet.chi.runtime.data.random.RandomGenerator;
import org.eclipse.escet.common.java.Strings;

public class IntegerUniformDistribution
extends IntegerDistribution {
    private RandomGenerator randGen;
    private int low;
    private int high;

    public IntegerUniformDistribution(ChiCoordinator chiCoordinator, int low, int high) {
        super(chiCoordinator);
        if (low >= high) {
            String msg = Strings.fmt((String)"The integer Uniform distribution expects the lower bound to be less than the higher bound, found interval [%s..%s) intead.", (Object[])new Object[]{low, high});
            throw new ChiSimulatorException(msg);
        }
        this.low = low;
        this.high = high;
        this.randGen = chiCoordinator.getFreshGenerator();
    }

    @Override
    public int sample() {
        return IntegerUniformDistribution.drawIntegerUniform(this.randGen, this.low, this.high);
    }

    public static int drawIntegerUniform(RandomGenerator randGen, int low, int up) {
        int range = up - low;
        return low + (int)((double)range * randGen.draw());
    }
}

