/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotatedObject;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.common.java.Sets;

public class RemoveAnnotations
extends CifWalker
implements CifToCifTransformation {
    private final Set<String> annotationsToKeep;

    public RemoveAnnotations() {
        this(Collections.emptySet());
    }

    public RemoveAnnotations(String ... annotationsToKeep) {
        this(Sets.list2set(Arrays.asList(annotationsToKeep)));
    }

    public RemoveAnnotations(Set<String> annotationsToKeep) {
        this.annotationsToKeep = annotationsToKeep;
    }

    @Override
    public void transform(Specification spec) {
        this.walkSpecification(spec);
    }

    protected void preprocessAnnotatedObject(AnnotatedObject annotatedObj) {
        Object annos = annotatedObj.getAnnotations();
        if (!annos.isEmpty()) {
            if (this.annotationsToKeep.isEmpty()) {
                annos.clear();
            } else {
                annos = annos.stream().filter(anno -> this.annotationsToKeep.contains(anno.getName())).toList();
                annotatedObj.getAnnotations().clear();
                annotatedObj.getAnnotations().addAll((Collection)annos);
            }
        }
    }
}

