/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2plc.writers;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcArrayType;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcConfiguration;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcDerivedType;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcElementaryType;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcEnumType;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcGlobalVarList;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcPou;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcPouInstance;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcProject;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcResource;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcStructType;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcTask;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcType;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcTypeDecl;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcValue;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcVariable;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.HBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.box.TextBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InputOutputException;

public abstract class OutputTypeWriter {
    public static final int INDENT = 4;

    public abstract void write(PlcProject var1, String var2);

    protected void ensureDirectory(String outPath) {
        String absPath = org.eclipse.escet.common.app.framework.Paths.resolve((String)outPath);
        Path nioAbsPath = Paths.get(absPath, new String[0]);
        if (!Files.isDirectory(nioAbsPath, new LinkOption[0])) {
            try {
                Files.createDirectories(nioAbsPath, new FileAttribute[0]);
            }
            catch (IOException ex) {
                String msg = Strings.fmt((String)"Failed to create output directory \"%s\" for the generated PLC code.", (Object[])new Object[]{outPath});
                throw new InputOutputException(msg, (Throwable)ex);
            }
        }
    }

    protected Box toBox(PlcProject project) {
        MemoryCodeBox c = new MemoryCodeBox(4);
        c.add("PROJECT %s", new Object[]{project.name});
        c.indent();
        for (PlcTypeDecl typeDecl : project.typeDecls) {
            c.add(this.toBox(typeDecl));
        }
        for (PlcPou pou : project.pous) {
            c.add(this.toBox(pou));
        }
        for (PlcConfiguration configuration : project.configurations) {
            c.add(this.toBox(configuration));
        }
        c.dedent();
        c.add("END_PROJECT");
        return c;
    }

    protected Box toBox(PlcConfiguration configuration) {
        MemoryCodeBox c = new MemoryCodeBox(4);
        c.add("CONFIGURATION %s", new Object[]{configuration.name});
        c.indent();
        for (PlcGlobalVarList globalVarList : configuration.globalVarLists) {
            if (globalVarList.variables.isEmpty()) continue;
            c.add(this.toBox(globalVarList));
        }
        Assert.check((configuration.resources.size() <= 1 ? 1 : 0) != 0);
        for (PlcResource resource : configuration.resources) {
            c.add(this.toBox(resource));
        }
        c.dedent();
        c.add("END_CONFIGURATION");
        return c;
    }

    protected Box toBox(PlcTask task) {
        return new TextBox("TASK %s(INTERVAL := t#%dms, PRIORITY := %d);", new Object[]{task.name, task.cycleTime, task.priority});
    }

    protected Box toBox(PlcResource resource) {
        MemoryCodeBox c = new MemoryCodeBox(4);
        for (PlcGlobalVarList globalVarList : resource.globalVarLists) {
            if (globalVarList.variables.isEmpty()) continue;
            c.add(this.toBox(globalVarList));
        }
        for (PlcTask task : resource.tasks) {
            c.add(this.toBox(task));
        }
        for (PlcPouInstance pouInstance : resource.pouInstances) {
            c.add(this.toBox(pouInstance, null));
        }
        for (PlcTask task : resource.tasks) {
            for (PlcPouInstance pouInstance : task.pouInstances) {
                c.add(this.toBox(pouInstance, task.name));
            }
        }
        return c;
    }

    protected Box toBox(PlcGlobalVarList globVarList) {
        Assert.check((!globVarList.variables.isEmpty() ? 1 : 0) != 0);
        MemoryCodeBox c = new MemoryCodeBox(4);
        c.add("VAR_GLOBAL%s // %s", new Object[]{globVarList.constants ? " CONSTANT" : "", globVarList.name});
        c.indent();
        for (PlcVariable variable : globVarList.variables) {
            c.add(this.toBox(variable));
        }
        c.dedent();
        c.add("END_VAR");
        return c;
    }

    protected Box toBox(PlcVariable variable) {
        String addrTxt = variable.address == null ? "" : Strings.fmt((String)" AT %s", (Object[])new Object[]{variable.address});
        String valueTxt = variable.value == null ? "" : Strings.fmt((String)" := %s", (Object[])new Object[]{this.toBox(variable.value)});
        String txt = Strings.fmt((String)"%s%s: %s%s;", (Object[])new Object[]{variable.name, addrTxt, this.toBox(variable.type), valueTxt});
        return new TextBox(txt);
    }

    protected Box toBox(PlcPouInstance pouInstance) {
        return this.toBox(pouInstance, null);
    }

    protected Box toBox(PlcPouInstance pouInstance, String taskName) {
        String taskTxt = taskName == null ? "" : Strings.fmt((String)" WITH %s", (Object[])new Object[]{taskName});
        return new TextBox("PROGRAM %s%s: %s;", new Object[]{pouInstance.name, taskTxt, pouInstance.pou.name});
    }

    protected Box toBox(PlcPou pou) {
        CodeBox c = this.headerToBox(pou);
        c.add();
        c.add((Box)pou.body);
        c.add("END_%s", new Object[]{pou.pouType});
        return c;
    }

    protected CodeBox headerToBox(PlcPou pou) {
        MemoryCodeBox c = new MemoryCodeBox(4);
        String retTypeTxt = pou.retType == null ? "" : Strings.fmt((String)": %s", (Object[])new Object[]{this.toBox(pou.retType)});
        c.add("%s %s%s", new Object[]{pou.pouType, pou.name, retTypeTxt});
        if (!pou.inputVars.isEmpty()) {
            c.add("VAR_INPUT");
            c.indent();
            for (PlcVariable var : pou.inputVars) {
                c.add(this.toBox(var));
            }
            c.dedent();
            c.add("END_VAR");
        }
        if (!pou.outputVars.isEmpty()) {
            c.add("VAR_OUTPUT");
            c.indent();
            for (PlcVariable var : pou.outputVars) {
                c.add(this.toBox(var));
            }
            c.dedent();
            c.add("END_VAR");
        }
        if (!pou.localVars.isEmpty()) {
            c.add("VAR");
            c.indent();
            for (PlcVariable var : pou.localVars) {
                c.add(this.toBox(var));
            }
            c.dedent();
            c.add("END_VAR");
        }
        if (!pou.tempVars.isEmpty()) {
            c.add("VAR_TEMP");
            c.indent();
            for (PlcVariable var : pou.tempVars) {
                c.add(this.toBox(var));
            }
            c.dedent();
            c.add("END_VAR");
        }
        return c;
    }

    protected Box toBox(PlcValue value) {
        return new TextBox(value.value);
    }

    protected Box toBox(PlcType type) {
        if (type instanceof PlcArrayType) {
            return this.toBox((PlcArrayType)type);
        }
        if (type instanceof PlcDerivedType) {
            return this.toBox((PlcDerivedType)type);
        }
        if (type instanceof PlcElementaryType) {
            return this.toBox((PlcElementaryType)type);
        }
        if (type instanceof PlcEnumType) {
            return this.toBox((PlcEnumType)type);
        }
        if (type instanceof PlcStructType) {
            return this.toBox((PlcStructType)type);
        }
        String typeText = type == null ? "null" : type.getClass().toString();
        throw new AssertionError((Object)("Unexpected PlcType, found: " + typeText + "."));
    }

    protected Box toBox(PlcTypeDecl typeDecl) {
        MemoryCodeBox c = new MemoryCodeBox(4);
        c.add("TYPE %s:", new Object[]{typeDecl.name});
        c.indent();
        c.add((Box)new HBox(new Object[]{this.toBox(typeDecl.type), ";"}));
        c.dedent();
        c.add("END_TYPE");
        return c;
    }

    protected Box toBox(PlcEnumType enumType) {
        return new TextBox("(%s)", new Object[]{String.join((CharSequence)", ", enumType.literals)});
    }

    protected Box toBox(PlcElementaryType elementaryType) {
        return new TextBox(elementaryType.name);
    }

    protected Box toBox(PlcDerivedType derivedType) {
        return new TextBox(derivedType.name);
    }

    protected Box toBox(PlcArrayType arrayType) {
        HBox b = new HBox();
        b.add(Strings.fmt((String)"ARRAY[%d..%d] of ", (Object[])new Object[]{arrayType.lower, arrayType.upper}));
        b.add(this.toBox(arrayType.elemType));
        return b;
    }

    protected Box toBox(PlcStructType structType) {
        MemoryCodeBox c = new MemoryCodeBox(4);
        c.add("STRUCT");
        c.indent();
        for (PlcVariable field : structType.fields) {
            c.add(this.toBox(field));
        }
        c.dedent();
        c.add("END_STRUCT");
        return c;
    }
}

