/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.CifToCifPreconditionException;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;

public class RemoveUnusedEvents
extends CifWalker
implements CifToCifTransformation {
    private Set<Event> allEvents = Sets.set();
    private Set<Event> allUsedEvents = Sets.set();

    @Override
    public void transform(Specification spec) {
        if (CifScopeUtils.hasCompDefInst((Group)spec)) {
            String msg = "Eliminating unused events from a CIF specification with component definitions is currently not supported.";
            throw new CifToCifPreconditionException(msg);
        }
        this.walkSpecification(spec);
        Set unusedEvents = Sets.difference(this.allEvents, this.allUsedEvents);
        for (Event ue : unusedEvents) {
            EMFHelper.removeFromParentContainment((EObject)ue);
        }
    }

    protected void preprocessComplexComponent(ComplexComponent comp) {
        this.allEvents.addAll(Lists.filter((List)comp.getDeclarations(), Event.class));
    }

    protected void walkEventExpression(EventExpression eventRef) {
        Event event = eventRef.getEvent();
        this.allUsedEvents.add(event);
    }
}

