/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.ui.util;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.core.math.KielerMath;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KInsets;
import de.cau.cs.kieler.kiml.klayoutdata.KPoint;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.EdgeRouting;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KGraphRenderer {
    private static final int NODE_FONT_SIZE = 9;
    private static final int PORT_FONT_SIZE = 6;
    private static final int EDGE_FONT_SIZE = 8;
    private static final double ARROW_LENGTH = 8.0;
    private static final double ARROW_WIDTH = 7.0;
    private final Map<Object, PaintRectangle> boundsMap = new LinkedHashMap<Object, PaintRectangle>();
    private Color nodeBorderColor;
    private Color nodeFillColor;
    private Font nodeFont;
    private Color portColor;
    private Font portFont;
    private Color edgeColor;
    private Font edgeFont;
    private double scale;
    private KVector baseOffset;

    public KGraphRenderer(Display display) {
        this(display, 1.0, new KVector());
    }

    public KGraphRenderer(Display display, double thescale, KVector thebaseOffset) {
        this.scale = thescale;
        this.baseOffset = thebaseOffset;
        this.nodeBorderColor = new Color((Device)display, 2, 15, 3);
        this.nodeFillColor = new Color((Device)display, 87, 197, 133);
        int nodeFontSize = Math.max((int)Math.round(9.0 * thescale), 2);
        this.nodeFont = new Font((Device)display, "sans", nodeFontSize, 0);
        this.portColor = new Color((Device)display, 2, 9, 40);
        int portFontSize = Math.max((int)Math.round(6.0 * thescale), 2);
        this.portFont = new Font((Device)display, "sans", portFontSize, 0);
        this.edgeColor = new Color((Device)display, 23, 36, 54);
        int edgeFontSize = Math.max((int)Math.round(8.0 * thescale), 2);
        this.edgeFont = new Font((Device)display, "sans", edgeFontSize, 0);
    }

    public void dispose() {
        this.clear();
        this.nodeBorderColor.dispose();
        this.nodeFillColor.dispose();
        this.nodeFont.dispose();
        this.portColor.dispose();
        this.portFont.dispose();
        this.edgeColor.dispose();
        this.edgeFont.dispose();
    }

    public void markDirty(Rectangle area) {
        for (PaintRectangle rectangle : this.boundsMap.values()) {
            if (area != null && !rectangle.intersects(area)) continue;
            rectangle.painted = false;
        }
    }

    public void clear() {
        this.boundsMap.clear();
    }

    public void render(KNode parentNode, GC graphics, Rectangle area) {
        graphics.setInterpolation(2);
        int maxDepth = Math.max(this.maxDepth(parentNode), 1);
        int nodeAlpha = 200 / maxDepth + 55;
        HashSet<KEdge> edgeSet = new HashSet<KEdge>();
        this.renderNode(parentNode, graphics, area, this.baseOffset, edgeSet, nodeAlpha);
        graphics.setForeground(this.edgeColor);
        graphics.setBackground(this.edgeColor);
        graphics.setAlpha(255);
        graphics.setFont(this.edgeFont);
        for (KEdge edge : edgeSet) {
            this.renderEdge(parentNode, edge, graphics, area);
        }
    }

    private int maxDepth(KNode parent) {
        int maxDepth = 0;
        for (KNode child : parent.getChildren()) {
            int depth = this.maxDepth(child) + 1;
            if (depth <= maxDepth) continue;
            maxDepth = depth;
        }
        return maxDepth;
    }

    private void renderNode(KNode node, GC graphics, Rectangle area, KVector offset, Set<KEdge> edgeSet, int nodeAlpha) {
        for (KNode child : node.getChildren()) {
            PaintRectangle rect = this.boundsMap.get(child);
            if (rect == null) {
                rect = new PaintRectangle((KShapeLayout)child.getData(KShapeLayout.class), offset, this.scale);
                this.boundsMap.put(child, rect);
            }
            KVector childOffset = new KVector((double)rect.x, (double)rect.y);
            graphics.setForeground(this.nodeBorderColor);
            graphics.setBackground(this.nodeFillColor);
            if (!rect.painted && rect.intersects(area)) {
                graphics.setAlpha(nodeAlpha);
                graphics.fillRectangle(rect.x, rect.y, rect.width, rect.height);
                graphics.drawRectangle(rect.x, rect.y, rect.width, rect.height);
                rect.painted = true;
                KVector contentOffset = new KVector(childOffset);
                KInsets insets = ((KShapeLayout)child.getData(KShapeLayout.class)).getInsets();
                contentOffset.translate((double)insets.getLeft() * this.scale, (double)insets.getTop() * this.scale);
                this.renderNode(child, graphics, area, contentOffset, edgeSet, nodeAlpha);
            }
            graphics.setAlpha(255);
            graphics.setFont(this.nodeFont);
            for (KLabel label : child.getLabels()) {
                this.renderLabel(label, graphics, area, childOffset);
            }
            for (KPort port : child.getPorts()) {
                this.renderPort(port, graphics, area, childOffset);
            }
            edgeSet.addAll((Collection<KEdge>)child.getIncomingEdges());
            edgeSet.addAll((Collection<KEdge>)child.getOutgoingEdges());
        }
    }

    private void renderLabel(KLabel label, GC graphics, Rectangle area, KVector offset) {
        PaintRectangle rect = this.boundsMap.get(label);
        KShapeLayout labelLayout = (KShapeLayout)label.getData(KShapeLayout.class);
        if (rect == null) {
            rect = new PaintRectangle(labelLayout, offset, this.scale);
            this.boundsMap.put(label, rect);
        }
        if (!rect.painted && rect.intersects(area)) {
            String text = label.getText();
            if (text != null && text.length() > 0) {
                graphics.drawString(text, rect.x, rect.y, true);
            }
            rect.painted = true;
        }
    }

    private void renderPort(KPort port, GC graphics, Rectangle area, KVector offset) {
        graphics.setForeground(this.portColor);
        graphics.setBackground(this.portColor);
        graphics.setFont(this.portFont);
        graphics.setAlpha(255);
        PaintRectangle rect = this.boundsMap.get(port);
        if (rect == null) {
            rect = new PaintRectangle((KShapeLayout)port.getData(KShapeLayout.class), offset, this.scale);
            this.boundsMap.put(port, rect);
        }
        if (!rect.painted && rect.intersects(area)) {
            graphics.fillRectangle(rect.x, rect.y, rect.width, rect.height);
            graphics.drawRectangle(rect.x, rect.y, rect.width, rect.height);
            rect.painted = true;
        }
        KVector portOffset = new KVector((double)rect.x, (double)rect.y);
        for (KLabel label : port.getLabels()) {
            this.renderLabel(label, graphics, area, portOffset);
        }
    }

    private void renderEdge(KNode graph, KEdge edge, GC graphics, Rectangle area) {
        if (!KimlUtil.isDescendant((KNode)edge.getSource(), (KNode)graph) || !KimlUtil.isDescendant((KNode)edge.getTarget(), (KNode)graph)) {
            return;
        }
        KNode parent = edge.getSource();
        if (!KimlUtil.isDescendant((KNode)edge.getTarget(), (KNode)parent)) {
            parent = parent.getParent();
        }
        KNode node = parent;
        KVector offset = new KVector(this.baseOffset);
        while (node != graph) {
            KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
            KInsets insets = nodeLayout.getInsets();
            offset.translate((double)(nodeLayout.getXpos() + insets.getLeft()), (double)(nodeLayout.getYpos() + insets.getTop()));
            node = node.getParent();
        }
        KEdgeLayout edgeLayout = (KEdgeLayout)edge.getData(KEdgeLayout.class);
        PaintRectangle rect = this.boundsMap.get(edge);
        if (rect == null) {
            rect = new PaintRectangle(edgeLayout, offset, this.scale);
            this.boundsMap.put(edge, rect);
        }
        if (!rect.painted && rect.intersects(area)) {
            KVectorChain bendPoints = edgeLayout.createVectorChain();
            if (edgeLayout.getProperty(LayoutOptions.EDGE_ROUTING) == EdgeRouting.SPLINES) {
                bendPoints = KielerMath.approximateSpline((KVectorChain)bendPoints);
            }
            bendPoints.scale(this.scale);
            KVector point1 = (KVector)bendPoints.getFirst();
            for (KVector point2 : bendPoints) {
                graphics.drawLine((int)Math.round(point1.x + offset.x), (int)Math.round(point1.y + offset.y), (int)Math.round(point2.x + offset.x), (int)Math.round(point2.y + offset.y));
                point1 = point2;
            }
            int[] arrowPoly = this.makeArrow((KVector)bendPoints.get(bendPoints.size() - 2), (KVector)bendPoints.getLast(), offset);
            if (arrowPoly != null) {
                graphics.fillPolygon(arrowPoly);
            }
            rect.painted = true;
        }
        for (KLabel label : edge.getLabels()) {
            this.renderLabel(label, graphics, area, offset);
        }
    }

    private int[] makeArrow(KVector point1, KVector point2, KVector offset) {
        if ((point1.x != point2.x || point1.y != point2.y) && 7.0 * this.scale >= 2.0) {
            int[] arrow = new int[6];
            arrow[0] = (int)Math.round(point2.x + offset.x);
            arrow[1] = (int)Math.round(point2.y + offset.y);
            double vectX = point1.x - point2.x;
            double vectY = point1.y - point2.y;
            double length = Math.sqrt(vectX * vectX + vectY * vectY);
            double normX = vectX / length;
            double normY = vectY / length;
            double neckX = point2.x + 8.0 * normX * this.scale;
            double neckY = point2.y + 8.0 * normY * this.scale;
            double orthX = normY * 7.0 / 2.0;
            double orthY = -normX * 7.0 / 2.0;
            arrow[2] = (int)Math.round(neckX + orthX + offset.x);
            arrow[3] = (int)Math.round(neckY + orthY + offset.y);
            arrow[4] = (int)Math.round(neckX - orthX + offset.x);
            arrow[5] = (int)Math.round(neckY - orthY + offset.y);
            return arrow;
        }
        return null;
    }

    private static class PaintRectangle {
        private int x;
        private int y;
        private int width;
        private int height;
        private boolean painted = false;

        PaintRectangle(KShapeLayout shapeLayout, KVector offset, double scale) {
            this.x = (int)Math.round((double)shapeLayout.getXpos() * scale + offset.x);
            this.y = (int)Math.round((double)shapeLayout.getYpos() * scale + offset.y);
            this.width = Math.max((int)Math.round((double)shapeLayout.getWidth() * scale), 1);
            this.height = Math.max((int)Math.round((double)shapeLayout.getHeight() * scale), 1);
        }

        PaintRectangle(KEdgeLayout edgeLayout, KVector offset, double scale) {
            float minX = edgeLayout.getSourcePoint().getX();
            float minY = edgeLayout.getSourcePoint().getY();
            float maxX = minX;
            float maxY = minY;
            for (KPoint point : edgeLayout.getBendPoints()) {
                minX = Math.min(minX, point.getX());
                minY = Math.min(minY, point.getY());
                maxX = Math.max(maxX, point.getX());
                maxY = Math.max(maxY, point.getY());
            }
            minX = Math.min(minX, edgeLayout.getTargetPoint().getX());
            minY = Math.min(minY, edgeLayout.getTargetPoint().getY());
            maxX = Math.max(maxX, edgeLayout.getTargetPoint().getX());
            maxY = Math.max(maxY, edgeLayout.getTargetPoint().getY());
            this.x = (int)Math.round((double)minX * scale + offset.x);
            this.y = (int)Math.round((double)minY * scale + offset.y);
            this.width = (int)Math.round((double)(maxX - minX) * scale);
            this.height = (int)Math.round((double)(maxY - minY) * scale);
        }

        public boolean intersects(Rectangle other) {
            return other.x < this.x + this.width && other.y < this.y + this.height && other.x + other.width > this.x && other.y + other.height > this.y;
        }
    }
}

