/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.ui.views;

import de.cau.cs.kieler.kiml.LayoutAlgorithmData;
import de.cau.cs.kieler.kiml.LayoutDataService;
import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.LayoutTypeData;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.ui.KimlUiPlugin;
import de.cau.cs.kieler.kiml.ui.Messages;
import de.cau.cs.kieler.kiml.ui.views.LayouterHintCellEditor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutPropertyDescriptor
implements IPropertyDescriptor {
    private LayoutOptionData<?> optionData;
    private LayoutOptionLabelProvider labelProvider;

    public LayoutPropertyDescriptor(LayoutOptionData<?> theoptionData) {
        this.optionData = theoptionData;
    }

    public CellEditor createPropertyEditor(Composite parent) {
        switch (this.optionData.getType()) {
            case STRING: {
                if (LayoutOptions.ALGORITHM.equals(this.optionData)) {
                    return new LayouterHintCellEditor(parent);
                }
                return new TextCellEditor(parent);
            }
            case INT: {
                TextCellEditor intEditor = new TextCellEditor(parent);
                intEditor.setValidator(new ICellEditorValidator(){

                    public String isValid(Object value) {
                        try {
                            Integer.parseInt((String)value);
                            return null;
                        }
                        catch (NumberFormatException numberFormatException) {
                            return Messages.getString("kiml.ui.6");
                        }
                    }
                });
                return intEditor;
            }
            case FLOAT: {
                TextCellEditor floatEditor = new TextCellEditor(parent);
                floatEditor.setValidator(new ICellEditorValidator(){

                    public String isValid(Object value) {
                        try {
                            Float.parseFloat((String)value);
                            return null;
                        }
                        catch (NumberFormatException numberFormatException) {
                            return Messages.getString("kiml.ui.7");
                        }
                    }
                });
                return floatEditor;
            }
            case BOOLEAN: 
            case ENUM: 
            case REMOTE_ENUM: {
                return new ComboBoxCellEditor(parent, this.optionData.getChoices(), 8);
            }
            case OBJECT: {
                return new TextCellEditor(parent);
            }
        }
        return null;
    }

    public String getCategory() {
        return this.optionData.getTargetsDescription();
    }

    public String getDescription() {
        return this.optionData.getDescription();
    }

    public String getDisplayName() {
        return this.optionData.getName();
    }

    public String[] getFilterFlags() {
        if (this.optionData.isAdvanced()) {
            return new String[]{"org.eclipse.ui.views.properties.expert"};
        }
        return null;
    }

    public Object getHelpContextIds() {
        return null;
    }

    public Object getId() {
        return this.optionData.getId();
    }

    public ILabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new LayoutOptionLabelProvider();
        }
        return this.labelProvider;
    }

    public boolean isCompatibleWith(IPropertyDescriptor anotherProperty) {
        return anotherProperty instanceof LayoutPropertyDescriptor && this.optionData.getId().equals(anotherProperty.getId());
    }

    private class LayoutOptionLabelProvider
    extends LabelProvider {
        private LayoutOptionLabelProvider() {
        }

        public Image getImage(Object element) {
            KimlUiPlugin.Images images = KimlUiPlugin.getDefault().getImages();
            switch (LayoutPropertyDescriptor.this.optionData.getType()) {
                case STRING: 
                case OBJECT: {
                    return images.getPropText();
                }
                case BOOLEAN: {
                    if ((Integer)element == 1) {
                        return images.getPropTrue();
                    }
                    return images.getPropFalse();
                }
                case ENUM: 
                case REMOTE_ENUM: {
                    return images.getPropChoice();
                }
                case INT: {
                    return images.getPropInt();
                }
                case FLOAT: {
                    return images.getPropFloat();
                }
            }
            return null;
        }

        public String getText(Object element) {
            switch (LayoutPropertyDescriptor.this.optionData.getType()) {
                case STRING: {
                    LayoutDataService layoutServices = LayoutDataService.getInstance();
                    if (LayoutOptions.ALGORITHM.equals(LayoutPropertyDescriptor.this.optionData)) {
                        String layoutHint = (String)element;
                        LayoutTypeData layoutType = layoutServices.getTypeData(layoutHint);
                        if (layoutType != null) {
                            return layoutType.toString();
                        }
                        LayoutAlgorithmData layouterData = layoutServices.getAlgorithmData(layoutHint);
                        if (layouterData != null) {
                            return layouterData.toString();
                        }
                        return Messages.getString("kiml.ui.8");
                    }
                    return (String)element;
                }
                case BOOLEAN: 
                case REMOTE_ENUM: {
                    return LayoutPropertyDescriptor.this.optionData.getChoices()[(Integer)element];
                }
                case ENUM: {
                    return LayoutPropertyDescriptor.this.optionData.getChoices()[(Integer)element];
                }
            }
            return element.toString();
        }
    }
}

