/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.core.properties.IPropertyHolder;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.ListIterator;

public class LongEdgeSplitter
extends AbstractAlgorithm
implements ILayoutProcessor {
    public void process(LGraph layeredGraph) {
        this.getMonitor().begin("Edge splitting", 1.0f);
        ListIterator<Layer> layerIter = layeredGraph.getLayers().listIterator();
        while (layerIter.hasNext()) {
            Layer layer = layerIter.next();
            int layerIndex = layerIter.previousIndex();
            for (LNode node : layer) {
                for (LPort port : node.getPorts()) {
                    for (LEdge edge : port.getOutgoingEdges()) {
                        LPort targetPort = edge.getTarget();
                        int targetIndex = targetPort.getNode().getLayer().getIndex();
                        assert (targetIndex >= layerIndex);
                        if (targetIndex <= layerIndex + 1) continue;
                        Layer nextLayer = layerIter.next();
                        LNode dummyNode = new LNode(layeredGraph);
                        dummyNode.setProperty(Properties.ORIGIN, edge);
                        dummyNode.setProperty(Properties.NODE_TYPE, (Object)NodeType.LONG_EDGE);
                        dummyNode.setProperty(LayoutOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_POS);
                        dummyNode.setLayer(nextLayer);
                        LPort dummyInput = new LPort(layeredGraph);
                        dummyInput.setSide(PortSide.WEST);
                        dummyInput.setNode(dummyNode);
                        LPort dummyOutput = new LPort(layeredGraph);
                        dummyOutput.setSide(PortSide.EAST);
                        dummyOutput.setNode(dummyNode);
                        edge.setTarget(dummyInput);
                        LEdge dummyEdge = new LEdge(layeredGraph);
                        dummyEdge.copyProperties((IPropertyHolder)edge);
                        dummyEdge.setSource(dummyOutput);
                        dummyEdge.setTarget(targetPort);
                        this.setDummyProperties(dummyNode, edge, dummyEdge);
                        layerIter.previous();
                    }
                }
            }
        }
        this.getMonitor().done();
    }

    private void setDummyProperties(LNode dummy, LEdge inEdge, LEdge outEdge) {
        LNode inEdgeSourceNode = inEdge.getSource().getNode();
        if (inEdgeSourceNode.getProperty(Properties.NODE_TYPE) == NodeType.LONG_EDGE) {
            dummy.setProperty(Properties.LONG_EDGE_SOURCE, inEdgeSourceNode.getProperty(Properties.LONG_EDGE_SOURCE));
            dummy.setProperty(Properties.LONG_EDGE_TARGET, inEdgeSourceNode.getProperty(Properties.LONG_EDGE_TARGET));
        } else {
            dummy.setProperty(Properties.LONG_EDGE_SOURCE, inEdge.getSource());
            dummy.setProperty(Properties.LONG_EDGE_TARGET, outEdge.getTarget());
        }
    }
}

