/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.core.math;

import de.cau.cs.kieler.core.math.BezierSpline;
import de.cau.cs.kieler.core.math.ISplineInterpolator;
import de.cau.cs.kieler.core.math.KVector;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CubicSplineInterpolator
implements ISplineInterpolator {
    private static final double[][] INTERP_COEF_EVEN = new double[][]{{0.25}, {0.2677, -0.0667}, {0.2679, -0.0714, 0.0179}, {0.2679, -0.0718, 0.0191, -0.0048}, {0.2679, -0.0718, 0.0192, -0.0051, 0.0013}, {0.2679, -0.0718, 0.0192, -0.0052, 0.0014, -3.0E-4}, {0.2679, -0.0718, 0.0192, -0.0052, 0.0014, -4.0E-4, 1.0E-4}};
    private static final double[][] INTERP_COEF_ODD = new double[][]{{0.3333}, {0.2727, -0.0909}, {0.2683, -0.0732, 0.0244}, {0.268, -0.0719, 0.0196, -0.0065}, {0.268, -0.0718, 0.0193, -0.0053, 0.0018}, {0.2679, -0.0718, 0.0192, -0.0052, 0.0014, -5.0E-4}, {0.2679, -0.0718, 0.0192, -0.0052, 0.0014, -4.0E-4, 1.0E-4}};
    private static final int MAX_K = 7;
    private static final double TANGENT_SCALE = 0.25;

    public BezierSpline calculateClosedBezierSpline(KVector[] points) {
        BezierSpline spline = new BezierSpline();
        int n = points.length;
        boolean even = n % 2 == 0;
        int m = even ? (n - 2) / 2 : (n - 1) / 2;
        m = Math.min(m, 7);
        double a = 0.0;
        KVector[] d = new KVector[n];
        int i = 0;
        while (i < n) {
            d[i] = new KVector();
            int k = 1;
            while (k <= m) {
                a = even ? INTERP_COEF_ODD[Math.min(m - 1, 6)][Math.min(k - 1, 6)] : INTERP_COEF_EVEN[Math.min(m - 1, 6)][Math.min(k - 1, 6)];
                d[i].x += a * (points[(i + k) % n].x - points[(i - k + n) % n].x);
                d[i].y += a * (points[(i + k) % n].y - points[(i - k + n) % n].y);
                ++k;
            }
            ++i;
        }
        i = 0;
        while (i < n) {
            spline.addCurve(points[i], KVector.sum(d[i], points[i]), KVector.diff(points[(i + 1) % n], d[(i + 1) % n]), points[(i + 1) % n]);
            ++i;
        }
        return spline;
    }

    private BezierSpline calculateOpenBezierSpline(KVector[] points) {
        return this.calculateOpenBezierSpline(points, KVector.diff(points[1], points[0]).normalize(), KVector.diff(points[points.length - 2], points[points.length - 1]).normalize(), false);
    }

    private BezierSpline calculateOpenBezierSpline(KVector[] points, KVector startTan, KVector endTan, boolean tangentScale) {
        BezierSpline spline = new BezierSpline();
        int n = points.length - 1;
        KVector[] t = new KVector[2 * n];
        KVector[] d = new KVector[n + 1];
        double startScale = 1.0;
        double endScale = 1.0;
        if (tangentScale) {
            if (points.length == 2) {
                endScale = startScale = KVector.distance(points[0], points[1]) * 0.25;
            } else {
                startScale = KVector.distance(points[0], points[1]) * 0.25;
                endScale = KVector.distance(points[n - 1], points[n]) * 0.25;
            }
        }
        d[0] = startTan.scaledCreate(startScale);
        d[n] = endTan.scaledCreate(endScale);
        t[0] = KVector.sum(points[0], d[0]);
        t[n] = KVector.diff(points[n], d[n]);
        int i = 1;
        while (i < n) {
            t[i] = points[i];
            t[2 * n - i] = t[i];
            ++i;
        }
        int m = Math.min(n - 1, 7);
        double a = 0.0;
        int i2 = 1;
        while (i2 < n) {
            d[i2] = new KVector();
            int k = 1;
            while (k <= m) {
                a = INTERP_COEF_EVEN[m - 1][k - 1];
                d[i2].x += a * (t[i2 + k].x - t[Math.abs((int)(i2 - k))].x);
                d[i2].y += a * (t[i2 + k].y - t[Math.abs((int)(i2 - k))].y);
                ++k;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < n) {
            KVector bend1 = KVector.sum(points[i2], d[i2]);
            KVector bend2 = KVector.diff(points[i2 + 1], d[i2 + 1]);
            spline.addCurve(points[i2], bend1, bend2, points[i2 + 1]);
            ++i2;
        }
        return spline;
    }

    @Override
    public BezierSpline interpolatePoints(KVector[] points) {
        return this.calculateOpenBezierSpline(points);
    }

    @Override
    public BezierSpline interpolatePoints(LinkedList<KVector> points) {
        return this.calculateOpenBezierSpline(points.toArray(new KVector[points.size()]));
    }

    @Override
    public BezierSpline interpolatePoints(KVector[] points, KVector startVec, KVector endVec, boolean tangendScale) {
        return this.calculateOpenBezierSpline(points, startVec, endVec, tangendScale);
    }

    @Override
    public BezierSpline interpolatePoints(LinkedList<KVector> points, KVector startVec, KVector endVec, boolean tangendScale) {
        return this.calculateOpenBezierSpline(points.toArray(new KVector[points.size()]), startVec, endVec, tangendScale);
    }
}

