/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.mgmt.configurationadmin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.openmbean.TabularData;
import org.eclipse.gemini.mgmt.internal.OSGiProperties;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.jmx.service.cm.ConfigurationAdminMBean;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public final class ConfigAdminManager
implements ConfigurationAdminMBean {
    private final ConfigurationAdmin admin;
    private static final Logger log = Logger.getLogger(ConfigAdminManager.class.getCanonicalName());

    public ConfigAdminManager(ConfigurationAdmin admin) {
        this.admin = admin;
    }

    public String createFactoryConfiguration(String factoryPid) throws IOException {
        if (factoryPid == null) {
            throw new IOException("Factory PID must not be null");
        }
        Configuration c = this.admin.createFactoryConfiguration(factoryPid);
        c.setBundleLocation(null);
        return c.getPid();
    }

    public String createFactoryConfigurationForLocation(String factoryPid, String location) throws IOException {
        if (factoryPid == null) {
            throw new IOException("Factory PID must not be null");
        }
        Configuration c = this.admin.createFactoryConfiguration(factoryPid);
        c.setBundleLocation(location);
        return c.getPid();
    }

    public void delete(String pid) throws IOException {
        if (pid == null) {
            throw new IOException("PID must not be null");
        }
        this.admin.getConfiguration(pid, null).delete();
    }

    public void deleteForLocation(String pid, String location) throws IOException {
        if (pid == null) {
            throw new IOException("PID must not be null");
        }
        this.admin.getConfiguration(pid, location).delete();
    }

    public void deleteConfigurations(String filter) throws IOException {
        Configuration[] confs;
        try {
            confs = this.admin.listConfigurations(filter);
        }
        catch (InvalidSyntaxException e) {
            log.log(Level.SEVERE, "Invalid filter argument: " + filter, e);
            throw new IOException("Invalid filter: " + (Object)((Object)e));
        }
        if (confs != null) {
            Configuration[] configurationArray = confs;
            int n = confs.length;
            int n2 = 0;
            while (n2 < n) {
                Configuration conf = configurationArray[n2];
                conf.delete();
                ++n2;
            }
        }
    }

    public String getBundleLocation(String pid) throws IOException {
        if (pid == null) {
            throw new IOException("PID must not be null");
        }
        return this.admin.getConfiguration(pid, null).getBundleLocation();
    }

    public String getFactoryPid(String pid) throws IOException {
        if (pid == null) {
            throw new IOException("PID must not be null");
        }
        return this.admin.getConfiguration(pid, null).getFactoryPid();
    }

    public String getFactoryPidForLocation(String pid, String location) throws IOException {
        if (pid == null) {
            throw new IOException("PID must not be null");
        }
        return this.admin.getConfiguration(pid, location).getFactoryPid();
    }

    public TabularData getProperties(String pid) throws IOException {
        if (pid == null) {
            throw new IOException("PID must not be null");
        }
        Dictionary properties = this.admin.getConfiguration(pid, null).getProperties();
        return properties == null ? null : OSGiProperties.tableFrom(properties);
    }

    public TabularData getPropertiesForLocation(String pid, String location) throws IOException {
        if (pid == null) {
            throw new IOException("PID must not be null");
        }
        Dictionary properties = this.admin.getConfiguration(pid, location).getProperties();
        return properties == null ? null : OSGiProperties.tableFrom(properties);
    }

    public String[][] getConfigurations(String filter) throws IOException {
        Configuration[] configurations;
        ArrayList<String[]> pids = new ArrayList<String[]>();
        try {
            configurations = this.admin.listConfigurations(filter);
        }
        catch (InvalidSyntaxException e) {
            log.log(Level.SEVERE, "Invalid filter argument: " + filter, e);
            throw new IOException("Invalid filter: " + (Object)((Object)e));
        }
        if (configurations != null) {
            Configuration[] configurationArray = configurations;
            int n = configurations.length;
            int n2 = 0;
            while (n2 < n) {
                Configuration config = configurationArray[n2];
                pids.add(new String[]{config.getPid(), config.getBundleLocation()});
                ++n2;
            }
        }
        return (String[][])pids.toArray((T[])new String[pids.size()][]);
    }

    public void setBundleLocation(String pid, String location) throws IOException {
        if (pid == null) {
            throw new IOException("PID must not be null");
        }
        this.admin.getConfiguration(pid).setBundleLocation(location);
    }

    public void update(String pid, TabularData table) throws IOException {
        if (pid == null) {
            throw new IOException("PID must not be null");
        }
        this.admin.getConfiguration(pid, null).update(OSGiProperties.propertiesFrom(table));
    }

    public void updateForLocation(String pid, String location, TabularData table) throws IOException {
        if (pid == null) {
            throw new IOException("PID must not be null");
        }
        this.admin.getConfiguration(pid, location).update(OSGiProperties.propertiesFrom(table));
    }
}

