/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.threads;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class CounterLatch {
    private final Sync sync;
    private final AtomicLong count;
    private volatile long signal;
    private volatile boolean released = false;

    public CounterLatch(long initial, long waitValue) {
        this.signal = waitValue;
        this.count = new AtomicLong(initial);
        this.sync = new Sync();
    }

    public void await() throws InterruptedException {
        this.sync.acquireSharedInterruptibly(1);
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.sync.tryAcquireSharedNanos(1, unit.toNanos(timeout));
    }

    public long countUp() {
        long previous = this.count.getAndIncrement();
        if (previous == this.signal) {
            this.sync.releaseShared(0);
        }
        return previous;
    }

    public long countDown() {
        long previous = this.count.getAndDecrement();
        if (previous == this.signal) {
            this.sync.releaseShared(0);
        }
        return previous;
    }

    public long getCount() {
        return this.count.get();
    }

    public boolean compareAndSet(long expect, long update) {
        boolean result = this.count.compareAndSet(expect, update);
        if (result && expect == this.signal && expect != update) {
            this.sync.releaseShared(0);
        }
        return result;
    }

    public boolean hasQueuedThreads() {
        return this.sync.hasQueuedThreads();
    }

    public Collection<Thread> getQueuedThreads() {
        return this.sync.getQueuedThreads();
    }

    public boolean releaseAll() {
        this.released = true;
        return this.sync.releaseShared(0);
    }

    public void reset(long value) {
        this.count.set(value);
        this.released = false;
    }

    private class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 1L;

        @Override
        protected int tryAcquireShared(int arg) {
            return !CounterLatch.this.released && CounterLatch.this.count.get() == CounterLatch.this.signal ? -1 : 1;
        }

        @Override
        protected boolean tryReleaseShared(int arg) {
            return true;
        }
    }
}

