/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.script.acceleo;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.MtlPackage;
import org.eclipse.acceleo.model.mtl.TypedModel;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.ILogger;
import org.eclipse.gendoc.tags.handlers.IContextService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServicesExtension {
    private static final String EXTENSION_POINT_ID = "org.eclipse.gendoc.script.acceleo.services";
    private static final String EMTL = "emtl";
    private static final String NAME = "name";
    private static final String IMPORTEDBYDEFAULT = "importedByDefault";
    private static ServicesExtension instance;
    private final List<Bundle> bundles = new ArrayList<Bundle>();

    private ServicesExtension() {
        this.readExtensionPoint();
    }

    public static synchronized ServicesExtension getInstance() {
        if (instance == null) {
            instance = new ServicesExtension();
        }
        return instance;
    }

    private void readExtensionPoint() {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            Bundle bundle = new Bundle();
            try {
                String name = config.getAttribute(NAME);
                bundle.setName(name);
                bundle.setUri(this.findUri(config.getContributor().getName(), config.getAttribute(EMTL)));
                bundle.setImportedByDefault(Boolean.parseBoolean(config.getAttribute(IMPORTEDBYDEFAULT)));
                this.bundles.add(bundle);
            }
            catch (InvalidRegistryObjectException invalidRegistryObjectException) {
                ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
                logger.log("Error while reading extension point org.eclipse.gendoc.script.acceleo.services", 2);
            }
            ++n2;
        }
    }

    private URI findUri(String contributorId, String value) {
        ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
        if (value == null || contributorId == null) {
            return null;
        }
        org.osgi.framework.Bundle bundle = Platform.getBundle((String)contributorId);
        URL resource = bundle.getResource(value);
        if (resource == null && (value.startsWith("src") || value.startsWith("bin")) && (resource = bundle.getResource(value = value.substring(3, value.length()))) == null) {
            logger.log("the emtl file referenced in the plugin " + contributorId + " with uri : " + value + " is not available", 4);
            return null;
        }
        return URI.createPlatformPluginURI((String)(String.valueOf(contributorId) + "/" + value), (boolean)true);
    }

    public List<String> getServices() {
        ArrayList<String> bundleNames = new ArrayList<String>();
        for (Bundle bundle : this.bundles) {
            bundleNames.add(bundle.getName());
        }
        return bundleNames;
    }

    public List<String> getBundlesImportedByDefault() {
        ArrayList<String> bundleNames = new ArrayList<String>();
        for (Bundle bundle : this.bundles) {
            if (!bundle.isImportedByDefault()) continue;
            bundleNames.add(bundle.getName());
        }
        return bundleNames;
    }

    private List<Bundle> getDeclaredBundles() {
        IContextService context = (IContextService)GendocServices.getDefault().getService(IContextService.class);
        List declaredList = context.getImportedBundles();
        ArrayList<Bundle> result = new ArrayList<Bundle>(declaredList.size());
        for (Bundle b : this.bundles) {
            if (b.getName() == null || !declaredList.contains(b.getName())) continue;
            result.add(b);
        }
        return result;
    }

    public List<URI> getResources() {
        ArrayList<URI> result = new ArrayList<URI>();
        for (Bundle b : this.getDeclaredBundles()) {
            result.add(b.getUri());
        }
        return result;
    }

    public List<String> getDependentMetamodels() {
        HashSet<String> result = new HashSet<String>();
        for (Bundle b : this.getDeclaredBundles()) {
            for (String modelUri : b.getMetamodels()) {
                result.add(modelUri);
            }
        }
        return new ArrayList<String>(result);
    }

    public void clear() {
        this.bundles.clear();
    }

    public void resetResourceMap() {
        this.clear();
        this.readExtensionPoint();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Bundle {
        private String name = "";
        private URI uri = null;
        private List<String> metamodels;
        private boolean importedByDefault = false;

        private Bundle() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public URI getUri() {
            return this.uri;
        }

        public void setUri(URI uri) {
            this.uri = uri;
        }

        public List<String> getMetamodels() {
            if (this.metamodels == null) {
                this.metamodels = new LinkedList<String>();
                ResourceSetImpl set = new ResourceSetImpl();
                set.getPackageRegistry().put((Object)"http://www.eclipse.org/acceleo/mtl/3.0", (Object)MtlPackage.eINSTANCE);
                if (this.getUri() != null) {
                    Resource r = set.getResource(this.getUri(), true);
                    EcoreUtil.resolveAll((ResourceSet)set);
                    if (r != null && !r.getContents().isEmpty() && r.getContents().get(0) instanceof Module) {
                        Module m = (Module)r.getContents().get(0);
                        for (TypedModel t : m.getInput()) {
                            for (EPackage p : t.getTakesTypesFrom()) {
                                String uri = null;
                                uri = p.eIsProxy() ? ((InternalEObject)p).eProxyURI().trimFragment().toString() : p.getNsURI();
                                this.metamodels.add(uri);
                            }
                        }
                    }
                    for (Resource tmp : set.getResources()) {
                        try {
                            tmp.unload();
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    ((ILogger)GendocServices.getDefault().getService(ILogger.class)).log("uri not found for bundle " + this.getName(), 2);
                }
            }
            return this.metamodels;
        }

        public boolean isImportedByDefault() {
            return this.importedByDefault;
        }

        public void setImportedByDefault(boolean importedByDefault) {
            this.importedByDefault = importedByDefault;
        }
    }
}

