/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.bundle.acceleo.commons.files;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.gendoc.bundle.acceleo.commons.files.InputStream2FileRunnable;
import org.eclipse.gendoc.documents.IAdditionalResourceService;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.documents.ResourceRunnable;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.IGendocDiagnostician;
import org.eclipse.gendoc.services.IRegistryService;
import org.eclipse.gendoc.tags.ITagExtensionService;
import org.eclipse.gendoc.tags.handlers.IConfigurationService;
import org.eclipse.gendoc.tags.handlers.IEMFModelLoaderService;
import org.osgi.framework.Bundle;

public class CommonService {
    private static final Pattern newLinePattern = Pattern.compile("\\r\\n|\\n|\\r");
    static List<Pattern> patterns = CommonService.compileTagsPatterns();
    public static final String KEY_FOR_MAP_OF_EOBJECT = "Gendoc_map_of_eobjects";

    static List<Pattern> compileTagsPatterns() {
        ITagExtensionService tagExtensionService = (ITagExtensionService)GendocServices.getDefault().getService(ITagExtensionService.class);
        ArrayList<Pattern> listPattern = new ArrayList<Pattern>();
        for (String element : tagExtensionService.getAllTagNames()) {
            listPattern.add(Pattern.compile("(.*&lt;)(" + element + ")(.*&gt;.*)"));
            listPattern.add(Pattern.compile("(.*&lt;/)(" + element + ")(.*&gt;.*)"));
        }
        return listPattern;
    }

    public static String removeSpecialCharacters(String string) {
        if (string == null) {
            return null;
        }
        String result = string.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll("&amp;lt;", "&lt;").replaceAll(">", "&gt;").replaceAll("&amp;gt;", "&gt;").replaceAll("'", "&apos;").replaceAll("\"", "&quot;");
        if (!result.isEmpty()) {
            ITagExtensionService tagExtensionService = (ITagExtensionService)GendocServices.getDefault().getService(ITagExtensionService.class);
            for (String element : tagExtensionService.getAllTagNames()) {
                result = result.replaceAll("&lt;/" + element, "&lt;/ " + element).replaceAll("&lt;" + element, "&lt; " + element);
            }
        }
        return result;
    }

    public static List<String> splitNewLine(String string) {
        if (string == null) {
            return null;
        }
        return Arrays.asList(newLinePattern.split(string));
    }

    public static String gPut(Object key, Object value) {
        IRegistryService registry = (IRegistryService)GendocServices.getDefault().getService(IRegistryService.class);
        if (registry != null) {
            registry.put(key, value);
        }
        return "";
    }

    public static Object gGet(Object key) {
        IRegistryService registry = (IRegistryService)GendocServices.getDefault().getService(IRegistryService.class);
        if (registry != null) {
            IConfigurationService conf;
            String tmp;
            Object result = registry.get(key);
            if (result == null && key instanceof String && (tmp = (conf = (IConfigurationService)GendocServices.getDefault().getService(IConfigurationService.class)).getParameter((String)key)) instanceof String) {
                result = tmp;
            }
            return result;
        }
        return null;
    }

    public static String getText(EObject e) {
        if (e == null) {
            return "";
        }
        AdapterFactory factory = null;
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(e.eClass().getEPackage());
        list.add(IStructuredItemContentProvider.class);
        ComposedAdapterFactory.Descriptor desc = ComposedAdapterFactory.Descriptor.Registry.INSTANCE.getDescriptor(list);
        if (desc != null) {
            factory = desc.createAdapterFactory();
        }
        if (factory == null) {
            factory = new ReflectiveItemProviderAdapterFactory();
        }
        return new ReflectiveItemProvider(factory).getText((Object)e);
    }

    public static String getId(EObject e) {
        String id = null;
        Resource r = e.eResource();
        if (r instanceof XMIResource) {
            XMIResource xmi = (XMIResource)r;
            id = xmi.getID(e);
        }
        if (id == null) {
            IRegistryService service = (IRegistryService)GendocServices.getDefault().getService(IRegistryService.class);
            HashMap<EObject, String> map = (HashMap<EObject, String>)service.get((Object)KEY_FOR_MAP_OF_EOBJECT);
            if (map == null) {
                map = new HashMap<EObject, String>();
                service.put((Object)KEY_FOR_MAP_OF_EOBJECT, map);
            }
            if ((id = (String)map.get(e)) == null) {
                id = EcoreUtil.generateUUID();
                map.put(e, id);
            }
        }
        return id;
    }

    public static String load(EObject object, String extensionReplacement) {
        Resource r = object.eResource();
        URI uri = r.getURI().trimFileExtension().appendFileExtension(extensionReplacement);
        CommonService.loadModelFromURI(uri);
        return "";
    }

    public static String loadURI(String uriString) {
        URI uri = null;
        IGendocDiagnostician diagnostician = (IGendocDiagnostician)GendocServices.getDefault().getService(IGendocDiagnostician.class);
        try {
            uri = URI.createURI((String)uriString);
        }
        catch (IllegalArgumentException ex) {
            diagnostician.addDiagnostic(4, "Invalid URI format. Following resource cannot be loaded : '" + uriString + "'.\n" + ex.getMessage(), (Object)uri);
        }
        if (uri != null) {
            CommonService.loadModelFromURI(uri);
        }
        return "";
    }

    private static void loadModelFromURI(URI uri) {
        IGendocDiagnostician diagnostician = (IGendocDiagnostician)GendocServices.getDefault().getService(IGendocDiagnostician.class);
        IEMFModelLoaderService emfModelLoaderService = (IEMFModelLoaderService)GendocServices.getDefault().getService(IEMFModelLoaderService.class);
        try {
            emfModelLoaderService.getModel(uri);
        }
        catch (RuntimeException e1) {
            diagnostician.addDiagnostic(4, "Following resource could not be loaded : '" + uri.toFileString() + "'.\n" + e1.getMessage(), (Object)uri);
        }
        catch (Exception ex) {
            diagnostician.addDiagnostic(4, "Following resource could not be loaded : '" + uri.toFileString() + "'.\n" + ex.getMessage(), (Object)uri);
        }
    }

    public static String loadRelative(EObject object, String relativePath) {
        Resource r = object.eResource();
        IGendocDiagnostician diagnostician = (IGendocDiagnostician)GendocServices.getDefault().getService(IGendocDiagnostician.class);
        try {
            URI relativePathURI = URI.createURI((String)relativePath);
            URI relativeResourceURI = relativePathURI.resolve(r.getURI());
            CommonService.loadModelFromURI(relativeResourceURI);
        }
        catch (IllegalArgumentException e) {
            diagnostician.addDiagnostic(4, "Resource with relative path : '" + relativePath + "' cannot be loaded from resource '" + r.getURI().toFileString() + "'.\n" + e.getMessage(), (Object)object);
        }
        return "";
    }

    public static String getPluginImage(String pluginId, String path) {
        URL url;
        IGendocDiagnostician diag;
        block8: {
            if (pluginId == null || path == null) {
                return null;
            }
            if (path.contains("\\")) {
                path = path.replaceAll("\\", "/");
            }
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            diag = (IGendocDiagnostician)GendocServices.getDefault().getService(IGendocDiagnostician.class);
            Bundle b = Platform.getBundle((String)pluginId);
            if (b == null) {
                diag.addDiagnostic(4, String.format("bundle %s not found", pluginId), null);
                return null;
            }
            url = b.getEntry(path);
            if (url != null) break block8;
            diag.addDiagnostic(4, String.format("path %s for bundle %s not found", path, pluginId), null);
            return null;
        }
        try {
            IDocumentService docService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
            IAdditionalResourceService resourceService = docService.getAdditionalResourceService();
            String extension = path.substring(path.lastIndexOf(".") + 1, path.length());
            return resourceService.addNewImageRunnable((ResourceRunnable)new InputStream2FileRunnable(extension, new BufferedInputStream(url.openStream())));
        }
        catch (IllegalStateException illegalStateException) {
            diag.addDiagnostic(4, String.format("path %s for bundle %s not found", path, pluginId), null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String cleanAndFormat(String input) {
        LinkedHashMap<String, String> SPECIAL_CHARACTERS = new LinkedHashMap<String, String>();
        SPECIAL_CHARACTERS.put("<", "&lt;");
        SPECIAL_CHARACTERS.put(">", "&gt;");
        SPECIAL_CHARACTERS.put("'", "&apos;");
        SPECIAL_CHARACTERS.put("\"", "&quot;");
        IDocumentService documentService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
        Pattern p = Pattern.compile("&[^;]*;");
        Matcher m = p.matcher(input);
        int index = 0;
        String cleanedInput = "";
        int start = 0;
        int end = 0;
        boolean no_tag_found = true;
        while (m.find()) {
            no_tag_found = false;
            start = m.start();
            end = m.end();
            cleanedInput = String.valueOf(cleanedInput) + input.substring(index, start);
            String substring = input.substring(start, end);
            cleanedInput = substring.matches("(&gt;)|(&lt;)|(&quot;)|(&amp;)|(&apos;)|(&#[^;]*;)") ? String.valueOf(cleanedInput) + substring : String.valueOf(cleanedInput) + substring.replace("&", "&amp;");
            index = end;
        }
        if (no_tag_found) {
            SPECIAL_CHARACTERS.put("&", "&amp;");
        }
        cleanedInput = String.valueOf(cleanedInput) + input.substring(index);
        for (String key : SPECIAL_CHARACTERS.keySet()) {
            cleanedInput = cleanedInput.replace(key, (CharSequence)SPECIAL_CHARACTERS.get(key));
        }
        String result = documentService.format(cleanedInput);
        return result;
    }
}

