/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.script.acceleo.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gendoc.script.acceleo.Generator;
import org.eclipse.gendoc.script.acceleo.IFileAndMMRegistry;
import org.eclipse.gendoc.script.acceleo.ServicesExtension;
import org.eclipse.gendoc.script.services.IModuleManagerService;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.exception.GenDocException;
import org.eclipse.gendoc.tags.handlers.IContextService;

public class ScriptGenerator {
    private final List<Pattern> patterns;

    public ScriptGenerator(List<Pattern> patterns) {
        this.patterns = patterns;
    }

    public String formatScript(EObject element, String script) throws GenDocException {
        IContextService contextService = (IContextService)GendocServices.getDefault().getService(IContextService.class);
        StringBuilder resultScript = new StringBuilder();
        this.insertModule(element, contextService, resultScript);
        Pattern pattern = this.getQueryPattern();
        List<String> queries = this.extractQueries(script, pattern);
        String scriptWithoutQueries = this.cleanFromQueries(script, pattern);
        this.addImports(element, resultScript);
        for (String query : queries) {
            resultScript.append(String.valueOf(query) + "\n");
        }
        this.addTemplate(element, resultScript, scriptWithoutQueries);
        return resultScript.toString();
    }

    protected void addTemplate(EObject element, StringBuilder resultScript, String scriptWithoutQueries) {
        resultScript.append("[template ").append(this.getTemplateVisibility()).append(" ").append(this.getTemplateName()).append(" (").append(this.getTemplateArguments(element)).append(")]\n");
        if (this.generatesFile()) {
            resultScript.append("[file ('tempFile',false )]\n");
        }
        resultScript.append(String.valueOf(this.cleanInternalScriptContent(scriptWithoutQueries)) + "\n");
        if (this.generatesFile()) {
            resultScript.append("[/file] \n");
        }
        resultScript.append("[/template]\n");
    }

    protected boolean generatesFile() {
        return true;
    }

    protected String getTemplateArguments(EObject element) {
        return "internalVar : " + element.eClass().getName();
    }

    protected String getTemplateName() {
        return Generator.templateNames;
    }

    protected String getTemplateVisibility() {
        return "public";
    }

    protected void addImports(EObject element, StringBuilder resultScript) throws GenDocException {
        IModuleManagerService moduleManager;
        List<String> modules;
        for (String bundle : this.getImportedBundlesForScript()) {
            this.addImport(element, resultScript, bundle);
        }
        if (this.addModuleImport() && (modules = (moduleManager = (IModuleManagerService)GendocServices.getDefault().getService(IModuleManagerService.class)).getImportedModules(element)) != null) {
            for (String s : modules) {
                this.addImport(element, resultScript, s);
            }
        }
    }

    protected boolean addModuleImport() {
        return true;
    }

    private String cleanInternalScriptContent(String script) {
        StringBuffer scriptContent = new StringBuffer();
        Pattern pattern = this.patterns.get(0);
        Matcher matcher = pattern.matcher(script);
        int index = 0;
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            scriptContent.append(script.substring(index, start));
            String content = script.substring(start, end);
            if (content.contains("&lt;") || content.contains("&gt;")) {
                content = content.replaceAll("&lt;", "<");
                content = content.replaceAll("&gt;", ">");
            }
            scriptContent.append(content);
            index = end;
        }
        scriptContent.append(script.substring(index));
        return scriptContent.toString();
    }

    private String cleanFromQueries(String script, Pattern pattern) {
        Matcher matcher = pattern.matcher(script);
        return matcher.replaceAll("");
    }

    private Pattern getQueryPattern() {
        String regex = String.valueOf(Pattern.quote("[")) + "query[^]]*" + Pattern.quote("/]");
        return Pattern.compile(regex);
    }

    protected void appendModuleName(StringBuilder resultScript) {
        resultScript.append(Generator.templateNames);
    }

    protected void addImport(EObject element, StringBuilder resultScript, String bundle) {
        resultScript.append("[import ").append(this.getBundleNameForImport(element, bundle)).append(" /]\n");
    }

    protected String getBundleNameForImport(EObject eobject, String bundleName) {
        return bundleName;
    }

    private List<String> extractQueries(String script, Pattern pattern) {
        ArrayList<String> queries = new ArrayList<String>();
        Matcher matcher = pattern.matcher(script);
        while (!matcher.hitEnd()) {
            if (!matcher.find()) continue;
            String next = matcher.group();
            queries.add(next);
        }
        return queries;
    }

    protected List<String> getImportedBundlesForScript() {
        IContextService context = (IContextService)GendocServices.getDefault().getService(IContextService.class);
        List importedBundles = context.getImportedBundles();
        for (String bundleName : ServicesExtension.getInstance().getBundlesImportedByDefault()) {
            if (importedBundles.contains(bundleName)) continue;
            importedBundles.add(bundleName);
        }
        return importedBundles;
    }

    protected void insertModule(EObject element, IContextService contextService, StringBuilder resultScript) {
        List<String> metaModels = ServicesExtension.getInstance().getDependentMetamodels();
        resultScript.append("[module ");
        this.appendModuleName(resultScript);
        resultScript.append(" ('");
        this.addMetaModelsToModule(element, contextService, resultScript, metaModels);
        resultScript.append("')/]\n");
    }

    protected void addMetaModelsToModule(EObject element, IContextService contextService, StringBuilder resultScript, List<String> metaModels) {
        if (contextService.isSearchMetamodels()) {
            IFileAndMMRegistry registry = (IFileAndMMRegistry)GendocServices.getDefault().getService(IFileAndMMRegistry.class);
            Collection<String> metamodelsFromElement = registry.getMetamodels(element);
            for (String metaModel : metamodelsFromElement) {
                if (metaModels.contains(metaModel)) continue;
                metaModels.add(metaModel);
            }
        } else {
            metaModels.add(element.eClass().getEPackage().getNsURI());
        }
        if (metaModels.isEmpty()) {
            resultScript.append(String.valueOf(element.eClass().getEPackage().getNsURI()) + "')/]\n");
        } else {
            Iterator<String> metaModelsIt = metaModels.iterator();
            resultScript.append(metaModelsIt.next());
            while (metaModelsIt.hasNext()) {
                resultScript.append("', '" + metaModelsIt.next());
            }
        }
    }
}

