/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.document.parser.xlsx.cellmarkers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.gendoc.document.parser.documents.XMLParser;
import org.eclipse.gendoc.document.parser.xlsx.CellRef;
import org.eclipse.gendoc.document.parser.xlsx.XLSXParser;
import org.eclipse.gendoc.document.parser.xlsx.cellmarkers.AbstractCellRefMarker;
import org.eclipse.gendoc.document.parser.xlsx.cellmarkers.CellMark;
import org.eclipse.gendoc.document.parser.xlsx.cellmarkers.ICellRefMarker;
import org.eclipse.gendoc.document.parser.xlsx.helper.XPathXlsxUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BreakRefMarker
extends AbstractCellRefMarker
implements ICellRefMarker {
    protected final boolean isRowBreak;

    public BreakRefMarker(String mark, String xpath, boolean isRowBreak) {
        super(mark, xpath);
        this.isRowBreak = isRowBreak;
    }

    public BreakRefMarker(String mark, String relationType, String xpath, boolean isRowBreak) {
        super(mark, relationType, xpath);
        this.isRowBreak = isRowBreak;
    }

    @Override
    public List<CellMark> getMarksToApply(XLSXParser xlsxParser) {
        Document doc = xlsxParser.getDocument();
        if (this.relationType != null) {
            try {
                XMLParser parser = xlsxParser.loadImplicitPartDocument(this.relationType);
                if (parser == null) {
                    return Collections.EMPTY_LIST;
                }
                doc = parser.getDocument();
            }
            catch (IOException iOException) {
                return Collections.EMPTY_LIST;
            }
        }
        ArrayList<CellMark> marks = new ArrayList<CellMark>();
        try {
            NodeList nl = XPathXlsxUtils.evaluateNodes(doc, this.xpath);
            int i = 0;
            while (i < nl.getLength()) {
                Element el = (Element)nl.item(0);
                int id = Integer.valueOf(el.getAttribute("id"));
                int min = 1;
                if (el.hasAttribute("min")) {
                    min = Integer.valueOf(el.getAttribute("min"));
                }
                CellRef ref = this.isRowBreak ? new CellRef(id - 1, min - 1) : new CellRef(min - 1, id - 1);
                String elXPath = XPathXlsxUtils.getNodeXPath(el);
                marks.add(this.createMark(xlsxParser, ref, this.relationType, elXPath, 0));
                ++i;
            }
            return marks;
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void layoutCellReference(XLSXParser xlsxParser, CellRef source, List<CellMark> targets) {
        if (targets == null || targets.isEmpty()) {
            return;
        }
        Document doc = xlsxParser.getDocument();
        if (this.relationType != null) {
            try {
                XMLParser parser = xlsxParser.loadImplicitPartDocument(this.relationType);
                if (parser == null) {
                    return;
                }
                doc = parser.getDocument();
            }
            catch (IOException iOException) {
                return;
            }
        }
        CellMark first = targets.get(0);
        Element breakEl = null;
        try {
            breakEl = (Element)XPathXlsxUtils.evaluateNode(doc, first.path);
        }
        catch (XPathExpressionException e) {
            new IllegalArgumentException(e.getMessage(), e);
        }
        Element breaksEl = (Element)breakEl.getParentNode();
        int origMin = this.getAttributeValue(breakEl, "min", Integer.MIN_VALUE);
        int origMax = this.getAttributeValue(breakEl, "max", Integer.MIN_VALUE);
        boolean isMan = this.getAttributeValue(breakEl, "man", 0) == 1;
        int manCount = this.getAttributeValue(breaksEl, "manualBreakCount", 0);
        int count = this.getAttributeValue(breaksEl, "count", 0);
        for (CellMark target : targets) {
            Element el = breakEl;
            if (first != target) {
                el = (Element)breakEl.cloneNode(true);
                breaksEl.appendChild(el);
                if (isMan) {
                    ++manCount;
                }
                ++count;
            }
            el.setAttribute("id", String.valueOf(this.isRowBreak ? target.cell.getRow() + 1 : target.cell.getCol() + 1));
            if (origMin != Integer.MIN_VALUE) {
                el.setAttribute("min", String.valueOf(this.isRowBreak ? target.cell.getCol() + 1 : target.cell.getRow() + 1));
            }
            if (origMax == Integer.MIN_VALUE) continue;
            int reflow = this.isRowBreak ? target.cell.getCol() + 1 : target.cell.getRow() + 1;
            el.setAttribute("max", String.valueOf(origMax + (reflow -= this.isRowBreak ? source.getCol() + 1 : source.getRow() + 1)));
        }
        if (count > 0) {
            breaksEl.setAttribute("count", String.valueOf(count));
        }
        if (manCount > 0) {
            breaksEl.setAttribute("manualBreakCount", String.valueOf(manCount));
        }
    }

    private int getAttributeValue(Element el, String attr, int def) {
        return el.hasAttribute(attr) ? Integer.valueOf(el.getAttribute(attr)) : def;
    }
}

