/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.wizard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.gendoc.wizard.Activator;
import org.eclipse.gendoc.wizard.IGendocRunner;
import org.eclipse.gendoc.wizard.IGendocRunnerProvider;
import org.eclipse.gendoc.wizard.IGendocSelectionConverterRunner;

public class Utils {
    private static List<IGendocRunner> runners = null;
    private static List<IGendocRunnerProvider> providers = null;

    public static IFile[] getIFiles(Object o) {
        Collection collec;
        if (o instanceof IFile) {
            return new IFile[]{(IFile)o};
        }
        LinkedList<IFile> files = new LinkedList<IFile>();
        IFile f = (IFile)Platform.getAdapterManager().getAdapter(o, IFile.class);
        if (f != null) {
            files.add(f);
        }
        if ((collec = (Collection)Platform.getAdapterManager().getAdapter(o, Collection.class)) != null) {
            boolean ok = true;
            for (Object o2 : collec) {
                if (o2 instanceof IFile) continue;
                ok = false;
                break;
            }
            if (ok) {
                files.addAll(collec);
            }
        }
        return files.toArray(new IFile[0]);
    }

    public static List<IGendocRunner> getAllRunners() {
        if (runners == null) {
            IConfigurationElement[] elements;
            runners = new LinkedList<IGendocRunner>();
            providers = new LinkedList<IGendocRunnerProvider>();
            IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.gendoc.wizard", "runner");
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                if (e.getName().equals("GendocElement")) {
                    try {
                        IGendocRunner runner = (IGendocRunner)e.createExecutableExtension("Instance");
                        runners.add(runner);
                    }
                    catch (CoreException e1) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.gendoc.wizard", "Error instanciating IGendocRunner.", (Throwable)e1));
                    }
                } else if (e.getName().equals("GendocElementProvider")) {
                    try {
                        IGendocRunnerProvider provider = (IGendocRunnerProvider)e.createExecutableExtension("Instance");
                        providers.add(provider);
                    }
                    catch (CoreException e1) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.gendoc.wizard", "Error instanciating IGendocRunnerProvider.", (Throwable)e1));
                    }
                }
                ++n2;
            }
        }
        LinkedList<IGendocRunner> allRunners = new LinkedList<IGendocRunner>();
        for (IGendocRunnerProvider p : providers) {
            try {
                allRunners.addAll(Arrays.asList(p.getGendocRunners()));
            }
            catch (Exception e1) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.gendoc.wizard", "Error instanciating GendocRunners from provider.", (Throwable)e1));
            }
        }
        allRunners.addAll(runners);
        return allRunners;
    }

    public static List<Pattern> getAllExtensions() {
        List<IGendocRunner> runners = Utils.getAllRunners();
        LinkedList<Pattern> result = new LinkedList<Pattern>();
        for (IGendocRunner r : runners) {
            if (r.getPattern() == null) continue;
            result.add(r.getPattern());
        }
        return result;
    }

    public static boolean matches(IFile[] files) {
        List<Pattern> patterns = Utils.getAllExtensions();
        for (Pattern p : patterns) {
            if (p == null) continue;
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile f = iFileArray[n2];
                if (p.matcher(f.getName()).matches()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean matches(Object selectedObject) {
        return !Utils.getRunners(selectedObject).isEmpty();
    }

    public static List<IGendocRunner> getRunners(IFile[] files) {
        List<IGendocRunner> runners = Utils.getAllRunners();
        ArrayList<IGendocRunner> result = new ArrayList<IGendocRunner>(runners.size());
        for (IGendocRunner g : runners) {
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile f = iFileArray[n2];
                if (g.getPattern().matcher(f.getName()).matches()) {
                    result.add(g);
                }
                ++n2;
            }
        }
        return result;
    }

    public static List<IGendocRunner> getRunners(Object selectedObject) {
        ArrayList<IGendocRunner> runners = new ArrayList<IGendocRunner>();
        for (IGendocRunner runner : Utils.getAllRunners()) {
            if (runner instanceof IGendocSelectionConverterRunner) {
                IFile selectedFile;
                if (!((IGendocSelectionConverterRunner)runner).getSelectionConverter().matches(selectedObject) || (selectedFile = ((IGendocSelectionConverterRunner)runner).getSelectionConverter().getFile(selectedObject)) == null || !runner.getPattern().matcher(selectedFile.getName()).matches()) continue;
                runners.add(runner);
                continue;
            }
            LinkedList<IFile> files = new LinkedList<IFile>();
            if (selectedObject instanceof IFile[]) {
                files.addAll(Arrays.asList((IFile[])selectedObject));
            } else if (selectedObject instanceof IFile) {
                files.add((IFile)selectedObject);
            }
            for (IFile f : files) {
                if (!runner.getPattern().matcher(f.getName()).matches()) continue;
                runners.add(runner);
            }
        }
        return runners;
    }
}

