/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.document.parser.documents.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.document.parser.documents.XMLParser;

public class CSVDocument
implements Document {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String TEXT_QUALIFIER = "\"";
    private static final String DELIMITER = ";";
    private URL currentDocument;
    private BufferedReader reader;
    private int currentColumn = -1;
    private String[] currentRow = null;
    private boolean next = true;
    private XMLParser.NullXMLParser xmlParser;
    private InputStream openStream;

    @Override
    public URL getDocumentURL() {
        return this.currentDocument;
    }

    @Override
    public String getPath() {
        return this.currentDocument.getPath();
    }

    public CSVDocument(URL documentFile) {
        this.currentDocument = documentFile;
        this.xmlParser = new XMLParser.NullXMLParser(null);
        try {
            this.openStream = this.currentDocument.openStream();
            this.reader = new BufferedReader(new InputStreamReader(this.openStream));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readLine() {
        try {
            String line = this.reader.readLine();
            boolean bl = this.next = line != null;
            if (this.next) {
                if (!line.contains(TEXT_QUALIFIER)) {
                    this.currentRow = line.split(DELIMITER);
                } else {
                    boolean isFirstLine = true;
                    ArrayList<StringBuffer> completeRow = new ArrayList<StringBuffer>();
                    boolean inQualifiedText = false;
                    do {
                        if (!isFirstLine) {
                            ((StringBuffer)completeRow.get(completeRow.size() - 1)).append(LINE_SEPARATOR);
                            line = this.reader.readLine();
                            if (line == null) break;
                            if (!line.contains(TEXT_QUALIFIER)) {
                                ((StringBuffer)completeRow.get(completeRow.size() - 1)).append(line);
                                continue;
                            }
                        }
                        String[] lineElements = line.split(TEXT_QUALIFIER);
                        int indexOfLineElement = 0;
                        while (indexOfLineElement < lineElements.length) {
                            String lineElement = lineElements[indexOfLineElement];
                            if ("".equals(lineElement)) {
                                if (indexOfLineElement == 0) {
                                    completeRow.add(new StringBuffer());
                                } else if (indexOfLineElement < lineElements.length - 1) {
                                    ((StringBuffer)completeRow.get(completeRow.size() - 1)).append(TEXT_QUALIFIER);
                                }
                            } else if (!inQualifiedText) {
                                boolean firstValue = true;
                                String[] stringArray = lineElement.split(DELIMITER);
                                int n = stringArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String cellValue = stringArray[n2];
                                    if (firstValue && !lineElement.startsWith(DELIMITER) && completeRow.size() > 0) {
                                        ((StringBuffer)completeRow.get(completeRow.size() - 1)).append(cellValue);
                                    } else if (!(firstValue && lineElement.startsWith(DELIMITER) && "".equals(cellValue))) {
                                        completeRow.add(new StringBuffer(cellValue));
                                    }
                                    firstValue = false;
                                    ++n2;
                                }
                                if (lineElement.endsWith(DELIMITER)) {
                                    completeRow.add(new StringBuffer());
                                }
                            } else if (completeRow.size() > 0) {
                                ((StringBuffer)completeRow.get(completeRow.size() - 1)).append(lineElement);
                            } else {
                                completeRow.add(new StringBuffer(lineElement));
                            }
                            if (indexOfLineElement < lineElements.length - 1 || line.endsWith(TEXT_QUALIFIER)) {
                                inQualifiedText = !inQualifiedText;
                            }
                            ++indexOfLineElement;
                        }
                        isFirstLine = false;
                    } while (inQualifiedText);
                    this.currentRow = new String[completeRow.size()];
                    int i = 0;
                    for (StringBuffer value : completeRow) {
                        this.currentRow[i] = value.toString();
                        ++i;
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getColumnNumber() {
        return this.currentColumn;
    }

    @Override
    public File getDocumentFile() {
        return new File(this.currentDocument.getFile());
    }

    public String getStyle() {
        return "";
    }

    public String getText() {
        if (this.currentRow != null && this.currentRow.length > this.currentColumn) {
            return this.currentRow[this.currentColumn];
        }
        return "";
    }

    @Override
    public String getTextCorrespondingToCurrentStyle() {
        return this.getText();
    }

    @Override
    public XMLParser getXMLParser() {
        return this.xmlParser;
    }

    @Override
    public boolean jumpToNextFile() {
        return false;
    }

    @Override
    public void jumpToStart() {
    }

    @Override
    public boolean next() {
        this.currentColumn = this.currentColumn == -1 ? 0 : (this.currentColumn + 1) % this.currentRow.length;
        if (this.currentColumn == 0) {
            this.readLine();
        }
        if (!this.next) {
            try {
                this.reader.close();
                this.openStream.close();
            }
            catch (IOException iOException) {}
        }
        return this.next;
    }

    @Override
    public Object get(Document.PROPERTY property) {
        switch (property) {
            case column: {
                return this.getColumnNumber();
            }
            case row: {
                return this.getRowNumber();
            }
            case text: {
                return this.getText();
            }
        }
        return null;
    }

    private int getRowNumber() {
        return 0;
    }
}

