/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.script.acceleo.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gendoc.m2t.model.Argument;
import org.eclipse.gendoc.m2t.model.Fragment;
import org.eclipse.gendoc.script.acceleo.ServicesExtension;
import org.eclipse.gendoc.script.acceleo.impl.ScriptGenerator;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.exception.GenDocException;
import org.eclipse.gendoc.tags.handlers.IContextService;

public class FragmentScriptGenerator
extends ScriptGenerator {
    private final List<Fragment> fragments;
    private Fragment currentFragment;

    public FragmentScriptGenerator(List<Pattern> patterns, List<Fragment> fragments) {
        super(patterns);
        this.fragments = fragments;
    }

    @Override
    public String formatScript(EObject element, String s) throws GenDocException {
        IContextService contextService = (IContextService)GendocServices.getDefault().getService(IContextService.class);
        StringBuilder resultScript = new StringBuilder();
        this.insertModule(element, contextService, resultScript);
        this.addImports(element, resultScript);
        StringBuilder queryScripts = new StringBuilder();
        StringBuilder templateScripts = new StringBuilder();
        Iterator<Fragment> iterator = this.fragments.iterator();
        while (iterator.hasNext()) {
            Fragment f;
            this.currentFragment = f = iterator.next();
            Pattern pattern = this.getQueryPattern();
            String script = f.getScriptValue();
            List<String> queries = this.extractQueries(script, pattern);
            String scriptWithoutQueries = this.cleanFromQueries(script, pattern);
            for (String query : queries) {
                queryScripts.append(String.valueOf(query) + "\n");
            }
            this.addTemplate(element, templateScripts, scriptWithoutQueries);
        }
        resultScript.append((CharSequence)queryScripts);
        resultScript.append((CharSequence)templateScripts);
        return resultScript.toString();
    }

    @Override
    protected void addImports(EObject element, StringBuilder resultScript) throws GenDocException {
        HashSet<String> bundles = new HashSet<String>();
        bundles.addAll(ServicesExtension.getInstance().getBundlesImportedByDefault());
        for (Fragment f : this.fragments) {
            bundles.addAll(f.getImportedBundles());
        }
        for (String bundle : bundles) {
            super.addImport(element, resultScript, bundle);
        }
    }

    @Override
    protected boolean addModuleImport() {
        return true;
    }

    @Override
    protected void appendModuleName(StringBuilder resultScript) {
        resultScript.append("fragents");
    }

    @Override
    protected String getTemplateName() {
        return this.currentFragment.getName();
    }

    @Override
    protected boolean generatesFile() {
        return false;
    }

    @Override
    protected String getTemplateArguments(EObject element) {
        StringBuffer result = new StringBuffer();
        boolean flag = false;
        for (Argument a : this.currentFragment.getArguments()) {
            if (flag) {
                result.append(", ");
            }
            result.append(a.getName()).append(" : ").append(a.getType());
            flag = true;
        }
        return result.toString();
    }

    @Override
    protected String getTemplateVisibility() {
        return "public";
    }
}

