/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.document.parser.documents.openoffice;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.gendoc.document.parser.documents.openoffice.OpenOfficeNamespaceContext;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OpenOfficeXPathUtils {
    private OpenOfficeNamespaceContext namespaceContext;
    private DocumentBuilderFactory domBuilderFactory;
    private XPath xpath;

    protected OpenOfficeXPathUtils(OpenOfficeNamespaceContext context) {
        this.namespaceContext = context;
        this.xpath = XPathFactory.newInstance().newXPath();
        this.xpath.setNamespaceContext(context);
        this.domBuilderFactory = DocumentBuilderFactory.newInstance();
        this.domBuilderFactory.setNamespaceAware(true);
    }

    public OpenOfficeNamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    public XPathExpression compile(String expr) throws XPathExpressionException {
        return this.xpath.compile(expr);
    }

    public Node evaluateNode(Node contextNode, String expr) throws XPathExpressionException {
        return (Node)this.xpath.evaluate(expr, contextNode, XPathConstants.NODE);
    }

    public NodeList evaluateNodes(Node contextNode, String expr) throws XPathExpressionException {
        return (NodeList)this.xpath.evaluate(expr, contextNode, XPathConstants.NODESET);
    }

    public String evaluateText(Node contextNode, String expr) throws XPathExpressionException {
        return (String)this.xpath.evaluate(expr, contextNode, XPathConstants.STRING);
    }

    public List<String> evaluateValues(Node contextNode, String expr) throws XPathExpressionException {
        NodeList nl = this.evaluateNodes(contextNode, expr);
        ArrayList<String> values = new ArrayList<String>();
        int i = 0;
        while (i < nl.getLength()) {
            values.add(nl.item(i).getTextContent());
            ++i;
        }
        return values;
    }

    public List<Integer> evaluateInts(Node contextNode, String expr) throws XPathExpressionException {
        NodeList nl = this.evaluateNodes(contextNode, expr);
        ArrayList<Integer> values = new ArrayList<Integer>();
        int i = 0;
        while (i < nl.getLength()) {
            String str = nl.item(i).getTextContent();
            try {
                values.add(Integer.valueOf(str));
            }
            catch (NumberFormatException numberFormatException) {}
            ++i;
        }
        return values;
    }

    public int evaluateMax(Node contextNode, String expr) throws XPathExpressionException {
        NodeList nl = this.evaluateNodes(contextNode, expr);
        int max = Integer.MIN_VALUE;
        int i = 0;
        while (i < nl.getLength()) {
            String str = nl.item(i).getTextContent();
            try {
                max = Math.max(max, Integer.valueOf(str));
            }
            catch (NumberFormatException numberFormatException) {}
            ++i;
        }
        return max;
    }

    public int evaluateNumber(Node contextNode, String expr, int defval) throws XPathExpressionException {
        Number number = (Number)this.xpath.evaluate(expr, contextNode, XPathConstants.NUMBER);
        return number == null ? defval : number.intValue();
    }

    public long evaluateNumber(Node contextNode, String expr, long defval) throws XPathExpressionException {
        Number number = (Number)this.xpath.evaluate(expr, contextNode, XPathConstants.NUMBER);
        return number == null ? defval : number.longValue();
    }

    public float evaluateNumber(Node contextNode, String expr, float defval) throws XPathExpressionException {
        Number number = (Number)this.xpath.evaluate(expr, contextNode, XPathConstants.NUMBER);
        return number == null ? defval : number.floatValue();
    }

    public double evaluateNumber(Node contextNode, String expr, double defval) throws XPathExpressionException {
        Number number = (Number)this.xpath.evaluate(expr, contextNode, XPathConstants.NUMBER);
        return number == null ? defval : number.doubleValue();
    }

    public Element evaluateFirstOf(Node contextNode, String expr, String ... childs) throws XPathExpressionException {
        Element el;
        Element element = el = expr == null || expr.equals(".") ? (Element)contextNode : (Element)this.evaluateNode(contextNode, expr);
        if (el == null) {
            return null;
        }
        HashSet<String> s = new HashSet<String>(Arrays.asList(childs));
        NodeList nl = el.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n instanceof Element && s.contains(n.getNodeName())) {
                return (Element)n;
            }
            ++i;
        }
        return null;
    }

    public Node parserXmlFragment(String xmlFragment) throws ParserConfigurationException, SAXException, IOException {
        boolean createFragment = false;
        DocumentBuilder builder = this.domBuilderFactory.newDocumentBuilder();
        if (!xmlFragment.startsWith("<?xml ")) {
            xmlFragment = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><documentFragment " + this.namespaceContext.getPrefixMapping() + ">" + xmlFragment + "</documentFragment>";
            createFragment = true;
        }
        Document document = builder.parse(new ByteArrayInputStream(xmlFragment.getBytes("UTF-8")));
        Element rootElement = document.getDocumentElement();
        if (!createFragment) {
            return rootElement;
        }
        NodeList children = rootElement.getChildNodes();
        if (children.getLength() == 1) {
            return children.item(0);
        }
        DocumentFragment frag = document.createDocumentFragment();
        int i = 0;
        while (i < children.getLength()) {
            frag.appendChild(children.item(i));
            ++i;
        }
        return frag;
    }

    public String getNodeXPath(Element el) {
        StringBuffer buf = new StringBuffer();
        Node parent = el.getParentNode();
        while (parent != null && parent instanceof Element) {
            NodeList nl = parent.getChildNodes();
            int index = 0;
            int i = 0;
            while (i < nl.getLength()) {
                Node n = nl.item(i);
                if (el.getNodeName().equals(n.getNodeName())) {
                    ++index;
                }
                if (n == el) break;
                ++i;
            }
            String prefix = this.namespaceContext.getPrefix(el.getNamespaceURI());
            buf.insert(0, String.format("/%s:%s[%d]", prefix, el.getLocalName(), index));
            el = (Element)parent;
            parent = el.getParentNode();
        }
        buf.insert(0, "/" + this.namespaceContext.getPrefix(el.getNamespaceURI()) + ":" + el.getLocalName());
        return buf.toString();
    }
}

