/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.document.parser.xlsx;

public class CellRef
implements Comparable<CellRef> {
    private static final int COLUMN_BASE = 26;
    private String ref;
    private int row;
    private int col;

    public CellRef(String ref) {
        this.ref = ref;
        this.updateIndex();
    }

    public CellRef(int row, int col) {
        this.row = row;
        this.col = col;
        this.updateRef();
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
        this.updateIndex();
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
        this.updateRef();
    }

    public int getCol() {
        return this.col;
    }

    public void setCol(int col) {
        this.col = col;
        this.updateRef();
    }

    private void updateRef() {
        int c = this.col;
        int r = this.row;
        if (r < 0 || c < 0) {
            throw new IllegalArgumentException("Invalid Cell index: (" + r + "," + c + ")");
        }
        StringBuffer buf = new StringBuffer();
        do {
            int rest = c % 26;
            buf.append((char)(65 + rest));
        } while ((c /= 26) != 0);
        buf.reverse().append(String.valueOf(r + 1));
        this.ref = buf.toString();
    }

    private void updateIndex() {
        int c = 0;
        int r = -1;
        int i = 0;
        while (i < this.ref.length()) {
            char ch = this.ref.charAt(i);
            if (ch >= 'A' && ch <= 'Z') {
                if (i != 0) {
                    c = (c + 1) * 26;
                }
                c += ch - 65;
            } else if (i > 0 && ch >= '0' && ch <= '9') {
                r = Integer.valueOf(this.ref.substring(i)) - 1;
                break;
            }
            ++i;
        }
        if (r < 0) {
            throw new IllegalArgumentException("Invalid cell reference: " + this.ref);
        }
        this.col = c;
        this.row = r;
    }

    @Override
    public int compareTo(CellRef other) {
        int res = this.row - other.row;
        return res == 0 ? this.col - other.col : res;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.col;
        result = 31 * result + this.row;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CellRef other = (CellRef)obj;
        if (this.col != other.col) {
            return false;
        }
        return this.row == other.row;
    }

    public String toString() {
        return this.ref;
    }
}

