/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterMessageInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import com.sun.messaging.jmq.util.UID;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class MessageDataHandler
extends GPacketHandler {
    private static boolean DEBUG = false;

    public MessageDataHandler(RaptorProtocol p) {
        super(p);
    }

    @Override
    public void handle(MessageBusCallback cb, BrokerAddress sender, GPacket gp) {
        if (DEBUG) {
            this.logger.log(4, "MessageDataHandler");
        }
        if (gp.getType() == 1) {
            this.handleMessageData(cb, sender, gp);
        } else if (gp.getType() == 2) {
            this.handleMessageDataReply(sender, gp);
        } else {
            this.logger.log(16, "MessageDataHandler Internal error : Cannot handle this packet :" + gp.toLongString());
        }
    }

    public void handleMessageData(MessageBusCallback cb, BrokerAddress sender, GPacket pkt) {
        ClusterMessageInfo cmi = ClusterMessageInfo.newInstance(pkt, this.c);
        boolean sendMsgDeliveredAck = cmi.getSendMessageDeliveredAck();
        LinkedHashMap<ConsumerUID, Integer> cuids = new LinkedHashMap<ConsumerUID, Integer>();
        if (DEBUG) {
            this.logger.log(2, "MessageBus: receiving message.");
        }
        try {
            cmi.initPayloadRead();
            Iterator itr = cmi.readPayloadConsumerUIDs();
            while (itr.hasNext()) {
                ConsumerUID intid = (ConsumerUID)itr.next();
                cuids.put(intid, cmi.getDeliveryCount(intid));
            }
            Packet roPkt = cmi.readPayloadMessage();
            BrokerAddress home = cmi.getHomeBrokerAddress();
            if (home == null) {
                home = sender;
            }
            Long partitionid = cmi.getPartitionID();
            if (home != null && partitionid != null) {
                home.setStoreSessionUID(new UID(partitionid.longValue()));
            }
            cb.processRemoteMessage(roPkt, cuids, home, sendMsgDeliveredAck);
        }
        catch (Exception e) {
            this.logger.logStack(32, "Internal Exception, unable to process message " + pkt, (Throwable)e);
        }
        if (cmi.needReply()) {
            try {
                this.c.unicast(sender, cmi.getReplyGPacket(200));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void handleMessageDataReply(BrokerAddress sender, GPacket gp) {
        this.logger.log(4, "MessageBus: Received reset G_MESSAGE_DATA_REPLY from {0} : STATUS = {1}", (Object)sender, gp.getProp((Object)"S"));
    }
}

