/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.ejbc;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.jdo.api.persistence.enhancer.generator.Main;
import com.sun.jdo.api.persistence.enhancer.meta.ExtendedJDOMetaData;
import com.sun.jdo.api.persistence.mapping.ejb.ConversionException;
import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.spi.persistence.generator.database.DDLGenerator;
import com.sun.jdo.spi.persistence.generator.database.DatabaseOutputStream;
import com.sun.jdo.spi.persistence.support.ejb.codegen.CMPGenerator;
import com.sun.jdo.spi.persistence.support.ejb.codegen.GeneratorException;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.JDOCodeGeneratorHelper;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.JDOConcreteBean11Generator;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.JDOConcreteBean20Generator;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.JDOConcreteBeanGenerator;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.LogHelperEJBCompiler;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.MappingGenerator;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.MethodHelper;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.NameMapper;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.EJBQLException;
import com.sun.jdo.spi.persistence.support.ejb.enhancer.meta.EJBMetaDataModelImpl;
import com.sun.jdo.spi.persistence.support.ejb.model.DeploymentDescriptorModel;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.DeploymentHelper;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.JDOQLParameterDeclarationParser;
import com.sun.jdo.spi.persistence.utility.MergedBundle;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.descriptor.IASEjbCMPEntityDescriptor;
import org.glassfish.ejb.deployment.descriptor.QueryParser;
import org.glassfish.persistence.common.DatabaseConstants;
import org.glassfish.persistence.common.I18NHelper;
import org.netbeans.modules.dbschema.DBException;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.schema2beans.Schema2BeansException;

public class JDOCodeGenerator
implements CMPGenerator,
DatabaseConstants {
    public static final String SIGNATURE = "$RCSfile: JDOCodeGenerator.java,v $ $Revision: 1.7 $";
    private static final String MAPPING_EXTENSION = ".mapping";
    private static final Logger logger = LogHelperEJBCompiler.getLogger();
    private static final ResourceBundle validationBundle = new MergedBundle(I18NHelper.loadBundle(DeploymentDescriptorModel.class), I18NHelper.loadBundle(Model.class));
    private ArrayList<File> files = new ArrayList();
    private DeploymentContext ctx = null;
    private ClassLoader loader = null;
    private JDOConcreteBeanGenerator cmp11Generator;
    private JDOConcreteBeanGenerator cmp20Generator;
    private EjbBundleDescriptorImpl bundle = null;
    private NameMapper nameMapper;
    private Model model;
    private EJBMetaDataModelImpl ejbModel;
    private static QueryParser jdoqlParamDeclParser = new JDOQLParameterDeclarationParser();
    private String inputFilesPath;
    private String generatedXmlsPath;
    private String appName;
    private File classout;
    private MappingGenerator mappingGenerator = null;
    private static final boolean ignoreValidationResults = false;
    private static String signatures = null;

    @Override
    public void init(EjbBundleDescriptorImpl bundle, DeploymentContext ctx, String bundlePathName, String generatedXmlsPathName) throws GeneratorException {
        if (logger.isLoggable(500)) {
            logger.fine("cmp gen init");
        }
        this.ctx = ctx;
        this.generatedXmlsPath = generatedXmlsPathName;
        this.inputFilesPath = bundlePathName;
        this.classout = ctx.getScratchDir("ejb");
        this.appName = ((Application)ctx.getModuleMetaData(Application.class)).getRegistrationName();
        this.init(bundle, ctx.getClassLoader(), bundlePathName, false);
    }

    @Override
    public void init(EjbBundleDescriptorImpl bundle, ClassLoader loader, String bundlePathName) throws GeneratorException {
        this.init(bundle, loader, bundlePathName, false);
    }

    public void init(EjbBundleDescriptorImpl bundle, ClassLoader loader, String bundlePathName, boolean ignoreSunDeploymentDescriptors) throws GeneratorException {
        if (logger.isLoggable(500)) {
            logger.fine("cmp gen init");
        }
        this.bundle = bundle;
        this.loader = loader;
        this.inputFilesPath = bundlePathName;
        try {
            this.nameMapper = new NameMapper(bundle);
            this.model = new DeploymentDescriptorModel(this.nameMapper, loader);
            this.mappingGenerator = new MappingGenerator(bundle, this.model, this.nameMapper, loader);
            this.loadOrCreateMappingClasses(ignoreSunDeploymentDescriptors);
            this.ejbModel = new EJBMetaDataModelImpl(this.model);
        }
        catch (IOException e) {
            throw JDOCodeGeneratorHelper.createGeneratorException("CMG.IOExceptionInInit", (EjbBundleDescriptor)bundle, e);
        }
    }

    @Override
    public Collection validate(IASEjbCMPEntityDescriptor descr) {
        ArrayList c = new ArrayList();
        c.addAll(this.validateModel(descr));
        if (this.getMappingMissingException(c) == null) {
            c.addAll(this.validateEJB(descr));
        }
        if (logger.isLoggable(500)) {
            Iterator i = c.iterator();
            while (i.hasNext()) {
                logger.log(500, "validation exception: ", (Throwable)((Exception)i.next()));
            }
        }
        return c;
    }

    private Collection validateModel(IASEjbCMPEntityDescriptor descr) {
        String beanName = descr.getName();
        String className = this.nameMapper.getPersistenceClassForEjbName(beanName);
        if (this.model.getPersistenceClass(className) == null) {
            return Collections.singletonList(JDOCodeGeneratorHelper.createGeneratorException("CMG.MissingBeanMapping", beanName, (EjbBundleDescriptor)this.bundle));
        }
        return this.model.validate(className, this.loader, validationBundle);
    }

    private GeneratorException getMappingMissingException(Collection c) {
        Object firstElement;
        if (c.size() == 1 && (firstElement = c.iterator().next()) instanceof GeneratorException) {
            return (GeneratorException)firstElement;
        }
        return null;
    }

    private Collection validateEJB(IASEjbCMPEntityDescriptor descr) {
        Collection<GeneratorException> c = null;
        try {
            JDOConcreteBeanGenerator cmpGenerator = this.getCMPGenerator(descr);
            c = cmpGenerator.validate(new MethodHelper(descr), descr.getName());
        }
        catch (GeneratorException e) {
            c = new ArrayList<GeneratorException>();
            c.add(e);
        }
        return c;
    }

    private Collection validateSupported(IASEjbCMPEntityDescriptor descr) {
        ArrayList rc = new ArrayList();
        return rc;
    }

    @Override
    public void generate(IASEjbCMPEntityDescriptor ejbcmp, File srcout, File classout) throws GeneratorException {
        ArrayList c;
        GeneratorException mappingMissingEx;
        String beanName = ejbcmp.getName();
        StringBuffer validateex = null;
        boolean debug = logger.isLoggable(500);
        if (debug) {
            logger.fine("gen file in " + srcout.getAbsolutePath());
        }
        if ((mappingMissingEx = this.getMappingMissingException(c = new ArrayList(this.validateModel(ejbcmp)))) != null) {
            throw mappingMissingEx;
        }
        c.addAll(this.validateSupported(ejbcmp));
        JDOConcreteBeanGenerator cmpGenerator = this.getCMPGenerator(ejbcmp);
        MethodHelper mh = new MethodHelper(ejbcmp);
        c.addAll(cmpGenerator.validate(mh, beanName));
        if (!c.isEmpty()) {
            validateex = new StringBuffer();
            for (Exception ex : c) {
                if (debug) {
                    logger.log(500, "validation exception: ", (Throwable)ex);
                }
                validateex.append(ex.getMessage()).append('\n');
            }
            throw JDOCodeGeneratorHelper.createGeneratorException("CMG.ExceptionInValidate", beanName, (EjbBundleDescriptor)this.bundle, validateex.toString());
        }
        try {
            Collection<File> newfiles = null;
            if (!ejbcmp.isEJB20()) {
                ejbcmp.setQueryParser(jdoqlParamDeclParser);
            }
            newfiles = cmpGenerator.generate(mh, beanName, this.appName, srcout, classout);
            this.files.addAll(newfiles);
            newfiles = this.generatePC(ejbcmp, srcout, classout);
            this.files.addAll(newfiles);
            if (validateex != null) {
                throw JDOCodeGeneratorHelper.createGeneratorException("CMG.ExceptionInValidate", beanName, (EjbBundleDescriptor)this.bundle, validateex.toString());
            }
        }
        catch (JDOUserException e) {
            throw JDOCodeGeneratorHelper.createGeneratorException("CMG.ExceptionInGenerate", beanName, (EjbBundleDescriptor)this.bundle, e, validateex);
        }
        catch (EJBQLException e) {
            throw JDOCodeGeneratorHelper.createGeneratorException("CMG.ExceptionInGenerate", beanName, (EjbBundleDescriptor)this.bundle, e, validateex);
        }
        catch (IOException e) {
            throw JDOCodeGeneratorHelper.createGeneratorException("CMG.IOExceptionInGenerate", beanName, (EjbBundleDescriptor)this.bundle, e, validateex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<File> generatePC(IASEjbCMPEntityDescriptor ejbcmp, File srcout, File classout) throws IOException {
        ArrayList<File> fileList = new ArrayList<File>();
        Main gen = new Main((ExtendedJDOMetaData)this.ejbModel, srcout);
        String className = this.nameMapper.getPersistenceClassForEjbName(ejbcmp.getName());
        if (className != null) {
            String jvmClassName = className.replace('.', '/');
            File file = gen.generate(jvmClassName);
            fileList.add(file);
            MappingClassElement mappingClass = this.model.getMappingClass(className);
            FilterOutputStream mapOut = null;
            try {
                String mapPath = className.replace('.', File.separatorChar);
                String mappingFile = mapPath + MAPPING_EXTENSION;
                mapOut = new BufferedOutputStream(new FileOutputStream(new File(classout, mappingFile)));
                this.model.storeMappingClass(mappingClass, (OutputStream)mapOut);
            }
            finally {
                block10: {
                    if (mapOut != null) {
                        try {
                            mapOut.close();
                        }
                        catch (Exception ex) {
                            if (!logger.isLoggable(500)) break block10;
                            logger.fine(ex.getMessage());
                        }
                    }
                }
            }
        }
        return fileList;
    }

    public Collection cleanup() throws GeneratorException {
        this.mappingGenerator.cleanup();
        this.cmp11Generator = null;
        this.cmp20Generator = null;
        return this.files;
    }

    private JDOConcreteBeanGenerator getCMPGenerator(IASEjbCMPEntityDescriptor descr) throws GeneratorException {
        JDOConcreteBeanGenerator cmpGenerator = null;
        try {
            cmpGenerator = descr.isEJB20() ? this.getCMP20Generator() : this.getCMP11Generator();
            cmpGenerator.setUpdateable(!descr.getIASEjbExtraDescriptors().isIsReadOnlyBean());
        }
        catch (IOException e) {
            throw JDOCodeGeneratorHelper.createGeneratorException("CMG.IOExceptionInInit", (EjbBundleDescriptor)this.bundle, e);
        }
        return cmpGenerator;
    }

    private JDOConcreteBeanGenerator getCMP20Generator() throws IOException {
        if (this.cmp20Generator == null) {
            this.cmp20Generator = new JDOConcreteBean20Generator(this.loader, this.model, this.nameMapper);
            this.addSignatures(this.cmp20Generator);
        }
        return this.cmp20Generator;
    }

    private JDOConcreteBeanGenerator getCMP11Generator() throws IOException {
        if (this.cmp11Generator == null) {
            this.cmp11Generator = new JDOConcreteBean11Generator(this.loader, this.model, this.nameMapper);
            this.addSignatures(this.cmp11Generator);
        }
        return this.cmp11Generator;
    }

    private void addSignatures(JDOConcreteBeanGenerator cmpGenerator) throws IOException {
        cmpGenerator.addCodeGenInputFilesSignature(this.getSignaturesOfInputFiles());
        cmpGenerator.addCodeGeneratorClassSignature(JDOCodeGenerator.getS1ASSpecificGeneratorClassesSignature());
    }

    private static synchronized String getS1ASSpecificGeneratorClassesSignature() {
        if (signatures == null) {
            StringBuffer sb = new StringBuffer().append(SIGNATURE).append(" ## ").append("$RCSfile: NameMapper.java,v $ $Revision: 1.2 $");
            signatures = sb.toString();
        }
        return signatures;
    }

    private String getSignaturesOfInputFiles() throws IOException {
        StringBuffer sb = new StringBuffer().append(this.getFileInfoOfInputFile(this.inputFilesPath + File.separator + "META-INF/ejb-jar.xml")).append(" ## ").append(this.getFileInfoOfInputFile(this.inputFilesPath + File.separator + "META-INF/sun-ejb-jar.xml")).append(" ## ").append(this.getFileInfoOfInputFile(this.inputFilesPath + File.separator + "META-INF/sun-cmp-mappings.xml"));
        return sb.toString();
    }

    private String getFileInfoOfInputFile(String pathname) throws IOException {
        File inputFile = new File(pathname);
        StringBuffer inputFileInfo = new StringBuffer().append(inputFile.getCanonicalPath().replace('\\', '/')).append(" ").append(String.valueOf(inputFile.length())).append(" bytes");
        return inputFileInfo.toString();
    }

    private void loadOrCreateMappingClasses(boolean ignoreSunDeploymentDescriptors) throws IOException, GeneratorException {
        try {
            SchemaElement schema = this.mappingGenerator.generateMapping(this.ctx, this.inputFilesPath, this.generatedXmlsPath, this.classout, ignoreSunDeploymentDescriptors);
            if (this.ctx != null && this.mappingGenerator.isJavaToDatabase()) {
                this.createDDLs(schema, this.mappingGenerator.getDatabaseVendorName(), null);
            }
        }
        catch (SQLException ex) {
            throw JDOCodeGeneratorHelper.createGeneratorException("CMG.SQLException", (EjbBundleDescriptor)this.bundle, ex);
        }
        catch (DBException ex) {
            throw JDOCodeGeneratorHelper.createGeneratorException("CMG.DBException", (EjbBundleDescriptor)this.bundle, (Exception)((Object)ex));
        }
        catch (ModelException ex) {
            throw JDOCodeGeneratorHelper.createGeneratorException("CMG.ModelException", (EjbBundleDescriptor)this.bundle, (Exception)((Object)ex));
        }
        catch (Schema2BeansException ex) {
            throw JDOCodeGeneratorHelper.createGeneratorException("CMG.Schema2BeansException", (EjbBundleDescriptor)this.bundle, (Exception)((Object)ex));
        }
        catch (ConversionException ex) {
            throw JDOCodeGeneratorHelper.createGeneratorException("CMG.MappingConversionException", (EjbBundleDescriptor)this.bundle, (Exception)((Object)ex));
        }
    }

    private void createDDLs(SchemaElement schema, String dbVendorName, Connection conn) throws IOException, DBException {
        block4: {
            File fileDir = new File(this.generatedXmlsPath);
            if (!fileDir.exists()) {
                fileDir.mkdirs();
            }
            String namePrefix = DeploymentHelper.getDDLNamePrefix(this.bundle);
            FileOutputStream createDDLSql = new FileOutputStream(new File(this.generatedXmlsPath, namePrefix + '_' + dbVendorName + "_create.sql"));
            FileOutputStream dropDDLSql = new FileOutputStream(new File(this.generatedXmlsPath, namePrefix + '_' + dbVendorName + "_drop.sql"));
            FileOutputStream dropDDLTxt = new FileOutputStream(new File(this.classout, namePrefix + "_dropDDL.jdbc"));
            FileOutputStream createDDLTxt = new FileOutputStream(new File(this.classout, namePrefix + "_createDDL.jdbc"));
            try {
                DatabaseOutputStream dbStream = null;
                boolean createTablesAtDeploy = false;
                boolean dropTablesAtDeploy = false;
                if (conn != null && (createTablesAtDeploy || dropTablesAtDeploy)) {
                    dbStream = new DatabaseOutputStream(conn);
                }
                DDLGenerator.generateDDL((SchemaElement)schema, (String)dbVendorName, (OutputStream)createDDLSql, (OutputStream)dropDDLSql, (OutputStream)dropDDLTxt, (OutputStream)createDDLTxt, (OutputStream)dbStream, (boolean)dropTablesAtDeploy);
            }
            catch (SQLException ex) {
                if (!logger.isLoggable(900)) break block4;
                logger.warning(ex.toString());
            }
        }
    }
}

