/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.Button;
import com.sun.webui.jsf.component.CalendarMonth;
import com.sun.webui.jsf.component.ComplexComponent;
import com.sun.webui.jsf.component.DateManager;
import com.sun.webui.jsf.component.DropDown;
import com.sun.webui.jsf.component.Label;
import com.sun.webui.jsf.component.TextField;
import com.sun.webui.jsf.component.Time;
import com.sun.webui.jsf.component.WebuiInput;
import com.sun.webui.jsf.converter.DateConverter;
import com.sun.webui.jsf.event.IntervalListener;
import com.sun.webui.jsf.event.SchedulerPreviewListener;
import com.sun.webui.jsf.model.ClockTime;
import com.sun.webui.jsf.model.Option;
import com.sun.webui.jsf.model.ScheduledEvent;
import com.sun.webui.jsf.model.scheduler.RepeatInterval;
import com.sun.webui.jsf.model.scheduler.RepeatIntervalConverter;
import com.sun.webui.jsf.model.scheduler.RepeatIntervalOption;
import com.sun.webui.jsf.model.scheduler.RepeatUnit;
import com.sun.webui.jsf.model.scheduler.RepeatUnitConverter;
import com.sun.webui.jsf.model.scheduler.RepeatUnitOption;
import com.sun.webui.jsf.util.ComponentUtilities;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.jsf.validator.DateInRangeValidator;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.IntegerConverter;
import javax.faces.validator.DoubleRangeValidator;
import javax.faces.validator.Validator;

public class Scheduler
extends WebuiInput
implements ComplexComponent,
DateManager,
NamingContainer {
    public static final String DATE_PICKER_FACET = "datePicker";
    public static final String DATE_FACET = "date";
    public static final String DATE_LABEL_FACET = "dateLabel";
    public static final String START_DATE_TEXT_KEY = "Scheduler.startDate";
    public static final String START_TIME_FACET = "startTime";
    public static final String START_TIME_LABEL_FACET = "startTimeLabel";
    public static final String START_TIME_TEXT_KEY = "Scheduler.startTime";
    public static final String END_TIME_FACET = "endTime";
    public static final String END_TIME_LABEL_FACET = "endTimeLabel";
    public static final String END_TIME_TEXT_KEY = "Scheduler.endTime";
    public static final String REPEAT_LIMIT_UNIT_FACET = "repeatLimitUnit";
    public static final String REPEAT_UNIT_DESCRIPTION_TEXT_KEY = "Scheduler.repeatUnitDesc";
    public static final String REPEAT_LIMIT_FACET = "repeatLimit";
    public static final String REPEAT_LIMIT_LABEL_FACET = "repeatLimitLabel";
    public static final String REPEAT_LIMIT_TEXT_KEY = "Scheduler.repeatLimit";
    public static final String REPEAT_INTERVAL_FACET = "repeatInterval";
    public static final String REPEAT_INTERVAL_LABEL_FACET = "repeatIntervalLabel";
    public static final String REPEAT_INTERVAL_TEXT_KEY = "Scheduler.repeatInterval";
    public static final String REPEAT_INTERVAL_DESCRIPTION_TEXT_KEY = "Scheduler.repeatIntervalDesc";
    public static final String PREVIEW_BUTTON_FACET = "previewButton";
    public static final String PREVIEW_BUTTON_TEXT_KEY = "Scheduler.preview";
    public static final String START_HOUR_TITLE_TEXT_KEY = "Scheduler.startHourTitle";
    public static final String START_MINUTE_TITLE_TEXT_KEY = "Scheduler.startMinuteTitle";
    public static final String END_HOUR_TITLE_TEXT_KEY = "Scheduler.endHourTitle";
    public static final String END_MINUTE_TITLE_TEXT_KEY = "Scheduler.endMinuteTitle";
    private final String END_BEFORE_START_TEXT_KEY = "Scheduler.endBeforeStart";
    private static final String INVALID_INPUT_TEXT_KEY = "Scheduler.invalidInput";
    private static final String INVALID_DATE_TEXT_KEY = "Scheduler.invalidDate";
    private static final String INVALID_START_TIME_TEXT_KEY = "Scheduler.invalidStartTime";
    private static final String INVALID_END_TIME_TEXT_KEY = "Scheduler.invalidEndTime";
    public static final String ICON_ID = "_icon";
    private static final String VALUE_SUBMITTED = "com.sun.webui.jsf.SchedulerSubmitted";
    private static final String FIRST_AVAILABLE_DATE = "com.sun.webui.jsf.FirstAvailable";
    private static final String LAST_AVAILABLE_DATE = "com.sun.webui.jsf.LastAvailable";
    private static final boolean DEBUG = false;
    private String dateFormatPattern = null;
    private String dateFormatPatternHelp = null;
    private String dateLabel = null;
    private boolean disabled = false;
    private boolean disabled_set = false;
    private boolean endTime = false;
    private boolean endTime_set = false;
    private String endTimeLabel = null;
    private boolean limitRepeating = false;
    private boolean limitRepeating_set = false;
    private Date maxDate = null;
    private Date minDate = null;
    private boolean previewButton = false;
    private boolean previewButton_set = false;
    private boolean readOnly = false;
    private boolean readOnly_set = false;
    private Object repeatIntervalItems = null;
    private String repeatIntervalLabel = null;
    private String repeatLimitLabel = null;
    private Object repeatUnitItems = null;
    private boolean repeating = false;
    private boolean repeating_set = false;
    private boolean required = false;
    private boolean required_set = false;
    private boolean requiredLegend = false;
    private boolean requiredLegend_set = false;
    private boolean startTime = false;
    private boolean startTime_set = false;
    private String startTimeLabel = null;
    private String style = null;
    private String styleClass = null;
    private int tabIndex = Integer.MIN_VALUE;
    private boolean tabIndex_set = false;
    private TimeZone timeZone = null;
    private boolean visible = false;
    private boolean visible_set = false;

    public Scheduler() {
        this.setRendererType("com.sun.webui.jsf.Scheduler");
    }

    public String getFamily() {
        return "com.sun.webui.jsf.Scheduler";
    }

    public CalendarMonth getDatePicker() {
        CalendarMonth dp = (CalendarMonth)ComponentUtilities.getPrivateFacet((UIComponent)this, DATE_PICKER_FACET, true);
        if (dp == null) {
            dp = new CalendarMonth();
            dp.setPopup(false);
            dp.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, DATE_PICKER_FACET));
            ComponentUtilities.putPrivateFacet((UIComponent)this, DATE_PICKER_FACET, (UIComponent)dp);
        }
        dp.setJavaScriptObjectName(this.getJavaScriptObjectName(FacesContext.getCurrentInstance()));
        return dp;
    }

    public UIComponent getDateLabelComponent(Theme theme) {
        UIComponent comp;
        String label = this.getDateLabel();
        if (label == null) {
            label = theme.getMessage(START_DATE_TEXT_KEY);
        }
        return this.getLabelFacet(DATE_LABEL_FACET, label, (comp = this.getDateComponent()) != null ? comp.getClientId(this.getFacesContext()) : null);
    }

    public UIComponent getDateComponent() {
        UIComponent fieldComponent = this.getFacet(DATE_FACET);
        if (fieldComponent != null) {
            return fieldComponent;
        }
        TextField field = (TextField)ComponentUtilities.getPrivateFacet((UIComponent)this, DATE_FACET, true);
        if (field == null) {
            field = new TextField();
            field.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, DATE_FACET));
            field.setConverter(new DateConverter());
            field.addValidator(new DateInRangeValidator());
            ComponentUtilities.putPrivateFacet((UIComponent)this, DATE_FACET, (UIComponent)field);
        }
        field.setDisabled(this.isDisabled());
        this.initFieldFacet(field, 12, this.isRequired());
        return field;
    }

    public UIComponent getStartTimeLabelComponent(Theme theme) {
        Time comp;
        String label = this.getStartTimeLabel();
        if (label == null) {
            label = theme.getMessage(START_TIME_TEXT_KEY);
        }
        return this.getLabelFacet(START_TIME_LABEL_FACET, label, (comp = this.getStartTimeComponent()) != null ? comp.getClientId(this.getFacesContext()) : null);
    }

    public Time getStartTimeComponent() {
        return this.getTimeFacet(START_TIME_FACET, this.isRequired(), START_HOUR_TITLE_TEXT_KEY, START_MINUTE_TITLE_TEXT_KEY);
    }

    public UIComponent getEndTimeLabelComponent(Theme theme) {
        Time comp;
        String label = this.getEndTimeLabel();
        if (label == null) {
            label = theme.getMessage(END_TIME_TEXT_KEY);
        }
        return this.getLabelFacet(END_TIME_LABEL_FACET, label, (comp = this.getEndTimeComponent()) != null ? comp.getClientId(this.getFacesContext()) : null);
    }

    public Time getEndTimeComponent() {
        return this.getTimeFacet(END_TIME_FACET, false, END_HOUR_TITLE_TEXT_KEY, END_MINUTE_TITLE_TEXT_KEY);
    }

    public UIComponent getRepeatIntervalLabelComponent() {
        DropDown comp;
        String label = this.getRepeatIntervalLabel();
        if (label == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            label = ThemeUtilities.getTheme(context).getMessage(REPEAT_INTERVAL_TEXT_KEY);
        }
        return this.getLabelFacet(REPEAT_INTERVAL_LABEL_FACET, label, (comp = this.getRepeatIntervalComponent()) != null ? comp.getClientId(this.getFacesContext()) : null);
    }

    public DropDown getRepeatIntervalComponent() {
        DropDown dropDown = (DropDown)ComponentUtilities.getPrivateFacet((UIComponent)this, REPEAT_INTERVAL_FACET, true);
        if (dropDown == null) {
            dropDown = new DropDown();
            dropDown.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, REPEAT_INTERVAL_FACET));
            dropDown.setSubmitForm(true);
            dropDown.setConverter(new RepeatIntervalConverter());
            dropDown.setImmediate(true);
            dropDown.addActionListener(new IntervalListener());
            ComponentUtilities.putPrivateFacet((UIComponent)this, REPEAT_INTERVAL_FACET, (UIComponent)dropDown);
        }
        dropDown.setItems(this.getRepeatIntervalItems());
        Theme theme = ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
        dropDown.setToolTip(theme.getMessage(REPEAT_INTERVAL_DESCRIPTION_TEXT_KEY));
        return dropDown;
    }

    public UIComponent getRepeatLimitLabelComponent() {
        UIComponent comp;
        String label = this.getRepeatLimitLabel();
        if (label == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            label = ThemeUtilities.getTheme(context).getMessage(REPEAT_LIMIT_TEXT_KEY);
        }
        return this.getLabelFacet(REPEAT_LIMIT_LABEL_FACET, label, (comp = this.getRepeatingFieldComponent()) != null ? comp.getClientId(this.getFacesContext()) : null);
    }

    public UIComponent getRepeatingFieldComponent() {
        UIComponent fieldComponent = this.getFacet(REPEAT_LIMIT_FACET);
        if (fieldComponent != null) {
            return fieldComponent;
        }
        TextField field = (TextField)ComponentUtilities.getPrivateFacet((UIComponent)this, REPEAT_LIMIT_FACET, true);
        if (field == null) {
            field = new TextField();
            field.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, REPEAT_LIMIT_FACET));
            IntegerConverter converter = new IntegerConverter();
            field.setConverter((Converter)converter);
            DoubleRangeValidator drv = new DoubleRangeValidator();
            drv.setMinimum(1.0);
            field.addValidator((Validator)drv);
            ComponentUtilities.putPrivateFacet((UIComponent)this, REPEAT_LIMIT_FACET, (UIComponent)field);
        }
        this.initFieldFacet(field, 3, false);
        return field;
    }

    public DropDown getRepeatUnitComponent() {
        DropDown dropDown = (DropDown)ComponentUtilities.getPrivateFacet((UIComponent)this, REPEAT_LIMIT_UNIT_FACET, true);
        if (dropDown == null) {
            dropDown = new DropDown();
            dropDown.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, REPEAT_LIMIT_UNIT_FACET));
            dropDown.setConverter(new RepeatUnitConverter());
            ComponentUtilities.putPrivateFacet((UIComponent)this, REPEAT_LIMIT_UNIT_FACET, (UIComponent)dropDown);
        }
        dropDown.setItems(this.getRepeatUnitItems());
        Theme theme = ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
        dropDown.setToolTip(theme.getMessage(REPEAT_UNIT_DESCRIPTION_TEXT_KEY));
        return dropDown;
    }

    public UIComponent getPreviewButtonComponent() {
        UIComponent buttonComponent = this.getFacet(PREVIEW_BUTTON_FACET);
        if (buttonComponent != null) {
            return buttonComponent;
        }
        Button button = (Button)ComponentUtilities.getPrivateFacet((UIComponent)this, PREVIEW_BUTTON_FACET, true);
        if (button == null) {
            button = new Button();
            button.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, PREVIEW_BUTTON_FACET));
            button.setMini(true);
            button.setPrimary(false);
            button.setImmediate(true);
            button.addActionListener(new SchedulerPreviewListener());
            ComponentUtilities.putPrivateFacet((UIComponent)this, PREVIEW_BUTTON_FACET, (UIComponent)button);
        }
        button.setText(ThemeUtilities.getTheme(FacesContext.getCurrentInstance()).getMessage(PREVIEW_BUTTON_TEXT_KEY));
        return button;
    }

    public void updateRepeatUnitMenu() {
        if (!this.isLimitRepeating()) {
            return;
        }
        DropDown repeatIntervalComp = (DropDown)this.getPrivateFacet(REPEAT_INTERVAL_FACET);
        Object value = repeatIntervalComp.getValue();
        if (value == null || !(value instanceof RepeatInterval)) {
            this.disableRepeatLimitComponents();
        } else {
            RepeatInterval ri = (RepeatInterval)value;
            if (ri.getRepresentation().equals("ONETIME")) {
                this.disableRepeatLimitComponents();
            } else {
                this.enableRepeatLimitComponents(ri);
            }
        }
    }

    public String getPrimaryElementID(FacesContext context) {
        return this.getLabeledElementId(context);
    }

    public String getLabeledElementId(FacesContext context) {
        UIComponent comp = this.getDateComponent();
        if (comp == null) {
            return null;
        }
        if (comp instanceof ComplexComponent) {
            return ((ComplexComponent)comp).getLabeledElementId(context);
        }
        return comp.getClientId(context);
    }

    public String getFocusElementId(FacesContext context) {
        return this.getLabeledElementId(context);
    }

    public Object getRepeatIntervalItems() {
        Option[] optionsObject = this._getRepeatIntervalItems();
        if (optionsObject == null) {
            Option[] options = new Option[]{new RepeatIntervalOption(RepeatInterval.getInstance("ONETIME")), new RepeatIntervalOption(RepeatInterval.getInstance("HOURLY")), new RepeatIntervalOption(RepeatInterval.getInstance("DAILY")), new RepeatIntervalOption(RepeatInterval.getInstance("WEEKLY")), new RepeatIntervalOption(RepeatInterval.getInstance("MONTHLY"))};
            optionsObject = options;
            this.setRepeatIntervalItems(options);
        }
        return optionsObject;
    }

    public Object getRepeatUnitItems() {
        Option[] optionsObject = this._getRepeatUnitItems();
        if (optionsObject == null) {
            Option[] options = new Option[]{new RepeatUnitOption(RepeatUnit.getInstance("HOURS")), new RepeatUnitOption(RepeatUnit.getInstance("DAYS")), new RepeatUnitOption(RepeatUnit.getInstance("WEEKS")), new RepeatUnitOption(RepeatUnit.getInstance("MONTHS"))};
            optionsObject = options;
            this.setRepeatUnitItems(options);
        }
        return optionsObject;
    }

    public DateFormat getDateFormat() {
        return this.getDatePicker().getDateFormat();
    }

    public String getJavaScriptObjectName(FacesContext context) {
        return JavaScriptUtilities.getDomNode(this.getFacesContext(), (UIComponent)this);
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.setValid(true);
        UIComponent facet = this.getPrivateFacet(DATE_PICKER_FACET);
        facet.processDecodes(context);
        this.getPreviewButtonComponent().processDecodes(context);
        this.getDateComponent().processDecodes(context);
        if (this.isStartTime()) {
            facet = this.getPrivateFacet(START_TIME_FACET);
            facet.processDecodes(context);
        }
        if (this.isEndTime()) {
            facet = this.getPrivateFacet(END_TIME_FACET);
            facet.processDecodes(context);
        }
        if (this.isRepeating()) {
            facet = this.getPrivateFacet(REPEAT_INTERVAL_FACET);
            facet.processDecodes(context);
            if (this.isLimitRepeating()) {
                facet = this.getPrivateFacet(REPEAT_LIMIT_FACET);
                facet.processDecodes(context);
                facet = this.getPrivateFacet(REPEAT_LIMIT_UNIT_FACET);
                facet.processDecodes(context);
            }
        }
        this.setSubmittedValue(VALUE_SUBMITTED);
        if (this.isImmediate()) {
            this.runValidation(context);
        }
    }

    public Object getConvertedValue(FacesContext context, Object submittedValue) throws ConverterException {
        if (context == null) {
            throw new NullPointerException();
        }
        Iterator kids = this.getFacetsAndChildren();
        UIComponent kid = null;
        while (kids.hasNext()) {
            kid = (UIComponent)kids.next();
            if (!(kid instanceof EditableValueHolder) || ((EditableValueHolder)kid).isValid()) continue;
            return null;
        }
        Object dateValue = ((EditableValueHolder)this.getDateComponent()).getValue();
        Object startTimeValue = null;
        Object endTimeValue = null;
        if (this.isStartTime()) {
            startTimeValue = this.getStartTimeComponent().getValue();
        }
        if (this.isEndTime()) {
            endTimeValue = this.getEndTimeComponent().getValue();
        }
        ScheduledEvent newValue = this.createScheduledEvent(dateValue, startTimeValue, endTimeValue, context);
        if (this.isRepeating()) {
            RepeatInterval freq;
            boolean valueRepeat = false;
            Object repeatFrequency = this.getRepeatIntervalComponent().getValue();
            if (repeatFrequency != null && repeatFrequency instanceof RepeatInterval && (freq = (RepeatInterval)repeatFrequency).getCalendarField() > -1) {
                valueRepeat = true;
            }
            if (valueRepeat) {
                newValue.setRepeatingEvent(true);
                try {
                    newValue.setRepeatInterval((RepeatInterval)repeatFrequency);
                    if (this.isLimitRepeating()) {
                        Object repeatUnit = this.getRepeatUnitComponent().getValue();
                        if (repeatUnit instanceof RepeatUnit) {
                            newValue.setDurationUnit((RepeatUnit)repeatUnit);
                        } else {
                            newValue.setDurationUnit(null);
                        }
                        Object repeatLimit = ((EditableValueHolder)this.getRepeatingFieldComponent()).getValue();
                        if (repeatLimit instanceof Integer) {
                            newValue.setDuration((Integer)repeatLimit);
                        }
                        newValue.setDuration(null);
                    }
                    newValue.setDurationUnit(null);
                    newValue.setDuration(null);
                }
                catch (Exception ce) {
                    throw new ConverterException();
                }
            } else {
                newValue.setRepeatingEvent(false);
                newValue.setDurationUnit(null);
                newValue.setDuration(null);
            }
        } else {
            newValue.setRepeatingEvent(false);
            newValue.setDurationUnit(null);
            newValue.setDuration(null);
        }
        this.getDatePicker().setValue(newValue);
        return newValue;
    }

    private UIComponent getLabelFacet(String facetName, String labelText, String labeledComponentId) {
        UIComponent labelFacet = this.getFacet(facetName);
        if (labelFacet != null) {
            return labelFacet;
        }
        Label label = (Label)ComponentUtilities.getPrivateFacet((UIComponent)this, facetName, true);
        if (label == null) {
            label = new Label();
            label.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, facetName));
            ComponentUtilities.putPrivateFacet((UIComponent)this, facetName, (UIComponent)label);
        }
        label.setText(labelText);
        label.setFor(labeledComponentId);
        label.setLabelLevel(2);
        return label;
    }

    private void initFieldFacet(TextField field, int columns, boolean required) {
        field.setColumns(columns);
        field.setTrim(true);
        field.setRequired(required);
        int tindex = this.getTabIndex();
        if (tindex > 0) {
            field.setTabIndex(tindex);
        }
    }

    private Time getTimeFacet(String facetName, boolean required, String hourKey, String minutesKey) {
        Time time = (Time)ComponentUtilities.getPrivateFacet((UIComponent)this, facetName, true);
        if (time == null) {
            time = new Time();
            time.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, facetName));
            ComponentUtilities.putPrivateFacet((UIComponent)this, facetName, (UIComponent)time);
        }
        time.setRequired(required);
        time.setTimeZone(this.getTimeZone());
        time.setHourTooltipKey(hourKey);
        time.setMinutesTooltipKey(minutesKey);
        return time;
    }

    private void runValidation(FacesContext context) {
        try {
            this.validate(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    private ScheduledEvent createScheduledEvent(Object dateObject, Object startTimeObject, Object endTimeObject, FacesContext context) {
        ScheduledEvent event = null;
        String messageKey = null;
        if (!(dateObject instanceof Date)) {
            messageKey = INVALID_DATE_TEXT_KEY;
        }
        if (!(startTimeObject instanceof ClockTime)) {
            messageKey = INVALID_START_TIME_TEXT_KEY;
        }
        if (endTimeObject != null && !(endTimeObject instanceof ClockTime)) {
            messageKey = INVALID_END_TIME_TEXT_KEY;
        }
        if (messageKey == null) {
            event = new ScheduledEvent();
            Date date = (Date)dateObject;
            ClockTime startTime = (ClockTime)startTimeObject;
            event.setStartTime(this.calculateDate(date, startTime));
            if (endTimeObject != null) {
                ClockTime endTime = (ClockTime)endTimeObject;
                event.setEndTime(this.calculateDate(date, endTime));
                if (event.getEndTime().before(event.getStartTime())) {
                    messageKey = "Scheduler.endBeforeStart";
                    this.getEndTimeComponent().setValid(false);
                }
            }
        }
        if (messageKey != null) {
            String message = ThemeUtilities.getTheme(context).getMessage(messageKey);
            throw new ConverterException(new FacesMessage(message));
        }
        return event;
    }

    private Date calculateDate(Date date, ClockTime time) {
        Calendar calendar = (Calendar)this.getDatePicker().getCalendar().clone();
        calendar.setTime(date);
        calendar.set(11, time.getHour());
        calendar.set(12, time.getMinute());
        return calendar.getTime();
    }

    private void disableRepeatLimitComponents() {
        DropDown dd = this.getRepeatUnitComponent();
        UIComponent comp = this.getRepeatingFieldComponent();
        dd.setDisabled(true);
        dd.setSubmittedValue(null);
        dd.setValue(null);
        comp.getAttributes().put("disabled", Boolean.TRUE);
        ((EditableValueHolder)comp).setValue(null);
        ((EditableValueHolder)comp).setSubmittedValue(null);
    }

    private void enableRepeatLimitComponents(RepeatInterval ri) {
        DropDown dd = this.getRepeatUnitComponent();
        UIComponent comp = this.getRepeatingFieldComponent();
        dd.setValue(ri.getDefaultRepeatUnit());
        dd.setSubmittedValue(null);
        dd.setDisabled(false);
        comp.getAttributes().put("disabled", Boolean.FALSE);
    }

    private void log(String s) {
        System.out.println(this.getClass().getName() + "::" + s);
    }

    private UIComponent getPrivateFacet(String facetName) {
        Object facet = ComponentUtilities.getPrivateFacet((UIComponent)this, facetName, false);
        if (facet != null) {
            return facet;
        }
        if (facetName.equals(DATE_PICKER_FACET)) {
            facet = this.getDatePicker();
        } else if (facetName.equals(START_TIME_FACET)) {
            facet = this.getStartTimeComponent();
        } else if (facetName.equals(END_TIME_FACET)) {
            facet = this.getEndTimeComponent();
        } else if (facetName.equals(REPEAT_LIMIT_UNIT_FACET)) {
            facet = this.getRepeatUnitComponent();
        } else if (facetName.equals(REPEAT_INTERVAL_FACET)) {
            facet = this.getRepeatIntervalComponent();
        }
        return facet;
    }

    public void encodeEnd(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        if (this.getSubmittedValue() != null) {
            this.updateDatePicker(context);
        } else {
            this.initializeValues(context);
        }
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            this.getRenderer(context).encodeEnd(context, (UIComponent)this);
        }
    }

    private void updateDatePicker(FacesContext context) {
        block4: {
            try {
                Object value = this.getConvertedValue(context, null);
                this.getDatePicker().setValue(value);
            }
            catch (Exception ex) {
                UIComponent comp = this.getDateComponent();
                Object value = ((EditableValueHolder)comp).getSubmittedValue();
                if (value == null) break block4;
                try {
                    Object dO = ConversionUtilities.convertValueToObject(comp, (String)value, context);
                    this.getDatePicker().setValue(dO);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void initializeValues(FacesContext context) {
        CalendarMonth dp = this.getDatePicker();
        Object value = this.getValue();
        if (value != null && value instanceof ScheduledEvent) {
            ScheduledEvent event = (ScheduledEvent)value;
            dp.setValue(event);
            dp.displayValue();
            ((EditableValueHolder)this.getDateComponent()).setValue((Object)event.getStartTime());
            if (this.isStartTime()) {
                this.getStartTimeComponent().setValue(this.getClockTime(dp, event.getStartTime()));
            }
            if (this.isEndTime()) {
                this.getEndTimeComponent().setValue(this.getClockTime(dp, event.getEndTime()));
            }
            if (this.isRepeating()) {
                RepeatInterval ri = event.getRepeatInterval();
                this.getRepeatIntervalComponent().setValue(ri);
                if (this.isLimitRepeating()) {
                    DropDown unitDropDown = this.getRepeatUnitComponent();
                    UIComponent comp = this.getRepeatingFieldComponent();
                    if (ri == null || ri.getRepresentation().equals("ONETIME")) {
                        unitDropDown.setDisabled(true);
                        unitDropDown.setValue(null);
                        ((EditableValueHolder)comp).setValue(null);
                        comp.getAttributes().put("disabled", Boolean.TRUE);
                    } else {
                        unitDropDown.setDisabled(false);
                        unitDropDown.setValue(event.getDurationUnit());
                        ((EditableValueHolder)comp).setValue((Object)event.getDuration());
                        comp.getAttributes().put("disabled", Boolean.FALSE);
                    }
                }
            }
        } else {
            dp.setValue(null);
            ((EditableValueHolder)this.getDateComponent()).setValue(null);
            if (this.isStartTime()) {
                this.getStartTimeComponent().setValue(null);
            }
            if (this.isEndTime()) {
                this.getEndTimeComponent().setValue(null);
            }
            if (this.isRepeating()) {
                this.getRepeatIntervalComponent().setValue("ONETIME");
                if (this.isLimitRepeating()) {
                    DropDown ru = this.getRepeatUnitComponent();
                    ru.setValue(null);
                    ru.setDisabled(true);
                    EditableValueHolder rf = (EditableValueHolder)this.getRepeatingFieldComponent();
                    rf.setValue(null);
                    ((UIComponent)rf).getAttributes().put("disabled", Boolean.TRUE);
                }
            }
        }
    }

    private ClockTime getClockTime(CalendarMonth datePicker, Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = datePicker.getCalendar();
        calendar.setTime(date);
        ClockTime clockTime = new ClockTime();
        clockTime.setHour(new Integer(calendar.get(11)));
        clockTime.setMinute(new Integer(calendar.get(12)));
        return clockTime;
    }

    public Date getFirstAvailableDate() {
        Date minDate = this.getMinDate();
        if (minDate == null) {
            Calendar calendar = this.getDatePicker().getCalendar();
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            minDate = calendar.getTime();
        }
        return minDate;
    }

    public Date getLastAvailableDate() {
        Date maxDate = this.getMaxDate();
        if (maxDate == null) {
            Date minDate = this.getFirstAvailableDate();
            Calendar calendar = this.getDatePicker().getCalendar();
            calendar.setTime(minDate);
            calendar.add(1, 4);
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            calendar.set(14, 999);
            maxDate = calendar.getTime();
        }
        return maxDate;
    }

    public void setValue(Object value) {
        super.setValue(value);
    }

    public Converter getConverter() {
        return super.getConverter();
    }

    public String getDateFormatPattern() {
        if (this.dateFormatPattern != null) {
            return this.dateFormatPattern;
        }
        ValueExpression _vb = this.getValueExpression("dateFormatPattern");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setDateFormatPattern(String dateFormatPattern) {
        this.dateFormatPattern = dateFormatPattern;
    }

    public String getDateFormatPatternHelp() {
        if (this.dateFormatPatternHelp != null) {
            return this.dateFormatPatternHelp;
        }
        ValueExpression _vb = this.getValueExpression("dateFormatPatternHelp");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setDateFormatPatternHelp(String dateFormatPatternHelp) {
        this.dateFormatPatternHelp = dateFormatPatternHelp;
    }

    public String getDateLabel() {
        if (this.dateLabel != null) {
            return this.dateLabel;
        }
        ValueExpression _vb = this.getValueExpression(DATE_LABEL_FACET);
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setDateLabel(String dateLabel) {
        this.dateLabel = dateLabel;
    }

    public boolean isDisabled() {
        if (this.disabled_set) {
            return this.disabled;
        }
        ValueExpression _vb = this.getValueExpression("disabled");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return false;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
        this.disabled_set = true;
    }

    public boolean isEndTime() {
        if (this.endTime_set) {
            return this.endTime;
        }
        ValueExpression _vb = this.getValueExpression(END_TIME_FACET);
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return true;
    }

    public void setEndTime(boolean endTime) {
        this.endTime = endTime;
        this.endTime_set = true;
    }

    public String getEndTimeLabel() {
        if (this.endTimeLabel != null) {
            return this.endTimeLabel;
        }
        ValueExpression _vb = this.getValueExpression(END_TIME_LABEL_FACET);
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setEndTimeLabel(String endTimeLabel) {
        this.endTimeLabel = endTimeLabel;
    }

    public boolean isLimitRepeating() {
        if (this.limitRepeating_set) {
            return this.limitRepeating;
        }
        ValueExpression _vb = this.getValueExpression("limitRepeating");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return true;
    }

    public void setLimitRepeating(boolean limitRepeating) {
        this.limitRepeating = limitRepeating;
        this.limitRepeating_set = true;
    }

    public Date getMaxDate() {
        if (this.maxDate != null) {
            return this.maxDate;
        }
        ValueExpression _vb = this.getValueExpression("maxDate");
        if (_vb != null) {
            return (Date)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setMaxDate(Date maxDate) {
        this.maxDate = maxDate;
    }

    public Date getMinDate() {
        if (this.minDate != null) {
            return this.minDate;
        }
        ValueExpression _vb = this.getValueExpression("minDate");
        if (_vb != null) {
            return (Date)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setMinDate(Date minDate) {
        this.minDate = minDate;
    }

    public boolean isPreviewButton() {
        if (this.previewButton_set) {
            return this.previewButton;
        }
        ValueExpression _vb = this.getValueExpression(PREVIEW_BUTTON_FACET);
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return true;
    }

    public void setPreviewButton(boolean previewButton) {
        this.previewButton = previewButton;
        this.previewButton_set = true;
    }

    public boolean isReadOnly() {
        if (this.readOnly_set) {
            return this.readOnly;
        }
        ValueExpression _vb = this.getValueExpression("readOnly");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return false;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.readOnly_set = true;
    }

    private Object _getRepeatIntervalItems() {
        if (this.repeatIntervalItems != null) {
            return this.repeatIntervalItems;
        }
        ValueExpression _vb = this.getValueExpression("repeatIntervalItems");
        if (_vb != null) {
            return _vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setRepeatIntervalItems(Object repeatIntervalItems) {
        this.repeatIntervalItems = repeatIntervalItems;
    }

    public String getRepeatIntervalLabel() {
        if (this.repeatIntervalLabel != null) {
            return this.repeatIntervalLabel;
        }
        ValueExpression _vb = this.getValueExpression(REPEAT_INTERVAL_LABEL_FACET);
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setRepeatIntervalLabel(String repeatIntervalLabel) {
        this.repeatIntervalLabel = repeatIntervalLabel;
    }

    public String getRepeatLimitLabel() {
        if (this.repeatLimitLabel != null) {
            return this.repeatLimitLabel;
        }
        ValueExpression _vb = this.getValueExpression(REPEAT_LIMIT_LABEL_FACET);
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setRepeatLimitLabel(String repeatLimitLabel) {
        this.repeatLimitLabel = repeatLimitLabel;
    }

    private Object _getRepeatUnitItems() {
        if (this.repeatUnitItems != null) {
            return this.repeatUnitItems;
        }
        ValueExpression _vb = this.getValueExpression("repeatUnitItems");
        if (_vb != null) {
            return _vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setRepeatUnitItems(Object repeatUnitItems) {
        this.repeatUnitItems = repeatUnitItems;
    }

    public boolean isRepeating() {
        if (this.repeating_set) {
            return this.repeating;
        }
        ValueExpression _vb = this.getValueExpression("repeating");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return true;
    }

    public void setRepeating(boolean repeating) {
        this.repeating = repeating;
        this.repeating_set = true;
    }

    public boolean isRequired() {
        if (this.required_set) {
            return this.required;
        }
        ValueExpression _vb = this.getValueExpression("required");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return true;
    }

    public void setRequired(boolean required) {
        this.required = required;
        this.required_set = true;
    }

    public boolean isRequiredLegend() {
        if (this.requiredLegend_set) {
            return this.requiredLegend;
        }
        ValueExpression _vb = this.getValueExpression("requiredLegend");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return true;
    }

    public void setRequiredLegend(boolean requiredLegend) {
        this.requiredLegend = requiredLegend;
        this.requiredLegend_set = true;
    }

    public boolean isStartTime() {
        if (this.startTime_set) {
            return this.startTime;
        }
        ValueExpression _vb = this.getValueExpression(START_TIME_FACET);
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return true;
    }

    public void setStartTime(boolean startTime) {
        this.startTime = startTime;
        this.startTime_set = true;
    }

    public String getStartTimeLabel() {
        if (this.startTimeLabel != null) {
            return this.startTimeLabel;
        }
        ValueExpression _vb = this.getValueExpression(START_TIME_LABEL_FACET);
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStartTimeLabel(String startTimeLabel) {
        this.startTimeLabel = startTimeLabel;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueExpression _vb = this.getValueExpression("style");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        ValueExpression _vb = this.getValueExpression("styleClass");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public int getTabIndex() {
        if (this.tabIndex_set) {
            return this.tabIndex;
        }
        ValueExpression _vb = this.getValueExpression("tabIndex");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)_result;
        }
        return Integer.MIN_VALUE;
    }

    public void setTabIndex(int tabIndex) {
        this.tabIndex = tabIndex;
        this.tabIndex_set = true;
    }

    public TimeZone getTimeZone() {
        if (this.timeZone != null) {
            return this.timeZone;
        }
        ValueExpression _vb = this.getValueExpression("timeZone");
        if (_vb != null) {
            return (TimeZone)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public boolean isVisible() {
        if (this.visible_set) {
            return this.visible;
        }
        ValueExpression _vb = this.getValueExpression("visible");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return true;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.visible_set = true;
    }

    public void restoreState(FacesContext _context, Object _state) {
        Object[] _values = (Object[])_state;
        super.restoreState(_context, _values[0]);
        this.dateFormatPattern = (String)_values[1];
        this.dateFormatPatternHelp = (String)_values[2];
        this.dateLabel = (String)_values[3];
        this.disabled = (Boolean)_values[4];
        this.disabled_set = (Boolean)_values[5];
        this.endTime = (Boolean)_values[6];
        this.endTime_set = (Boolean)_values[7];
        this.endTimeLabel = (String)_values[8];
        this.limitRepeating = (Boolean)_values[9];
        this.limitRepeating_set = (Boolean)_values[10];
        this.maxDate = (Date)_values[11];
        this.minDate = (Date)_values[12];
        this.previewButton = (Boolean)_values[13];
        this.previewButton_set = (Boolean)_values[14];
        this.readOnly = (Boolean)_values[15];
        this.readOnly_set = (Boolean)_values[16];
        this.repeatIntervalItems = _values[17];
        this.repeatIntervalLabel = (String)_values[18];
        this.repeatLimitLabel = (String)_values[19];
        this.repeatUnitItems = _values[20];
        this.repeating = (Boolean)_values[21];
        this.repeating_set = (Boolean)_values[22];
        this.required = (Boolean)_values[23];
        this.required_set = (Boolean)_values[24];
        this.requiredLegend = (Boolean)_values[25];
        this.requiredLegend_set = (Boolean)_values[26];
        this.startTime = (Boolean)_values[27];
        this.startTime_set = (Boolean)_values[28];
        this.startTimeLabel = (String)_values[29];
        this.style = (String)_values[30];
        this.styleClass = (String)_values[31];
        this.tabIndex = (Integer)_values[32];
        this.tabIndex_set = (Boolean)_values[33];
        this.timeZone = (TimeZone)_values[34];
        this.visible = (Boolean)_values[35];
        this.visible_set = (Boolean)_values[36];
    }

    public Object saveState(FacesContext _context) {
        Object[] _values = new Object[]{super.saveState(_context), this.dateFormatPattern, this.dateFormatPatternHelp, this.dateLabel, this.disabled ? Boolean.TRUE : Boolean.FALSE, this.disabled_set ? Boolean.TRUE : Boolean.FALSE, this.endTime ? Boolean.TRUE : Boolean.FALSE, this.endTime_set ? Boolean.TRUE : Boolean.FALSE, this.endTimeLabel, this.limitRepeating ? Boolean.TRUE : Boolean.FALSE, this.limitRepeating_set ? Boolean.TRUE : Boolean.FALSE, this.maxDate, this.minDate, this.previewButton ? Boolean.TRUE : Boolean.FALSE, this.previewButton_set ? Boolean.TRUE : Boolean.FALSE, this.readOnly ? Boolean.TRUE : Boolean.FALSE, this.readOnly_set ? Boolean.TRUE : Boolean.FALSE, this.repeatIntervalItems, this.repeatIntervalLabel, this.repeatLimitLabel, this.repeatUnitItems, this.repeating ? Boolean.TRUE : Boolean.FALSE, this.repeating_set ? Boolean.TRUE : Boolean.FALSE, this.required ? Boolean.TRUE : Boolean.FALSE, this.required_set ? Boolean.TRUE : Boolean.FALSE, this.requiredLegend ? Boolean.TRUE : Boolean.FALSE, this.requiredLegend_set ? Boolean.TRUE : Boolean.FALSE, this.startTime ? Boolean.TRUE : Boolean.FALSE, this.startTime_set ? Boolean.TRUE : Boolean.FALSE, this.startTimeLabel, this.style, this.styleClass, new Integer(this.tabIndex), this.tabIndex_set ? Boolean.TRUE : Boolean.FALSE, this.timeZone, this.visible ? Boolean.TRUE : Boolean.FALSE, this.visible_set ? Boolean.TRUE : Boolean.FALSE};
        return _values;
    }
}

