/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.faces;

import com.sun.webui.jsf.theme.ThemeImages;
import com.sun.webui.jsf.theme.ThemeJavascript;
import com.sun.webui.jsf.theme.ThemeStyles;
import com.sun.webui.jsf.theme.ThemeTemplates;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.beans.FeatureDescriptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThemeELResolver
extends ELResolver {
    private final String THEME_IMAGES = "themeImages";
    private final String THEME_JAVASCRIPT = "themeJavascript";
    private final String THEME_MESSAGES = "themeMessages";
    private final String THEME_STYLES = "themeStyles";
    private final String THEME_TEMPLATES = "themeTemplates";

    public Object getValue(ELContext context, Object base, Object property) {
        if (property == null) {
            throw new PropertyNotFoundException("Property cannot be null.");
        }
        if (context == null) {
            throw new NullPointerException();
        }
        Object result = null;
        if (base != null) {
            if (base instanceof Images) {
                result = ((Images)base).getValue(property.toString());
                context.setPropertyResolved(true);
            } else if (base instanceof Javascript) {
                result = ((Javascript)base).getValue(property.toString());
                context.setPropertyResolved(true);
            } else if (base instanceof Messages) {
                result = ((Messages)base).getValue(property.toString());
                context.setPropertyResolved(true);
            } else if (base instanceof Styles) {
                result = ((Styles)base).getValue(property.toString());
                context.setPropertyResolved(true);
            } else if (base instanceof Templates) {
                result = ((Templates)base).getValue(property.toString());
                context.setPropertyResolved(true);
            }
        } else if ("themeImages".equals(property)) {
            result = new Images();
            context.setPropertyResolved(true);
        } else if ("themeJavascript".equals(property)) {
            result = new Javascript();
            context.setPropertyResolved(true);
        } else if ("themeMessages".equals(property)) {
            result = new Messages();
            context.setPropertyResolved(true);
        } else if ("themeStyles".equals(property)) {
            result = new Styles();
            context.setPropertyResolved(true);
        } else if ("themeTemplates".equals(property)) {
            result = new Templates();
            context.setPropertyResolved(true);
        }
        return result;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (base != null) {
            return;
        }
        if (property == null) {
            throw new PropertyNotFoundException("Property cannot be null.");
        }
        if (base != null ? base instanceof Images || base instanceof Javascript || base instanceof Messages || base instanceof Styles || base instanceof Templates : "themeImages".equals(property) || "themeJavascript".equals(property) || "themeMessages".equals(property) || "themeStyles".equals(property) || "themeTemplates".equals(property)) {
            throw new PropertyNotWritableException(property.toString());
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (property == null) {
            throw new PropertyNotFoundException("Property cannot be null.");
        }
        if (context == null) {
            throw new NullPointerException();
        }
        boolean result = false;
        if (base != null) {
            if (base instanceof Images || base instanceof Javascript || base instanceof Messages || base instanceof Styles || base instanceof Templates) {
                result = true;
                context.setPropertyResolved(true);
            }
        } else if ("themeImages".equals(property) || "themeJavascript".equals(property) || "themeMessages".equals(property) || "themeStyles".equals(property) || "themeTemplates".equals(property)) {
            result = true;
            context.setPropertyResolved(true);
        }
        return result;
    }

    public Class getType(ELContext context, Object base, Object property) {
        if (property == null) {
            throw new PropertyNotFoundException("Property cannot be null.");
        }
        if (context == null) {
            throw new NullPointerException();
        }
        Class<String> result = null;
        if (base != null) {
            if (base instanceof Images || base instanceof Javascript || base instanceof Messages || base instanceof Styles || base instanceof Templates) {
                result = String.class;
                context.setPropertyResolved(true);
            }
        } else if ("themeImages".equals(property) || "themeJavascript".equals(property) || "themeMessages".equals(property) || "themeStyles".equals(property) || "themeTemplates".equals(property)) {
            result = String.class;
            context.setPropertyResolved(true);
        }
        return result;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (base != null) {
            return null;
        }
        if (context == null) {
            throw new NullPointerException();
        }
        ArrayList<FeatureDescriptor> result = new ArrayList<FeatureDescriptor>();
        result.add(this.getFeatureDescriptor("themeImages", String.class));
        result.add(this.getFeatureDescriptor("themeJavascript", String.class));
        result.add(this.getFeatureDescriptor("themeMessages", String.class));
        result.add(this.getFeatureDescriptor("themeStyles", String.class));
        result.add(this.getFeatureDescriptor("themeTemplates", String.class));
        return result.iterator();
    }

    public Class getCommonPropertyType(ELContext context, Object base) {
        if (base != null) {
            return null;
        }
        return String.class;
    }

    private FeatureDescriptor getFeatureDescriptor(String name, Class clazz) {
        FeatureDescriptor desc = new FeatureDescriptor();
        desc.setName(name);
        desc.setDisplayName(name);
        desc.setValue("type", clazz);
        desc.setValue("resolvableAtDesignTime", true);
        return desc;
    }

    private class Templates {
        private Templates() {
        }

        public Object getValue(String property) {
            if (property == null) {
                throw new PropertyNotFoundException("Property cannot be null.");
            }
            String result = null;
            Theme theme = ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
            try {
                Field field = ThemeTemplates.class.getField(property);
                result = theme.getPathToTemplate(field.get(null).toString());
            }
            catch (Exception e) {
                result = theme.getPathToTemplate(property);
            }
            return result;
        }
    }

    private class Styles {
        private Styles() {
        }

        public Object getValue(String property) {
            if (property == null) {
                throw new PropertyNotFoundException("Property cannot be null.");
            }
            String result = null;
            Theme theme = ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
            try {
                Field field = ThemeStyles.class.getField(property);
                result = theme.getStyleClass(field.get(null).toString());
            }
            catch (Exception e) {
                result = theme.getStyleClass(property);
            }
            return result;
        }
    }

    private class Messages {
        private Messages() {
        }

        public Object getValue(String property) {
            if (property == null) {
                throw new PropertyNotFoundException("Property cannot be null.");
            }
            String result = null;
            Theme theme = ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
            result = theme.getMessage(property);
            return result;
        }
    }

    private class Javascript {
        private static final String JS_PREFIX = "JS_PREFIX";
        private static final String MODULE_PATH = "MODULE_PATH";
        private static final String MODULE_PREFIX = "MODULE_PREFIX";

        private Javascript() {
        }

        public Object getValue(String property) {
            if (property == null) {
                throw new PropertyNotFoundException("Property cannot be null.");
            }
            String result = null;
            Theme theme = ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
            try {
                Field field = ThemeJavascript.class.getField(property);
                String value = field.get(null).toString();
                result = JS_PREFIX.equals(property) || MODULE_PATH.equals(property) || MODULE_PREFIX.equals(property) ? theme.getJSString(value) : theme.getPathToJSFile(value);
            }
            catch (Exception e) {
                result = theme.getJSString(property);
            }
            return result;
        }
    }

    private class Images {
        private static final String HEIGHT_SUFFIX = "_HEIGHT";
        private static final String WIDTH_SUFFIX = "_WIDTH";
        private static final String ALT_SUFFIX = "_ALT";

        private Images() {
        }

        public Object getValue(String property) {
            if (property == null) {
                throw new PropertyNotFoundException("Property cannot be null.");
            }
            String result = null;
            Theme theme = ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
            try {
                Field field = ThemeImages.class.getField(property);
                String value = field.get(null).toString();
                result = property.endsWith(ALT_SUFFIX) ? theme.getMessage(theme.getImageString(value)) : (property.endsWith(HEIGHT_SUFFIX) ? theme.getImageString(value) : (property.endsWith(WIDTH_SUFFIX) ? theme.getImageString(value) : theme.getImage(value).getPath()));
            }
            catch (Exception e) {
                result = theme.getImageString(property);
            }
            return result;
        }
    }
}

