/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.probe;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.weld.probe.Strings;

class HtmlTag {
    static final String HTML = "html";
    static final String BODY = "body";
    static final String TITLE = "title";
    static final String H = "h";
    static final String P = "p";
    static final String PRE = "pre";
    static final String DIV = "div";
    static final String TABLE = "table";
    static final String TR = "tr";
    static final String TD = "td";
    static final String TH = "th";
    static final String STYLE = "style";
    static final String HEAD = "head";
    static final String A = "a";
    static final String OL = "ol";
    static final String LI = "li";
    static final String STRONG = "strong";
    static final SafeString BR = SafeString.of("<br>");
    static final String CLASS = "class";
    private final String name;
    private Map<String, String> attrs;
    private final List<Object> contents;

    static HtmlTag of(String name) {
        return new HtmlTag(name);
    }

    static HtmlTag html() {
        return HtmlTag.of(HTML);
    }

    static HtmlTag head() {
        return HtmlTag.of(HEAD);
    }

    static HtmlTag style() {
        return HtmlTag.of(STYLE);
    }

    static HtmlTag body() {
        return HtmlTag.of(BODY);
    }

    static HtmlTag title(String value) {
        return HtmlTag.of(TITLE).add(value);
    }

    static HtmlTag h1(String value) {
        return HtmlTag.h(1, value);
    }

    static HtmlTag h2(String value) {
        return HtmlTag.h(2, value);
    }

    static HtmlTag h(int level, String value) {
        return HtmlTag.of(H + level).add(value);
    }

    static HtmlTag p(String value) {
        return HtmlTag.of(P).add(value);
    }

    static HtmlTag pre(String value) {
        return HtmlTag.of(PRE).add(value);
    }

    static HtmlTag div(String id) {
        return HtmlTag.div().attr("id", id);
    }

    static HtmlTag div() {
        return HtmlTag.of(DIV);
    }

    static HtmlTag table() {
        return HtmlTag.of(TABLE);
    }

    static HtmlTag stripedTable() {
        return HtmlTag.of(TABLE).attr(CLASS, "table-striped");
    }

    static HtmlTag tr() {
        return HtmlTag.of(TR);
    }

    static HtmlTag th(String value) {
        return HtmlTag.of(TH).add(value);
    }

    static HtmlTag td() {
        return HtmlTag.of(TD);
    }

    static HtmlTag td(String value) {
        return HtmlTag.td().add(value);
    }

    static HtmlTag a(String href) {
        return HtmlTag.of(A).attr("href", href);
    }

    static HtmlTag aname(String name) {
        return HtmlTag.of(A).attr("name", name);
    }

    static HtmlTag ol() {
        return HtmlTag.of(OL);
    }

    static HtmlTag li() {
        return HtmlTag.of(LI);
    }

    static HtmlTag strong(String text) {
        return HtmlTag.of(STRONG).add(text);
    }

    private HtmlTag(String name) {
        this.name = name;
        this.contents = new LinkedList<Object>();
    }

    HtmlTag attr(String name, String value) {
        if (this.attrs == null) {
            this.attrs = new HashMap<String, String>();
        }
        this.attrs.put(name, value);
        return this;
    }

    HtmlTag add(Object ... contents) {
        for (Object content : contents) {
            this.contents.add(content);
        }
        return this;
    }

    HtmlTag appendTo(HtmlTag parent) {
        parent.add(this);
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<");
        builder.append(this.name);
        if (this.attrs != null && !this.attrs.isEmpty()) {
            for (Map.Entry entry : this.attrs.entrySet()) {
                builder.append(" ");
                builder.append((String)entry.getKey());
                builder.append("=");
                builder.append("\"");
                builder.append((String)entry.getValue());
                builder.append("\"");
            }
        }
        builder.append(">");
        for (Object object : this.contents) {
            if (object instanceof HtmlTag || object instanceof SafeString) {
                builder.append(object.toString());
                continue;
            }
            builder.append(Strings.escape(object.toString()));
        }
        builder.append("<");
        builder.append("/");
        builder.append(this.name);
        builder.append(">");
        return builder.toString();
    }

    static class SafeString {
        private final String value;

        static SafeString of(String value) {
            return new SafeString(value);
        }

        private SafeString(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value.toString();
        }
    }
}

