/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.features.undoredo;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.glsp.graph.GModelRoot;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.ActionHandler;
import org.eclipse.glsp.server.actions.SetDirtyStateAction;
import org.eclipse.glsp.server.features.core.model.RequestBoundsAction;
import org.eclipse.glsp.server.features.undoredo.RedoAction;
import org.eclipse.glsp.server.features.undoredo.UndoAction;
import org.eclipse.glsp.server.model.GModelState;

public class UndoRedoActionHandler
implements ActionHandler {
    private static final Logger LOG = Logger.getLogger(UndoRedoActionHandler.class);

    @Override
    public List<Action> execute(Action action, GModelState modelState) {
        if (action instanceof UndoAction && modelState.canUndo()) {
            modelState.undo();
            return this.listOf(new RequestBoundsAction((GModelRoot)modelState.getRoot()), new SetDirtyStateAction(modelState.isDirty()));
        }
        if (action instanceof RedoAction && modelState.canRedo()) {
            modelState.redo();
            return this.listOf(new RequestBoundsAction((GModelRoot)modelState.getRoot()), new SetDirtyStateAction(modelState.isDirty()));
        }
        LOG.warn((Object)"Cannot undo or redo");
        return this.none();
    }

    @Override
    public List<Class<? extends Action>> getHandledActionTypes() {
        return Lists.newArrayList((Object[])new Class[]{UndoAction.class, RedoAction.class});
    }
}

