/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.example.workflow.taskedit;

import com.google.inject.Inject;
import java.util.Optional;
import org.eclipse.glsp.example.workflow.taskedit.EditTaskOperation;
import org.eclipse.glsp.example.workflow.wfgraph.TaskNode;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.operations.AbstractOperationHandler;
import org.eclipse.glsp.server.types.GLSPServerException;

public class EditTaskOperationHandler
extends AbstractOperationHandler<EditTaskOperation> {
    @Inject
    protected GModelState modelState;

    protected void executeOperation(EditTaskOperation operation) {
        Optional task = this.modelState.getIndex().findElementByClass(operation.getTaskId(), TaskNode.class);
        if (task.isEmpty()) {
            throw new RuntimeException("Cannot find task with id '" + operation.getTaskId() + "'");
        }
        switch (operation.getFeature()) {
            case "duration": {
                ((TaskNode)task.get()).setDuration(Integer.parseInt(operation.getValue()));
                break;
            }
            case "taskType": {
                ((TaskNode)task.get()).setTaskType(operation.getValue());
                break;
            }
            default: {
                throw new GLSPServerException("Cannot edit task at feature '" + operation.getFeature() + "'");
            }
        }
    }
}

