/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.graph.util;

import org.eclipse.glsp.graph.GBounds;
import org.eclipse.glsp.graph.GDimension;
import org.eclipse.glsp.graph.GPoint;
import org.eclipse.glsp.graph.GraphFactory;

public final class GraphUtil {
    private GraphUtil() {
    }

    public static GBounds bounds(double x, double y, double width, double height) {
        GBounds bounds = GraphFactory.eINSTANCE.createGBounds();
        bounds.setX(x);
        bounds.setY(y);
        bounds.setWidth(width);
        bounds.setHeight(height);
        return bounds;
    }

    public static GBounds copy(GBounds toCopy) {
        return GraphUtil.bounds(toCopy.getX(), toCopy.getY(), toCopy.getWidth(), toCopy.getHeight());
    }

    public static GPoint point(double x, double y) {
        GPoint point = GraphFactory.eINSTANCE.createGPoint();
        point.setX(x);
        point.setY(y);
        return point;
    }

    public static GPoint copy(GPoint toCopy) {
        return GraphUtil.point(toCopy.getX(), toCopy.getY());
    }

    public static GDimension dimension(double width, double height) {
        GDimension dimension = GraphFactory.eINSTANCE.createGDimension();
        dimension.setWidth(width);
        dimension.setHeight(height);
        return dimension;
    }

    public static GDimension copy(GDimension toCopy) {
        return GraphUtil.dimension(toCopy.getWidth(), toCopy.getHeight());
    }
}

