/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.features.progress;

import java.util.Optional;
import org.eclipse.glsp.server.actions.Action;

public class StartProgressAction
extends Action {
    public static final String KIND = "startProgress";
    private static final int NO_PERCENTAGE = -1;
    private String progressId;
    private String title;
    private String message;
    private int percentage;

    public StartProgressAction() {
        super(KIND);
    }

    public StartProgressAction(String progressId, String title) {
        this();
        this.progressId = progressId;
        this.title = title;
        this.percentage = -1;
    }

    public StartProgressAction(String progressId, String title, String message) {
        this(progressId, title);
        this.message = message;
        this.percentage = -1;
    }

    public StartProgressAction(String progressId, String title, String message, int percentage) {
        this(progressId, title, message);
        this.percentage = percentage;
    }

    public StartProgressAction(String progressId, String title, int percentage) {
        this(progressId, title);
        this.percentage = percentage;
    }

    public void setProgressId(String progressId) {
        this.progressId = progressId;
    }

    public String getProgressId() {
        return this.progressId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    public void setPercentage(int percentage) {
        this.percentage = percentage;
    }

    public Optional<Integer> getPercentage() {
        if (this.percentage == -1) {
            return Optional.empty();
        }
        return Optional.of(this.percentage);
    }
}

