/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.core.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.core.service.ProviderPriority;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.common.core.util.EnumeratedType;

public abstract class ExecutionStrategy
extends EnumeratedType {
    public static final ProviderPriority[] PRIORITIES = new ProviderPriority[]{ProviderPriority.HIGHEST, ProviderPriority.HIGH, ProviderPriority.MEDIUM, ProviderPriority.LOW, ProviderPriority.LOWEST};
    private static int nextOrdinal = 0;
    public static final ExecutionStrategy FIRST = new ExecutionStrategy("First"){
        private static final long serialVersionUID = 1L;

        public List execute(Service service, IOperation operation) {
            int i = 0;
            while (i < PRIORITIES.length) {
                List providers = service.getProviders(this, PRIORITIES[i], operation);
                if (providers.size() != 0) {
                    return Collections.singletonList(operation.execute((IProvider)providers.get(0)));
                }
                ++i;
            }
            return Collections.EMPTY_LIST;
        }

        public List getUncachedProviders(Service service, ProviderPriority priority, IOperation operation) {
            List descriptors = service.getProviders(priority);
            int size = descriptors.size();
            int i = 0;
            while (i < size) {
                Service.ProviderDescriptor descriptor = (Service.ProviderDescriptor)descriptors.get(i);
                if (Service.safeProvides(descriptor, operation)) {
                    return Collections.singletonList(descriptor.getProvider());
                }
                ++i;
            }
            return Collections.EMPTY_LIST;
        }
    };
    public static final ExecutionStrategy LAST = new ExecutionStrategy("Last"){
        private static final long serialVersionUID = 1L;

        public List execute(Service service, IOperation operation) {
            int i = PRIORITIES.length;
            while (--i >= 0) {
                List providers = service.getProviders(this, PRIORITIES[i], operation);
                int size = providers.size();
                if (size == 0) continue;
                return Collections.singletonList(operation.execute((IProvider)providers.get(size - 1)));
            }
            return Collections.EMPTY_LIST;
        }

        public List getUncachedProviders(Service service, ProviderPriority priority, IOperation operation) {
            List descriptors = service.getProviders(priority);
            int i = descriptors.size();
            while (--i >= 0) {
                Service.ProviderDescriptor descriptor = (Service.ProviderDescriptor)descriptors.get(i);
                if (!Service.safeProvides(descriptor, operation)) continue;
                return Collections.singletonList(descriptor.getProvider());
            }
            return Collections.EMPTY_LIST;
        }
    };
    public static final ExecutionStrategy FORWARD = new ExecutionStrategy("Forward"){
        private static final long serialVersionUID = 1L;

        public List execute(Service service, IOperation operation) {
            ArrayList<Object> results = new ArrayList<Object>();
            int i = 0;
            while (i < PRIORITIES.length) {
                List providers = service.getProviders(this, PRIORITIES[i], operation);
                int size = providers.size();
                int j = 0;
                while (j < size) {
                    results.add(operation.execute((IProvider)providers.get(j)));
                    ++j;
                }
                ++i;
            }
            return results;
        }
    };
    public static final ExecutionStrategy REVERSE = new ExecutionStrategy("Reverse"){
        private static final long serialVersionUID = 1L;

        public List execute(Service service, IOperation operation) {
            ArrayList<Object> results = new ArrayList<Object>();
            int i = PRIORITIES.length;
            while (--i >= 0) {
                List providers = service.getProviders(this, PRIORITIES[i], operation);
                int j = providers.size();
                while (--j >= 0) {
                    results.add(operation.execute((IProvider)providers.get(j)));
                }
            }
            return results;
        }
    };
    private static final ExecutionStrategy[] VALUES = new ExecutionStrategy[]{FIRST, LAST, FORWARD, REVERSE};

    protected ExecutionStrategy(String name) {
        super(name, nextOrdinal++);
    }

    protected ExecutionStrategy(String name, int ordinal) {
        super(name, ordinal);
    }

    protected List getValues() {
        return Collections.unmodifiableList(Arrays.asList(VALUES));
    }

    public abstract List execute(Service var1, IOperation var2);

    public List getUncachedProviders(Service service, ProviderPriority priority, IOperation operation) {
        List descriptors = service.getProviders(priority);
        int size = descriptors.size();
        ArrayList<IProvider> providers = new ArrayList<IProvider>(size);
        int i = 0;
        while (i < size) {
            Service.ProviderDescriptor descriptor = (Service.ProviderDescriptor)descriptors.get(i);
            if (Service.safeProvides(descriptor, operation)) {
                providers.add(descriptor.getProvider());
            }
            ++i;
        }
        return providers;
    }

    protected final List getProviders(Service service, ProviderPriority priority) {
        return service.getProviders(priority);
    }

    protected final List getProviders(Service service, ExecutionStrategy strategy, ProviderPriority priority, IOperation operation) {
        return service.getProviders(strategy, priority, operation);
    }
}

