/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.printing.render.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.util.DisplayUtils;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.DiagramPrintingDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.DiagramPrintingPlugin;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.l10n.DiagramUIPrintingMessages;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.util.DiagramPrinterHelper;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.internal.JPSDiagramPrinter;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.util.PrintHelper;
import org.eclipse.gmf.runtime.diagram.ui.printing.util.DiagramPrinterUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPSDiagramPrinterHelper
extends DiagramPrinterHelper {
    private static JPSDiagramPrinterHelper jpsDiagramPrinterHelper;

    public static JPSDiagramPrinterHelper getDiagramPrinterHelper() {
        if (jpsDiagramPrinterHelper == null) {
            jpsDiagramPrinterHelper = new JPSDiagramPrinterHelper();
        }
        return jpsDiagramPrinterHelper;
    }

    private JPSDiagramPrinterHelper() {
    }

    public void printWithSettings(IEditorPart editorPart, Map<String, Diagram> diagramMap, JPSDiagramPrinter jpsDiagramPrinter) {
        Display display = DisplayUtils.getDisplay();
        try {
            PrintHelper helper = new PrintHelper();
            ArrayList<String> diagramNames = new ArrayList<String>(diagramMap.keySet());
            PrinterData printerData = this.collectPrintInformation(jpsDiagramPrinter, helper, diagramNames, editorPart, diagramMap);
            if (printerData != null) {
                jpsDiagramPrinter.setPrinter(printerData.name);
                jpsDiagramPrinter.setDisplayDPI(display.getDPI());
                jpsDiagramPrinter.setPrintHelper(helper);
                if (helper.getDlgDiagramPrintRangeCurrent()) {
                    DiagramEditPart dgrmEP = ((IDiagramWorkbenchPart)editorPart).getDiagramEditPart();
                    assert (dgrmEP != null);
                    jpsDiagramPrinter.setDiagrams(Collections.singletonList(dgrmEP.getDiagramView().getDiagram()));
                } else if (helper.getDlgDiagramPrintRangeAll()) {
                    jpsDiagramPrinter.setDiagrams(diagramMap.values());
                } else if (helper.getDlgDiagramPrintRangeSelection()) {
                    ArrayList<Diagram> list = new ArrayList<Diagram>();
                    int i = 0;
                    while (i < diagramNames.size()) {
                        Diagram obj;
                        if (helper.isDlgDiagramSelected(i) && (obj = diagramMap.get(diagramNames.get(i))) instanceof Diagram) {
                            list.add(obj);
                        }
                        ++i;
                    }
                    jpsDiagramPrinter.setDiagrams(list);
                }
                this.printDiagrams(jpsDiagramPrinter, helper);
            }
        }
        catch (Throwable e) {
            Trace.catching((Plugin)DiagramPrintingPlugin.getInstance(), (String)DiagramPrintingDebugOptions.EXCEPTIONS_CATCHING, DiagramPrinterUtil.class, (String)e.getMessage(), (Throwable)e);
            Log.warning((Plugin)DiagramPrintingPlugin.getInstance(), (int)5, (String)e.getMessage(), (Throwable)e);
            MessageDialog.openError((Shell)display.getActiveShell(), (String)DiagramUIPrintingMessages.JPSDiagramPrinterUtil_ErrorTitle, (String)DiagramUIPrintingMessages.JPSDiagramPrinterUtil_ErrorMessage);
        }
    }
}

