/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.cli;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.dns.AddressResolverOptions;
import org.eclipse.hono.application.client.ApplicationClient;
import org.eclipse.hono.application.client.amqp.AmqpMessageContext;
import org.eclipse.hono.application.client.amqp.ProtonBasedApplicationClient;
import org.eclipse.hono.application.client.kafka.KafkaMessageContext;
import org.eclipse.hono.application.client.kafka.impl.KafkaApplicationClientImpl;
import org.eclipse.hono.client.ApplicationClientFactory;
import org.eclipse.hono.client.HonoConnection;
import org.eclipse.hono.client.kafka.KafkaProducerConfigProperties;
import org.eclipse.hono.client.kafka.KafkaProducerFactory;
import org.eclipse.hono.client.kafka.consumer.KafkaConsumerConfigProperties;
import org.eclipse.hono.config.ClientConfigProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
public class AppConfiguration {
    @Bean
    public Vertx vertx() {
        VertxOptions options = new VertxOptions().setWarningExceptionTime(1500000000L).setAddressResolverOptions(this.addressResolverOptions());
        return Vertx.vertx((VertxOptions)options);
    }

    @ConfigurationProperties(prefix="address.resolver")
    @Bean
    public AddressResolverOptions addressResolverOptions() {
        AddressResolverOptions addressResolverOptions = new AddressResolverOptions();
        return addressResolverOptions;
    }

    @ConfigurationProperties(prefix="hono.client")
    @Bean
    public ClientConfigProperties honoClientConfig() {
        ClientConfigProperties config = new ClientConfigProperties();
        return config;
    }

    @ConfigurationProperties(prefix="hono.kafka")
    @Profile(value={"kafka"})
    @Bean
    public KafkaConsumerConfigProperties honoKafkaClientConfig() {
        return new KafkaConsumerConfigProperties();
    }

    @ConfigurationProperties(prefix="hono.kafka")
    @Profile(value={"kafka"})
    @Bean
    public KafkaProducerConfigProperties kafkaProducerConfig() {
        return new KafkaProducerConfigProperties();
    }

    @Profile(value={"kafka"})
    @Bean
    public KafkaProducerFactory<String, Buffer> kafkaProducerFactory() {
        return KafkaProducerFactory.sharedProducerFactory((Vertx)this.vertx());
    }

    @Bean
    public ApplicationClientFactory clientFactory() {
        return ApplicationClientFactory.create((HonoConnection)HonoConnection.newConnection((Vertx)this.vertx(), (ClientConfigProperties)this.honoClientConfig()));
    }

    @Profile(value={"!kafka"})
    @Bean
    public ApplicationClient<AmqpMessageContext> AmqpApplicationClient(Vertx vertx, ClientConfigProperties clientConfig) {
        return new ProtonBasedApplicationClient(HonoConnection.newConnection((Vertx)vertx, (ClientConfigProperties)clientConfig));
    }

    @Profile(value={"kafka"})
    @Bean
    public ApplicationClient<KafkaMessageContext> kafkaApplicationClient(Vertx vertx, KafkaConsumerConfigProperties kafkaConsumerConfigProperties, KafkaProducerFactory<String, Buffer> producerFactory, KafkaProducerConfigProperties kafkaProducerConfigProperties) {
        return new KafkaApplicationClientImpl(vertx, kafkaConsumerConfigProperties, producerFactory, kafkaProducerConfigProperties);
    }
}

