/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.HTTPRouteStatus;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.HTTPRouteStatusFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.RouteParentStatus;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.RouteParentStatusBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.RouteParentStatusFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class HTTPRouteStatusFluentImpl<A extends HTTPRouteStatusFluent<A>>
extends BaseFluent<A>
implements HTTPRouteStatusFluent<A> {
    private ArrayList<RouteParentStatusBuilder> parents = new ArrayList();
    private Map<String, Object> additionalProperties;

    public HTTPRouteStatusFluentImpl() {
    }

    public HTTPRouteStatusFluentImpl(HTTPRouteStatus instance) {
        this.withParents(instance.getParents());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToParents(Integer index, RouteParentStatus item) {
        if (this.parents == null) {
            this.parents = new ArrayList();
        }
        RouteParentStatusBuilder builder = new RouteParentStatusBuilder(item);
        this._visitables.get("parents").add(index >= 0 ? index.intValue() : this._visitables.get("parents").size(), builder);
        this.parents.add(index >= 0 ? index.intValue() : this.parents.size(), builder);
        return (A)this;
    }

    @Override
    public A setToParents(Integer index, RouteParentStatus item) {
        if (this.parents == null) {
            this.parents = new ArrayList();
        }
        RouteParentStatusBuilder builder = new RouteParentStatusBuilder(item);
        if (index < 0 || index >= this._visitables.get("parents").size()) {
            this._visitables.get("parents").add(builder);
        } else {
            this._visitables.get("parents").set(index, builder);
        }
        if (index < 0 || index >= this.parents.size()) {
            this.parents.add(builder);
        } else {
            this.parents.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToParents(RouteParentStatus ... items) {
        if (this.parents == null) {
            this.parents = new ArrayList();
        }
        for (RouteParentStatus item : items) {
            RouteParentStatusBuilder builder = new RouteParentStatusBuilder(item);
            this._visitables.get("parents").add(builder);
            this.parents.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToParents(Collection<RouteParentStatus> items) {
        if (this.parents == null) {
            this.parents = new ArrayList();
        }
        for (RouteParentStatus item : items) {
            RouteParentStatusBuilder builder = new RouteParentStatusBuilder(item);
            this._visitables.get("parents").add(builder);
            this.parents.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromParents(RouteParentStatus ... items) {
        for (RouteParentStatus item : items) {
            RouteParentStatusBuilder builder = new RouteParentStatusBuilder(item);
            this._visitables.get("parents").remove(builder);
            if (this.parents == null) continue;
            this.parents.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromParents(Collection<RouteParentStatus> items) {
        for (RouteParentStatus item : items) {
            RouteParentStatusBuilder builder = new RouteParentStatusBuilder(item);
            this._visitables.get("parents").remove(builder);
            if (this.parents == null) continue;
            this.parents.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromParents(Predicate<RouteParentStatusBuilder> predicate) {
        if (this.parents == null) {
            return (A)this;
        }
        Iterator<RouteParentStatusBuilder> each = this.parents.iterator();
        Object visitables = this._visitables.get("parents");
        while (each.hasNext()) {
            RouteParentStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<RouteParentStatus> getParents() {
        return this.parents != null ? HTTPRouteStatusFluentImpl.build(this.parents) : null;
    }

    @Override
    public List<RouteParentStatus> buildParents() {
        return this.parents != null ? HTTPRouteStatusFluentImpl.build(this.parents) : null;
    }

    @Override
    public RouteParentStatus buildParent(Integer index) {
        return this.parents.get(index).build();
    }

    @Override
    public RouteParentStatus buildFirstParent() {
        return this.parents.get(0).build();
    }

    @Override
    public RouteParentStatus buildLastParent() {
        return this.parents.get(this.parents.size() - 1).build();
    }

    @Override
    public RouteParentStatus buildMatchingParent(Predicate<RouteParentStatusBuilder> predicate) {
        for (RouteParentStatusBuilder item : this.parents) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingParent(Predicate<RouteParentStatusBuilder> predicate) {
        for (RouteParentStatusBuilder item : this.parents) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withParents(List<RouteParentStatus> parents) {
        if (this.parents != null) {
            this._visitables.get("parents").removeAll(this.parents);
        }
        if (parents != null) {
            this.parents = new ArrayList();
            for (RouteParentStatus item : parents) {
                this.addToParents(item);
            }
        } else {
            this.parents = null;
        }
        return (A)this;
    }

    @Override
    public A withParents(RouteParentStatus ... parents) {
        if (this.parents != null) {
            this.parents.clear();
        }
        if (parents != null) {
            for (RouteParentStatus item : parents) {
                this.addToParents(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasParents() {
        return this.parents != null && !this.parents.isEmpty();
    }

    @Override
    public HTTPRouteStatusFluent.ParentsNested<A> addNewParent() {
        return new ParentsNestedImpl();
    }

    @Override
    public HTTPRouteStatusFluent.ParentsNested<A> addNewParentLike(RouteParentStatus item) {
        return new ParentsNestedImpl(-1, item);
    }

    @Override
    public HTTPRouteStatusFluent.ParentsNested<A> setNewParentLike(Integer index, RouteParentStatus item) {
        return new ParentsNestedImpl(index, item);
    }

    @Override
    public HTTPRouteStatusFluent.ParentsNested<A> editParent(Integer index) {
        if (this.parents.size() <= index) {
            throw new RuntimeException("Can't edit parents. Index exceeds size.");
        }
        return this.setNewParentLike(index, this.buildParent(index));
    }

    @Override
    public HTTPRouteStatusFluent.ParentsNested<A> editFirstParent() {
        if (this.parents.size() == 0) {
            throw new RuntimeException("Can't edit first parents. The list is empty.");
        }
        return this.setNewParentLike(0, this.buildParent(0));
    }

    @Override
    public HTTPRouteStatusFluent.ParentsNested<A> editLastParent() {
        int index = this.parents.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last parents. The list is empty.");
        }
        return this.setNewParentLike(index, this.buildParent(index));
    }

    @Override
    public HTTPRouteStatusFluent.ParentsNested<A> editMatchingParent(Predicate<RouteParentStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.parents.size(); ++i) {
            if (!predicate.test(this.parents.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching parents. No match found.");
        }
        return this.setNewParentLike(index, this.buildParent(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HTTPRouteStatusFluentImpl that = (HTTPRouteStatusFluentImpl)o;
        if (this.parents != null ? !this.parents.equals(that.parents) : that.parents != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.parents, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.parents != null && !this.parents.isEmpty()) {
            sb.append("parents:");
            sb.append(this.parents + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ParentsNestedImpl<N>
    extends RouteParentStatusFluentImpl<HTTPRouteStatusFluent.ParentsNested<N>>
    implements HTTPRouteStatusFluent.ParentsNested<N>,
    Nested<N> {
        RouteParentStatusBuilder builder;
        Integer index;

        ParentsNestedImpl(Integer index, RouteParentStatus item) {
            this.index = index;
            this.builder = new RouteParentStatusBuilder(this, item);
        }

        ParentsNestedImpl() {
            this.index = -1;
            this.builder = new RouteParentStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPRouteStatusFluentImpl.this.setToParents(this.index, this.builder.build());
        }

        @Override
        public N endParent() {
            return this.and();
        }
    }
}

