/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.ListenerStatus;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.ListenerStatusFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.RouteGroupKind;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.RouteGroupKindBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.RouteGroupKindFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ListenerStatusFluentImpl<A extends ListenerStatusFluent<A>>
extends BaseFluent<A>
implements ListenerStatusFluent<A> {
    private Integer attachedRoutes;
    private List<Condition> conditions = new ArrayList<Condition>();
    private String name;
    private ArrayList<RouteGroupKindBuilder> supportedKinds = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ListenerStatusFluentImpl() {
    }

    public ListenerStatusFluentImpl(ListenerStatus instance) {
        this.withAttachedRoutes(instance.getAttachedRoutes());
        this.withConditions(instance.getConditions());
        this.withName(instance.getName());
        this.withSupportedKinds(instance.getSupportedKinds());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public Integer getAttachedRoutes() {
        return this.attachedRoutes;
    }

    @Override
    public A withAttachedRoutes(Integer attachedRoutes) {
        this.attachedRoutes = attachedRoutes;
        return (A)this;
    }

    @Override
    public Boolean hasAttachedRoutes() {
        return this.attachedRoutes != null;
    }

    @Override
    public A addToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(Condition ... items) {
        for (Condition item : items) {
            if (this.conditions == null) continue;
            this.conditions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<Condition> items) {
        for (Condition item : items) {
            if (this.conditions == null) continue;
            this.conditions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Override
    public Condition getCondition(Integer index) {
        return this.conditions.get(index);
    }

    @Override
    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    @Override
    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    @Override
    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A addToSupportedKinds(Integer index, RouteGroupKind item) {
        if (this.supportedKinds == null) {
            this.supportedKinds = new ArrayList();
        }
        RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);
        this._visitables.get("supportedKinds").add(index >= 0 ? index.intValue() : this._visitables.get("supportedKinds").size(), builder);
        this.supportedKinds.add(index >= 0 ? index.intValue() : this.supportedKinds.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSupportedKinds(Integer index, RouteGroupKind item) {
        if (this.supportedKinds == null) {
            this.supportedKinds = new ArrayList();
        }
        RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);
        if (index < 0 || index >= this._visitables.get("supportedKinds").size()) {
            this._visitables.get("supportedKinds").add(builder);
        } else {
            this._visitables.get("supportedKinds").set(index, builder);
        }
        if (index < 0 || index >= this.supportedKinds.size()) {
            this.supportedKinds.add(builder);
        } else {
            this.supportedKinds.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSupportedKinds(RouteGroupKind ... items) {
        if (this.supportedKinds == null) {
            this.supportedKinds = new ArrayList();
        }
        for (RouteGroupKind item : items) {
            RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);
            this._visitables.get("supportedKinds").add(builder);
            this.supportedKinds.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSupportedKinds(Collection<RouteGroupKind> items) {
        if (this.supportedKinds == null) {
            this.supportedKinds = new ArrayList();
        }
        for (RouteGroupKind item : items) {
            RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);
            this._visitables.get("supportedKinds").add(builder);
            this.supportedKinds.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSupportedKinds(RouteGroupKind ... items) {
        for (RouteGroupKind item : items) {
            RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);
            this._visitables.get("supportedKinds").remove(builder);
            if (this.supportedKinds == null) continue;
            this.supportedKinds.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSupportedKinds(Collection<RouteGroupKind> items) {
        for (RouteGroupKind item : items) {
            RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);
            this._visitables.get("supportedKinds").remove(builder);
            if (this.supportedKinds == null) continue;
            this.supportedKinds.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSupportedKinds(Predicate<RouteGroupKindBuilder> predicate) {
        if (this.supportedKinds == null) {
            return (A)this;
        }
        Iterator<RouteGroupKindBuilder> each = this.supportedKinds.iterator();
        Object visitables = this._visitables.get("supportedKinds");
        while (each.hasNext()) {
            RouteGroupKindBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<RouteGroupKind> getSupportedKinds() {
        return this.supportedKinds != null ? ListenerStatusFluentImpl.build(this.supportedKinds) : null;
    }

    @Override
    public List<RouteGroupKind> buildSupportedKinds() {
        return this.supportedKinds != null ? ListenerStatusFluentImpl.build(this.supportedKinds) : null;
    }

    @Override
    public RouteGroupKind buildSupportedKind(Integer index) {
        return this.supportedKinds.get(index).build();
    }

    @Override
    public RouteGroupKind buildFirstSupportedKind() {
        return this.supportedKinds.get(0).build();
    }

    @Override
    public RouteGroupKind buildLastSupportedKind() {
        return this.supportedKinds.get(this.supportedKinds.size() - 1).build();
    }

    @Override
    public RouteGroupKind buildMatchingSupportedKind(Predicate<RouteGroupKindBuilder> predicate) {
        for (RouteGroupKindBuilder item : this.supportedKinds) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSupportedKind(Predicate<RouteGroupKindBuilder> predicate) {
        for (RouteGroupKindBuilder item : this.supportedKinds) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSupportedKinds(List<RouteGroupKind> supportedKinds) {
        if (this.supportedKinds != null) {
            this._visitables.get("supportedKinds").removeAll(this.supportedKinds);
        }
        if (supportedKinds != null) {
            this.supportedKinds = new ArrayList();
            for (RouteGroupKind item : supportedKinds) {
                this.addToSupportedKinds(item);
            }
        } else {
            this.supportedKinds = null;
        }
        return (A)this;
    }

    @Override
    public A withSupportedKinds(RouteGroupKind ... supportedKinds) {
        if (this.supportedKinds != null) {
            this.supportedKinds.clear();
        }
        if (supportedKinds != null) {
            for (RouteGroupKind item : supportedKinds) {
                this.addToSupportedKinds(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSupportedKinds() {
        return this.supportedKinds != null && !this.supportedKinds.isEmpty();
    }

    @Override
    public A addNewSupportedKind(String group, String kind) {
        return this.addToSupportedKinds(new RouteGroupKind(group, kind));
    }

    @Override
    public ListenerStatusFluent.SupportedKindsNested<A> addNewSupportedKind() {
        return new SupportedKindsNestedImpl();
    }

    @Override
    public ListenerStatusFluent.SupportedKindsNested<A> addNewSupportedKindLike(RouteGroupKind item) {
        return new SupportedKindsNestedImpl(-1, item);
    }

    @Override
    public ListenerStatusFluent.SupportedKindsNested<A> setNewSupportedKindLike(Integer index, RouteGroupKind item) {
        return new SupportedKindsNestedImpl(index, item);
    }

    @Override
    public ListenerStatusFluent.SupportedKindsNested<A> editSupportedKind(Integer index) {
        if (this.supportedKinds.size() <= index) {
            throw new RuntimeException("Can't edit supportedKinds. Index exceeds size.");
        }
        return this.setNewSupportedKindLike(index, this.buildSupportedKind(index));
    }

    @Override
    public ListenerStatusFluent.SupportedKindsNested<A> editFirstSupportedKind() {
        if (this.supportedKinds.size() == 0) {
            throw new RuntimeException("Can't edit first supportedKinds. The list is empty.");
        }
        return this.setNewSupportedKindLike(0, this.buildSupportedKind(0));
    }

    @Override
    public ListenerStatusFluent.SupportedKindsNested<A> editLastSupportedKind() {
        int index = this.supportedKinds.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last supportedKinds. The list is empty.");
        }
        return this.setNewSupportedKindLike(index, this.buildSupportedKind(index));
    }

    @Override
    public ListenerStatusFluent.SupportedKindsNested<A> editMatchingSupportedKind(Predicate<RouteGroupKindBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.supportedKinds.size(); ++i) {
            if (!predicate.test(this.supportedKinds.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching supportedKinds. No match found.");
        }
        return this.setNewSupportedKindLike(index, this.buildSupportedKind(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListenerStatusFluentImpl that = (ListenerStatusFluentImpl)o;
        if (this.attachedRoutes != null ? !this.attachedRoutes.equals(that.attachedRoutes) : that.attachedRoutes != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.supportedKinds != null ? !this.supportedKinds.equals(that.supportedKinds) : that.supportedKinds != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.attachedRoutes, this.conditions, this.name, this.supportedKinds, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attachedRoutes != null) {
            sb.append("attachedRoutes:");
            sb.append(this.attachedRoutes + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.supportedKinds != null && !this.supportedKinds.isEmpty()) {
            sb.append("supportedKinds:");
            sb.append(this.supportedKinds + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class SupportedKindsNestedImpl<N>
    extends RouteGroupKindFluentImpl<ListenerStatusFluent.SupportedKindsNested<N>>
    implements ListenerStatusFluent.SupportedKindsNested<N>,
    Nested<N> {
        RouteGroupKindBuilder builder;
        Integer index;

        SupportedKindsNestedImpl(Integer index, RouteGroupKind item) {
            this.index = index;
            this.builder = new RouteGroupKindBuilder(this, item);
        }

        SupportedKindsNestedImpl() {
            this.index = -1;
            this.builder = new RouteGroupKindBuilder(this);
        }

        @Override
        public N and() {
            return (N)ListenerStatusFluentImpl.this.setToSupportedKinds(this.index, this.builder.build());
        }

        @Override
        public N endSupportedKind() {
            return this.and();
        }
    }
}

