/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.runtime.appcds;

import io.quarkus.runtime.PreventFurtherStepsException;
import io.quarkus.runtime.Quarkus;
import io.quarkus.runtime.annotations.Recorder;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

@Recorder
public class AppCDSRecorder {
    public void controlGenerationAndExit() {
        if (Boolean.parseBoolean(System.getProperty("quarkus.appcds.generate", "false"))) {
            final CountDownLatch latch = new CountDownLatch(1);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Quarkus.blockingExit();
                    latch.countDown();
                }
            }).start();
            try {
                latch.await(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                System.err.println("Unable to properly shutdown Quarkus application when creating AppCDS");
            }
            throw new PreventFurtherStepsException();
        }
    }
}

